/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_WEBPATH_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_UPDATEXML_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_ROOTDIR_LABEL;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * NewTomcatProjectWizardPage
 *
 */
public class NewTomcatProjectWizardPage extends WizardPage {

	/** TEXT_FIELD_WIDTH */
	private static final int TEXT_FIELD_WIDTH = 200;

	/** updateXmlCheck */
	private Button updateXmlCheck;
	/** webpathText */
	private Text webpathText;
	/** rootDirText */
	private Text rootDirText;
	/** See TomcatProjectCreationWizard.getNextPage */
	private boolean displayedOnce = false;

	/**
	 * Creates a new project creation wizard page.
	 *
	 * @param pageName the name of this page
	 */
	public NewTomcatProjectWizardPage(final String pageName) {
		super(pageName);
		setPageComplete(true);
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(final Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		createWebpathGroup(composite);
		// new Label(composite, SWT.NULL);
		createUpdateXmlGroup(composite);

		Label lbl = new Label(composite, SWT.NULL);
		lbl.setParent(composite);
		createRootDirGroup(composite);

		setErrorMessage(null);
		setMessage(null);
		setControl(composite);
	}

	/**
	 * @param parent Composite
	 */
	public void createWebpathGroup(final Composite parent) {
		Composite webpathGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		webpathGroup.setLayout(layout);
		webpathGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// location label
		Label webpathLabel = new Label(webpathGroup, SWT.NONE);
		webpathLabel.setText(WIZARD_PROJECT_WEBPATH_LABEL);
		webpathLabel.setEnabled(true);

		// project location entry field
		this.webpathText = new Text(webpathGroup, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = TEXT_FIELD_WIDTH;
		this.webpathText.setLayoutData(data);

		// see TomcatProjectCreationWizard.nextPage
		this.webpathText.setText("");
		this.webpathText.setEnabled(true);
	}

	/**
	 * @param parent Composite
	 */
	public void createUpdateXmlGroup(final Composite parent) {
		Composite updateXmlGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		updateXmlGroup.setLayout(layout);
		updateXmlGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// project location entry field
		this.updateXmlCheck = new Button(updateXmlGroup, SWT.CHECK | SWT.LEFT);
		this.updateXmlCheck.setText(WIZARD_PROJECT_UPDATEXML_LABEL);
		this.updateXmlCheck.setEnabled(true);
		this.updateXmlCheck.setSelection(true);
	}

	/**
	 * @param parent Composite
	 */
	public void createRootDirGroup(final Composite parent) {
		Composite rootDirGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		rootDirGroup.setLayout(layout);
		rootDirGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// location label
		Label rootDirLabel = new Label(rootDirGroup, SWT.NONE);
		rootDirLabel.setText(WIZARD_PROJECT_ROOTDIR_LABEL);
		rootDirLabel.setEnabled(true);

		// project location entry field
		this.rootDirText = new Text(rootDirGroup, SWT.BORDER);

		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = TEXT_FIELD_WIDTH;
		this.rootDirText.setLayoutData(data);

		// see TomcatProjectCreationWizard.nextPage
		this.rootDirText.setText("/");
		this.rootDirText.setEnabled(true);
	}

	/**
	 * @return String
	 */
	public String getWebPath() {
		return this.webpathText.getText();
	}

	/**
	 * @return String
	 */
	public String getRootDir() {
		return this.rootDirText.getText();
	}

	/**
	 * @return boolean
	 */
	public boolean getUpdateXml() {
		return this.updateXmlCheck.getSelection();
	}

	/**
	 * @param path String
	 */
	public void setWebPath(final String path) {
		this.webpathText.setText(path);
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage#canFlipToNextPage()
	 */
	@Override
	public boolean canFlipToNextPage() {
		this.displayedOnce = true;
		return super.canFlipToNextPage();
	}

	/**
	 * Gets the wasDisplayedOnce.
	 * @return Returns a boolean
	 */
	public boolean wasDisplayedOnce() {
		return this.displayedOnce;
	}
}
