/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_MANAGER_ADDUSER;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_MANAGER_BANNER;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_MANAGER_PASSWORD;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_MANAGER_URL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_MANAGER_USER;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_MANAGER_PASSWORD;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_MANAGER_URL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_MANAGER_USER;

import java.io.File;
import java.io.IOException;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * TomatApplicationManager Dialog
 */
public class TomcatManagerAppPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	/** defaultUrl */
	private static final String DEFAULT_MANAGER_URL = "http://localhost:8080/manager";
	/** urlEditor */
	private StringFieldEditor urlEditor;
	/** userEditor */
	private StringFieldEditor userEditor;
	/** pwdEditor */
	private StringFieldEditor pwdEditor;

	/**
	 * Constructor
	 */
	public TomcatManagerAppPreferencePage() {
		super(GRID);
		setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
	}

	/**
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	@Override
	protected void createFieldEditors() {
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;

		Group box = new Group(getFieldEditorParent(), SWT.NULL);
		box.setLayoutData(gd);
		box.setLayout(new GridLayout(1, true));

		Label details = new Label(box, SWT.WRAP);
		details.setText(PREF_PAGE_MANAGER_BANNER);

		Label lbl = new Label(getFieldEditorParent(), SWT.NULL);
		lbl.setParent(getFieldEditorParent());
		lbl = new Label(getFieldEditorParent(), SWT.NULL);
		lbl.setParent(getFieldEditorParent());

		this.urlEditor = new StringFieldEditor(
				TOMCAT_PREF_MANAGER_URL,
				PREF_PAGE_MANAGER_URL,
				getFieldEditorParent());
		addField(this.urlEditor);

		lbl = new Label(getFieldEditorParent(), SWT.NULL);
		lbl.setParent(getFieldEditorParent());
		lbl = new Label(getFieldEditorParent(), SWT.NULL);
		lbl.setParent(getFieldEditorParent());

		this.userEditor = new StringFieldEditor(
				TOMCAT_PREF_MANAGER_USER,
				PREF_PAGE_MANAGER_USER,
				getFieldEditorParent());
		addField(this.userEditor);

		this.pwdEditor = new StringFieldEditor(
				TOMCAT_PREF_MANAGER_PASSWORD,
				PREF_PAGE_MANAGER_PASSWORD,
				getFieldEditorParent());
		addField(this.pwdEditor);

		lbl = new Label(getFieldEditorParent(), SWT.NULL);
		lbl.setParent(getFieldEditorParent());

		Button addUserBt = new Button(getFieldEditorParent(), SWT.PUSH);
		addUserBt.setText(PREF_PAGE_MANAGER_ADDUSER);
		addUserBt.addSelectionListener(new Adapter(this.urlEditor, this.pwdEditor));
	}

	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	@Override
	public void init(final IWorkbench workbench) {
		if (!(getPreferenceStore().contains(TOMCAT_PREF_MANAGER_URL))) {
			getPreferenceStore().setValue(TOMCAT_PREF_MANAGER_URL,
							DEFAULT_MANAGER_URL);
		}
	}

	/**
	 * Adapter
	 *
	 */
	private static final class Adapter extends SelectionAdapter {

		/** userEditor */
		private final StringFieldEditor userEditor;
		/** pwdEditor */
		private final StringFieldEditor pwdEditor;

		/**
		 * Constructor
		 * @param uEditor StringFieldEditor
		 * @param pEditor StringFieldEditor
		 */
		Adapter(final StringFieldEditor uEditor, final StringFieldEditor pEditor) {
			this.userEditor = uEditor;
			this.pwdEditor = pEditor;
		}

		/**
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(final SelectionEvent e) {
			try {
				String endTag = "</tomcat-users>";
				String tomcatDir = TomcatLauncherPlugin.getTomcatDir();
				File tomcatUsersFile = new File(tomcatDir + File.separator
								+ "conf" + File.separator + "tomcat-users.xml");
				String tomcatUsersContent = FileUtil.readTextFile(tomcatUsersFile);
				String before = tomcatUsersContent.substring(0, tomcatUsersContent.indexOf(endTag));
				String username = this.userEditor.getStringValue();
				String manager = this.pwdEditor.getStringValue();
				String userTag = "  <user username=\"" + username
								+ "\" password=\"" + manager + "\" roles=\"manager\"/>\n";
				FileUtil.toTextFile(tomcatUsersFile, before + userTag + endTag);
			} catch (final IOException ex) {
				TomcatLauncherPlugin.log(ex);
			}
		}
	}
}
