package com.sysdeo.eclipse.tomcat;

import java.io.File;
import java.util.StringTokenizer;

/**
 * TomcatProjectZipper
 *
 */
public class TomcatProjectZipper extends Zipper {

	/** acceptSource */
	private final boolean acceptSource;

	/**
	 * Constructor for TomcatProjectZipper.
	 * @param outputFile File
	 * @param directory File
	 * @param accept boolean
	 */
	public TomcatProjectZipper(final File outputFile, final File directory, final boolean accept) {
		super(outputFile, directory);
		this.acceptSource = accept;
	}

	/**
	 * @see Zipper#acceptDir(File)
	 */
	@Override
	protected boolean acceptDir(final File dir) {

		if ("jsp".equals(dir.getName())) {
			if ("apache".equals(dir.getParentFile().getName())) {
				if ("org".equals(dir.getParentFile().getParentFile().getName())) {
					return false;
				}
			}
		}

		String excludeString = TomcatPluginResources.PROJECT_WAREXPORT_EXCLUDE_DIRECTORIES;
		StringTokenizer tokenizer = new StringTokenizer(excludeString, ";");
		while (tokenizer.hasMoreTokens()) {
			String eachDir = tokenizer.nextToken();
			if (dir.getName().equals(eachDir)) {
				return false;
			}
		}

		return true;
	}

	/**
	 * @see Zipper#acceptFile(File)
	 */
	@Override
	protected boolean acceptFile(final File file) {

		if (file.getName().endsWith(".java")) {
			return this.acceptSource;
		}

		String excludeString = TomcatPluginResources.PROJECT_WAREXPORT_EXCLUDE_FILES;
		StringTokenizer tokenizer = new StringTokenizer(excludeString, ";");
		while (tokenizer.hasMoreTokens()) {
			if (file.getName().equals(tokenizer.nextToken())) {
				return false;
			}
		}

		return true;
	}
}
