/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import java.io.IOException;

import org.eclipse.core.runtime.CoreException;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;

/**
 * ExportToWarActionDelegate
 *
 */
public class ExportToWarActionDelegate extends TomcatProjectAbstractActionDelegate {

	/**
	 * @see com.sysdeo.eclipse.tomcat.actions.TomcatProjectAbstractActionDelegate
	 * #doActionOn(com.sysdeo.eclipse.tomcat.TomcatProject)
	 */
	@Override
	public void doActionOn(final TomcatProject prj) throws CoreException {

		if (!prj.getWarLocation().isEmpty()) {
			try {
				prj.exportToWar();
			} catch (final IOException ex) {
				throw new TomcatActionException(ex.getMessage());
			}
		} else {
			throw new TomcatActionException(
					TomcatLauncherPlugin.getResourceString("msg.action.exportWAR.failed"));
		}
	}
}
