/*
 * Copyright (c) 2014 Pigumer Group Inc. All rights reserved.
 */
package jp.pigumer.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

@RunWith(Arquillian.class)
public class ArquillianTest {

	private static final Log LOG = LogFactory.getLog(ArquillianTest.class);
	
	@Deployment
	public static WebArchive getArchive() {
		System.setProperty("org.apache.jasper.compiler.disablejsr199", "true");
		
		JavaArchive jar = ShrinkWrap.create(JavaArchive.class, "example2.jar")
				.addAsManifestResource("META-INF/example.tld", "example.tld");
		LOG.info(jar.getContent());
		
		WebArchive archive = ShrinkWrap.create(WebArchive.class, "jettytest.war")
				.setWebXML("WEB-INF/web.xml")
				.addAsLibrary(jar)
				.addAsWebResource("test.jsp");
		LOG.info(archive.getContent());
		return archive;
	}
	
	private static String getContent(InputStream in) throws IOException {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		try {
			byte[] buf = new byte[8192];
			int len;
			while (0 <= (len = in.read(buf))) {
				out.write(buf, 0, len);
			}
			return out.toString();
		} finally {
			in.close();
		}
	}
	
	@Test
	@RunAsClient
	public void test(@ArquillianResource URL url) throws Exception {
		URL jsp = new URL(url, "test.jsp?msg=Arquillian");
		
		HttpClient client = new DefaultHttpClient();
		try {
			HttpGet get = new HttpGet(jsp.toURI());
			String xhtml = getContent(client.execute(get).getEntity().getContent());
			LOG.info(xhtml);
		} finally {
			client.getConnectionManager().shutdown();
		}
	}
	
	@Test
	@RunAsClient
	public void fluentLeniumTest(@ArquillianResource URL url) throws Exception {
		URL jsp = new URL(url, "test.jsp?msg=FluentLenium");

		HtmlUnitDriver driver = new HtmlUnitDriver();
		driver.setJavascriptEnabled(true);
		try {
			driver.get(jsp.toString());
			assertThat(driver.findElement(By.id("msg")).getAttribute("value"), is("FluentLenium"));
		} finally {
			driver.close();
			driver.quit();
		}
	}
}
