package jp.pigumer.test;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.cyberneko.html.parsers.DOMParser;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DOMTest {

	@Test
	public void documentBuilderdTest() throws Exception {
		String xml = "<html "
				+ "xmlns='http://www.w3.org/1999/xhtml' "
//				+ "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' "
//				+ "xsi:schemaLocation='http://www.w3.org/1999/xhtml http://www.w3.org/2002/08/xhtml/xhtml1-transitional.xsd'"
				+ ">"
				+ "<head>"
				+ "<title>title</title>"
				+ "</head>"
				+ "<body>"
				+ "<input type='text' id='form.0.id1' value='test value' />"
				+ "</body>"
				+ "</html>";
		StringReader reader = new StringReader(xml);
		InputSource is = new InputSource(reader);
		is.setEncoding("UTF-8");
		
		SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
		Schema schema = sf.newSchema(DOMTest.class.getClassLoader().getResource("META-INF/xhtml1-transitional.xsd"));
		
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setNamespaceAware(true);
		dbf.setSchema(schema);
		
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document document = db.parse(is);
		
		Element elem = document.getElementById("form.0.id1");
		System.out.println("documentBuilderTest: " + elem.getAttribute("value"));
	}
	
	@Test
	public void nekoHtmlTest() throws Exception {
		String xml = "<test>"
				+ "<input type='text' id='form.0.id1' value='test value' />"
				+ "</test>";

		StringReader reader = new StringReader(xml);
		InputSource is = new InputSource(reader);
		is.setEncoding("UTF-8");
	
		DOMParser parser = new DOMParser();
		parser.parse(is);
		
		Document document = parser.getDocument();
		
		Element elem = document.getElementById("form.0.id1");
		System.out.println("nekoHtmlTest: " + elem.getAttribute("value"));
		
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
		
		Source source = new DOMSource(document);
		
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		StreamResult result = new StreamResult(os);
		
		transformer.transform(source, result);
		
		System.out.println(os.toString("UTF-8"));
	}
}
