﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Drawing.Printing;

namespace UKEditor
{
    public partial class Form1 : Form
    {
        private string StrPrint;
        private PageSettings PageSetting = new PageSettings();
        private bool dirtyFlag = false; 　 //ダーティーフラグ
        private bool readOnlyFlag = false; //読み取り専用フラグ
        private string editFilePath = "";  //編集中のファイルのパス

        public Form1()
        {
            InitializeComponent();
        }

        //ダーティーフラグの設定
        private void setDirty(bool flag)
        {
            dirtyFlag = flag;
            //読み取り専用でファイルがオープンされている場合、新規作成の場合
            //[上書き(&S)] メニューアイテムは常に無効
            menuSave.Enabled = (readOnlyFlag || editFilePath == "") ? false : flag;
        }


        private void 閉じるToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.閉じるToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.E;
            MessageBox.Show("プログラムを終了します", "終了");
            Application.Exit();
        }

        private void 開くToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.開くToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.B;
            string FileName;
            StreamReader textFile;

            if (
                openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                FileName = openFileDialog1.FileName;
            }
            else
            {
                return;
            }
            textBox1.Clear();
            textFile = new StreamReader(FileName);
            textBox1.Text = textFile.ReadToEnd();
            textFile.Close();
        }

        private void 保存ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.保存ToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.S;
            string strFileName;

            if (
                saveFileDialog1.ShowDialog() ==
                System.Windows.Forms.DialogResult.OK)
            {
                strFileName = saveFileDialog1.FileName;
            }
            else
            {
                return;
        }

        StreamWriter textFile = new StreamWriter(new FileStream(strFileName, FileMode.Create));
        textFile.Write(textBox1.Text);
        textFile.Close();
        }

        private void 印刷ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.印刷ToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.O;
            try
            {
                printDocument1.DefaultPageSettings = PageSetting;
                StrPrint = textBox1.Text;
                printDialog1.Document = printDocument1;

                if (printDialog1.ShowDialog() == DialogResult.OK)
                {
                    printDocument1.Print();
                }
                else
                {
                    return;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "なんらかのエラーを捕捉しました");
            }
        }

        private void printDocument1_PrintPage(object sender, PrintPageEventArgs e)
        {
            Font Fontsize = new Font("MS UI Gothic", 11);
            int intNumberChars;
            int intNumberLines;
            string strPrintString;
            StringFormat strFormat = new StringFormat();

            Rectangle rectSquare = new Rectangle(
                e.MarginBounds.Left, e.MarginBounds.Top,
                e.MarginBounds.Width, e.MarginBounds.Height);

            SizeF SquareSize = new SizeF(
                e.MarginBounds.Width,
                e.MarginBounds.Height - Fontsize.GetHeight(e.Graphics));

            e.Graphics.MeasureString(
                StrPrint, Fontsize, SquareSize, strFormat,
                out intNumberChars, out intNumberLines);

            strPrintString = StrPrint.Substring(0, intNumberChars);

            e.Graphics.DrawString(
                strPrintString, Fontsize, Brushes.Black, rectSquare, strFormat);

            if (intNumberChars < StrPrint.Length)
            {
                StrPrint = StrPrint.Substring(intNumberChars);
                e.HasMorePages = true;
            }
            else
            {
                e.HasMorePages = false;
                StrPrint = textBox1.Text;
            }
        }

        private void 印刷プレビューToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.印刷プレビューToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.Space;
            printDocument1.DefaultPageSettings = PageSetting;
            StrPrint = textBox1.Text;
            printPreviewDialog1.Document = printDocument1;
            printPreviewDialog1.ShowDialog();
        }

        private void 新規作成ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form1 d = new Form1();
            d.ShowDialog(this);
            d.Dispose();
            this.新規作成ToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.A;
        }

        private void コピーToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.コピーToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.C;
            if (textBox1.SelectionLength > 0)
            {
                //選択されている文字列があるときはコピーする
                //（SelectionLengthで調べなくても問題はない）
                textBox1.Copy();
            }

        }

        private void 切り取りToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.切り取りToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.X;
            if (textBox1.SelectionLength > 0)
            {
                //選択されている文字列があるときは切り取る
                //（SelectionLengthで調べなくても問題はない）
                textBox1.Cut();
            }

        }

        private void 貼り付けToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.貼り付けToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.V;
            IDataObject data = Clipboard.GetDataObject();
            if (data != null && data.GetDataPresent(DataFormats.Text) == true)
            {
                //クリップボードにテキストデータがあるときは貼り付ける
                //（テキストデータの有無を調べなくても問題はない）
                textBox1.Paste();
            }

        }

        private void 元に戻すToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.元に戻すToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.Z;
            //アンドゥができるか調べる
            if (textBox1.CanUndo)
            {
                //アンドゥする
                textBox1.Undo();
                //アンドゥバッファを削除する
                textBox1.ClearUndo();
            }
        }

        private void ヘルプToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            this.ヘルプToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.F2;
            //ドキュメントを呼び出す処理を書く
            try
            {
                System.Diagnostics.Process Myexe = new System.Diagnostics.Process();
                Myexe.StartInfo.FileName = "C:/UKEditor/doc/UKEditor.chm"; //PATHの指定.exe付き
                Myexe.StartInfo.WorkingDirectory = "C:/UKEditor/doc";　//PATHの指定
                Myexe.Start();
            }
            catch
            {
                System.Diagnostics.Process Myexe = new System.Diagnostics.Process();
                Myexe.StartInfo.FileName = "E:/UKEditor/doc/UKEditor.chm"; //PATHの指定.exe付き
                Myexe.StartInfo.WorkingDirectory = "E:/UKEditor/doc";　//PATHの指定
                Myexe.Start();
            }
        }

        private void 著作者情報ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.著作者情報ToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.H;
            AboutBox1 newAboutBox = new AboutBox1();
            newAboutBox.ShowDialog();
        }

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }
        //TextBox1.Textを取得、設定するためのプロパティ
        public string TextBoxText
        {
            get
            {
                return textBox1.Text;
            }
            set
            {
                textBox1.Text = value;
            }
        }

        private void 検索ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.検索ToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.F;
            //Form1のインスタンスの作成
            Form1 f = new Form1();
            //Form1Instanceに代入
            Form1.Form1Instance = f;
            //Form1の表示
            f.Show();
            Form1.Form1Instance = this;
            Form2 d = new Form2();
            d.ShowDialog(this);
            d.Dispose();
        }

        private void ストップウオッチToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.ストップウオッチToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.Tab;
            Form3 d = new Form3();
            d.ShowDialog(this);
            d.Dispose();
        }

        private void デジタルタイマーToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.デジタルタイマーToolStripMenuItem.ShortcutKeys = Keys.Control | Keys.F1;
            Form d = new Form4();
            d.ShowDialog(this);
            d.Dispose();
        }

        private void menuSave_Click(object sender, EventArgs e)
        {
            const string MSGBOX_TITLE = "ファイルの上書き保存";

            //保存先のファイルが存在するかチェック
            if (File.Exists(editFilePath))
            {
                try
                {
                    //テキストボックスの内容をファイルに書き込み
                    File.WriteAllText(editFilePath, textBox1.Text, Encoding.Default);
                    setDirty(false);

                }
                catch (Exception ex)
                {
                    //ファイルの書き込みでエラーが発生した場合に Exception の内容を表示
                    MessageBox.Show(this, ex.Message, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                string MSG_BOX_STRING = "ファイル\"" + editFilePath
                     + "\" のパスは正しくありません。\n\nディレクトリが存在するか確認してください。";
                MessageBox.Show(MSG_BOX_STRING, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
