package com.komasan.komainu;

import android.telephony.SmsManager;
import android.text.TextUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by sena on 2015/06/20.
 *
 * @author sena
 */
public class CommonUtil {

    /**
     * 通知のユーザー名を除きメッセージを取り出す。
     * LINEお天気：入力内容が正しくありません。表示されている数字を入力してくださ...」こんな感じで来ることで：以降を返す。
     * */
    public static String getMessage(String s) {
        String meg = "";
        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) == ':' || s.charAt(i) == '：') {
                meg = s.substring(i + 1);
                break;
            }
        }
        return meg;
    }

    /**
     * メッセージを送信するメソッド
     *
     * @param phoneNumber 送信する電話番号
     * @param  message 送信するメッセージ
     * */
    public static void sendMessage(String phoneNumber, String message) {
        SmsManager sm = SmsManager.getDefault();
        sm.sendTextMessage(phoneNumber, null, message, null, null);
    }

    /**
     * いじめワード情報のテンプレートを取得するメソッド<br>
     * リストの中身(いじめワード,最大回数,現在の回数)
     *
     * @return テンプレートリスト
     */
    public static List<String> getTemplateList() {
        List<String> list = new ArrayList<>();
        list.add("ばか,10,0");
        list.add("あほ,8,0");
        list.add("死ね,3,0");
        list.add("はげ,10,0");
        list.add("たこ,15,0");
        list.add("Fuck,10,0");
        return list;
    }

    /**
     * CSVのリストを初期化するメソッド<br>
     * リストの中身(いじめワード,最大回数,現在の回数)
     *
     * @param list 初期化する対象リスト
     * @return 初期化後リスト
     * */
    public static List<String> initList(List<String> list) {
        List<String> output = new ArrayList<>();
        for(String line : list){
            StringBuilder sb = new StringBuilder();
            String[] cell = line.split(",");
            sb.append(cell[0]);
            sb.append(",");
            sb.append(cell[1]);
            sb.append(",");
            sb.append("0");
            output.add(sb.toString());
        }
        return output;
    }

    /**
     * CSVのリストをカウントアップするメソッド<br>
     * リストの中身(いじめワード,最大回数,現在の回数)
     *
     * @param list カウントアップする対象リスト
     * @return カウントアップ後リスト
     * */
    public static List<String> countUpList(String message, List<String> list){
        List<String> output = new ArrayList<>();
        for(String line : list){
            StringBuilder sb = new StringBuilder();
            String[] cell = line.split(",");
            int currentCount = Integer.parseInt(cell[2]);
            int messageCount = countMessage(message, cell[0]);
            sb.append(cell[0]);
            sb.append(",");
            sb.append(cell[1]);
            sb.append(",");
            sb.append(currentCount + messageCount);
            output.add(sb.toString());
        }
        return output;
    }

    /**
     * メッセージに含まれるいじめワードをカウントするメソッド
     * (メッセージ長さ - いじめワードを抜いたメッセージ) / いじめワード長さ
     *
     * @param message 受け取ったメッセージ
     * @param tabooWord いじめワード
     * @return 文字カウント
     * */
    private static int countMessage(String message, String tabooWord){
        return (message.length() - message.replaceAll(tabooWord, "").length()) / tabooWord.length();
    }

    /**
     * 出現したいじめワードの回数が許容限界を超えたか判定するメソッド
     *
     * @param list カウント後のリスト
     * @return 許容回数を超えたか
     * */
    public static boolean isOverCount(List<String> list){
        for(String line : list){
            String[] cell = line.split(",");
            int maxCount = Integer.parseInt(cell[1]);
            int nowCount = Integer.parseInt(cell[2]);
            if(nowCount >= maxCount){
                return true;
            }
        }
        return false;
    }



}
