﻿package SqlServer;

use strict;
use warnings;
use Carp 'croak';
use Encode;

use Win32::OLE;
use Win32::OLE::variant;        # datetime型のデータが文字列で取得できる。
use Win32::OLE::Const 'Microsoft ActiveX Data Objects 2.0 Library'; # 指定タイプライブラリのコンスタントが参照可能
Win32::OLE->Option(Warn => 3);  # エラー時に本処理を中止し、Perlがエラーメッセージを出力し、本プロセスが終了する。


sub new {
    my ($class) = @_;
    my $self = {};
    $self->{objDB} = Win32::OLE->new("ADODB.Connection");
    return bless $self, $class;
}

sub connect(){
    my ($self,$ini_path) = @_;
    
    my $ini=YAML::XS::LoadFile($ini_path);
    # DBサーバー名とDB名設定
    my $server      = $ini->{sqlserver}->{server};
    my $db          =  $ini->{sqlserver}->{db};
    my $auth_type   = $ini->{sqlserver}->{auth_type};
    my $connStr;
    if ($auth_type eq "windows" ) {
        # WINDOWS 認証設定
        $connStr = "Provider=sqloledb;Data Source=$server;Initial Catalog=$db;Integrated Security=SSPI;";
    } else {
        # SQL Server 認証設定
        my $uid =  $ini->{sqlserver}->{uid};
        my $pwd =  $ini->{sqlserver}->{pwd};
        $connStr = "Provider=sqloledb;Data Source=$server;Initial Catalog=$db;User ID=$uid;Password=$pwd;";
    }
    # DB接続
    $self->{objDB}->Open($connStr);
    $self->{objDB}->{Errors}->{Count} and croak "cannot connect '$connStr'";
}

sub disconnect{
    my $self=shift;
    $self->{objDB}->Close();
}

sub open_rs{
    my ($self,$sql) = @_;

    my $rs = Win32::OLE->new("ADODB.Recordset");
    $rs->{CursorLocation} = adUseClient;

    $rs->Open($sql, $self->{objDB});
    return $rs;
}

#レコード数を得る
sub count_rec{
    my ($self,$sql) = @_;
    
    $sql = encode("sjis",$sql); #SQLをSJISにしないとハング
    #print "$sql\n";
    my $rs = Win32::OLE->new("ADODB.Recordset");
    $rs->{CursorLocation} = adUseClient;

    $rs->Open($sql, $self->{objDB});
    my $retVal= $rs->{RecordCount};
    $rs->Close();
    
    return $retVal;
}

sub DESTROY{
    my $self=shift;
    #$self->{objDB}->Close();   #エラー？
}

1;
