=pod
URLリストのファイルが存在するかチェック
URLリストの"url"の列にURLを書いておくこと
存在しないURLを出力
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;
use LWP::Simple;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=();
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','out_file=s');
    print decode("cp932",Dumper(\%opts));
    
    my @files = glob $opts{in_file};
    if (scalar(@files) == 0) {
        printf "%s:ファイルが見つかりません\n",$opts{in_file};
        exit;
    }
    my $in_file=$files[0];
        
    my $csv_in = CSVAsHash->new();
    my $aoh_in=$csv_in->csv2aoh($in_file);
    printf "%s:%d件入力\n",decode("cp932",$in_file),scalar(@$aoh_in);
    
    my @aoh_out=();
    for my $line (@$aoh_in){
		my @info = head($line->{url});
		#print Dumper \@info;
		my $bMissing =0;		
		if (scalar(@info)==0) {
			$bMissing = 1;
		}
        if ($bMissing){
			push @aoh_out,$line;
		}
    }
    
    $csv_in->aoh2csv(\@aoh_out,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@aoh_out);
}
