=pod
CSVと参照CSVの値を比較

=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(in_header=>1,ref_header=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','ref_file=s','out_file=s','in_key_col_names=s','ref_key_col_names=s','in_val_col_name=s','ref_val_col_name=s','in_header=i','ref_header=i','in_tab','ref_tab');
    print decode("cp932",Dumper(\%opts));
    
    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    my $ref_sep_char;
    if (defined($opts{ref_tab})) {
        $ref_sep_char="\t";
    }else{
        $ref_sep_char=",";
    }
    
    my $csv_ref = CSVAsHash->new(csv_header=>$opts{ref_header},csv_sep_char=>$ref_sep_char);
    
    my $hoh_in = $csv_in->csv2hoh($opts{'in_file'},decode("cp932",$opts{in_key_col_names}));
    printf "%s:%d件入力\n",decode("cp932",$opts{'in_file'}),scalar(keys(%$hoh_in));
    
    my $hoh_ref = $csv_in->csv2hoh($opts{ref_file},decode("cp932",$opts{ref_key_col_names}));
    printf "%s:%d件入力\n",decode("cp932",$opts{'ref_file'}),scalar(keys(%$hoh_ref));
    
    my @keys=keys(%$hoh_in);
    my @keys_ref=keys(%$hoh_ref);
    push @keys,@keys_ref;
    @keys = @{Util::uniq_array(\@keys)};
    @keys = sort @keys;
    
    my $csv_out = CSVAsHash->new();
    $csv_out->set_col_names_from_str("key,in_file,ref_file,diff");
    my @aoh_out=();
    for my $key (@keys){
        my %line=();
        $line{key}=$key;
        $line{in_file} = defined($hoh_in->{$key})?$hoh_in->{$key}->{decode("cp932",$opts{in_val_col_name})}:"-";
        $line{ref_file} = defined($hoh_ref->{$key})?$hoh_ref->{$key}->{decode("cp932",$opts{ref_val_col_name})}:"-";
        if(($line{in_file} ne "-" ) && ($line{ref_file} ne "-" )){
            $line{diff}=$line{in_file}-$line{ref_file};
        }else {
            $line{diff} = "-";
        }
        push @aoh_out,\%line;
    }
    
    $csv_out->aoh2csv(\@aoh_out,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@aoh_out);
}

