#excelブックを比較用CSVにダンプ

use strict;
use Spreadsheet::ParseExcel;
use CSVAsHash;
use utf8;
use Getopt::Long;
use Data::Dumper;
use Encode;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(sort_sheet=>1);
&main_proc;

sub main_proc{
     my $res=GetOptions(\%opts,'in_file=s','out_file=s','sort_sheet');
    print decode("cp932",Dumper(\%opts));

    my $parser   = Spreadsheet::ParseExcel->new();
    my $workbook = $parser->parse($opts{in_file});
    
    if ( !defined $workbook ) {
        die $parser->error(), ".\n";
    }
    
    my $csv_out=CSVAsHash->new();
    $csv_out->set_col_names_from_str("sheet,row,col,value");
    
    my @aoh_out=();
    my @sheets = $workbook->worksheets();
    if (defined($opts{sort_sheet})){
        @sheets = sort(@sheets);
    }
    for my $worksheet (@sheets ) {
        my ( $row_min, $row_max ) = $worksheet->row_range();
        my ( $col_min, $col_max ) = $worksheet->col_range();
    
        for my $row ( $row_min .. $row_max ) {
            for my $col ( $col_min .. $col_max ) {
    
                my $cell = $worksheet->get_cell( $row, $col );
                next unless $cell;
                my $row_out = $csv_out->get_blank_row;
                $row_out->{sheet}   =$worksheet->get_name();
                $row_out->{row}     =$row+1;
                $row_out->{col}     =$col+1;
                $row_out->{value}   =$cell->value();
                push @aoh_out,$row_out;
            }
        }
    }
    
    $csv_out->aoh2csv(\@aoh_out,$opts{out_file});
    printf "%s:%d件出力しました\n",$opts{out_file},scalar(@aoh_out);
}
