﻿#バッチ起動メニュー
#$ARGV[0]   メニューの定義ファイル(YAML形式)

use strict;
use warnings;
use Term::ReadKey;
use IO::Handle;
use feature ':5.10';
use YAML::XS;

use utf8;
use Encode;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

STDOUT->autoflush(1);

my $yaml = $ARGV[0];
if (! -f $yaml) {
    my $s = sprintf "%sがありません",decode("cp932",$yaml);
    die $s;
}
my $list=YAML::XS::LoadFile($yaml);

while (1){
    print "\n<<<<< メニュー >>>>>\n";
    my @tasks = sort keys(%$list);
    foreach my $i (@tasks) {
        printf "%s\t%s\n",$i,$list->{$i}->{desc};
    }

    my $task;
    while (1){
        print "\nタスク番号を入力してください(r:タスク再読み込み q:終了):";
        
        $task = <STDIN>;
        chomp($task);
        
        if (($task eq 'r')||($task eq 'q')) {
            last;
        }
        
        if (defined($list->{$task})){
            last;
        }
    }

    process($task);
}

sub process{
    my $task = shift;
    
    if ($task eq 'r') {
        print "****** タスク再読み込み *****\n";
        $list=YAML::XS::LoadFile($yaml);
        return;
    }
    
    if ($task eq 'q') {
        print "****** 終了 *****\n";
        exit;
    }
    
    printf "→ %s\n",$list->{$task}->{desc};
    
    if ($list->{$task}->{desc} eq "終了") {
        exit;
    }
    my $commands=$list->{$task}->{command};
    for my $command (@$commands) {
        print "\n***** コマンド実行 *****\n[$command]\n";
        my $ret=system encode("cp932",$command);
        if ($ret == -1) {
            print "コマンドを実行できませんでした\n";
            last;
        }
        if ($ret !=0 ) {
            print "!!!!!コマンド実行中エラー!!!!!\n";
            last;
        }
    }
    
}
