=pod
ファイルからパターンで抽出

patterns
    正規表現を","で区切る
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=();
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','out_file=s','patterns=s');
    print decode("cp932",Dumper(\%opts));

    my @patterns = split(/,/,$opts{patterns});
    my @arr_out=();
    my $fi=IO::File->new($opts{'in_file'}, "<:encoding(cp932):crlf")||die $!;
    while (my $line = $fi->getline ) {
        for my $pattern (@patterns){
            my @matches = $line =~ /$pattern/g;
            push @arr_out,@matches;
        }
    }
    
    @arr_out=@{Util::uniq_array(\@arr_out)};
    @arr_out= sort (@arr_out);
    my $fo = IO::File->new($opts{'out_file'}, "w")||die $!;
    for my $line (@arr_out){
        $fo->printf("$line\n");
    }
    printf "%s:%d件出力しました\n",$opts{out_file},scalar(@arr_out);

}
