use strict;
use warnings;
use File::Find;
use File::Basename;
use Getopt::Long;
use Data::Dumper;
use Encode;
use utf8;

use CSVAsHash;

binmode STDOUT => ":encoding(cp932)";
binmode STDERR => ":encoding(cp932)";

#グローバル
my %opts=();
my $g_enc = find_encoding('cp932');
my @aoh_out=();

&main_proc;

sub main_proc{
    #引数処理
    my $res=GetOptions(\%opts,'dir=s','out_file=s');
    print $g_enc->decode(Dumper(\%opts));
    
    my $csv_out=CSVAsHash->new;
    $csv_out->set_col_names_from_str("module,file");

	find(\&find_func, $opts{dir});
	
	my $aoh_out=CSVAsHash::sort_aoh(\@aoh_out,"module");
	$csv_out->aoh2csv($aoh_out,$opts{out_file});
	printf("%s:%d件出力しました\n",$g_enc->decode($opts{out_file}),scalar(@aoh_out));
}

sub find_func
{
    my $file = $File::Find::name;
    if ($file =~ /\.(pm|pl)$/) {
		proc_file($file);
    }
}

sub proc_file{
	my $file=shift;
	my $fi= IO::File->new($file);
	while (my $line=$fi->getline){
	    chomp($line);
	    if ($line =~ /use (.+);/){
	        my %line_out;
	        $line_out{module}=$1;
	        $line_out{file}=$g_enc->decode($file);
	        
	        push @aoh_out,\%line_out;
	    }
	}
}
