=pod
CSVからレコードを選択して出力

patterns
    正規表現を","で区切る
reverse
    0:  合致するものを出力
    1:  合致しないものを出力
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(in_header=>1,ref_header=>1,reverse=>0,exact=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','ref_file=s','out_file=s','reverse=i','in_key_col_names=s','ref_key_col_names=s','in_header=i','ref_header=i','in_tab','ref_tab','exact=i');
    print decode("cp932",Dumper(\%opts));
    
    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    my $ref_sep_char;
    if (defined($opts{ref_tab})) {
        $ref_sep_char="\t";
    }else{
        $ref_sep_char=",";
    }
    
    my $csv_ref = CSVAsHash->new(csv_header=>$opts{ref_header},csv_sep_char=>$ref_sep_char);
    
    #in_fileはワイルドカード対応
    my $in_file;
    my @files = glob $opts{in_file};
    if (scalar(@files)==0){
        die decode("cp932",$opts{in_file})."はありません";
    }
    $in_file = $files[0];
    
    my $aoh_in = $csv_in->csv2aoh($in_file);
    my $org_cnt=scalar(@$aoh_in);
    printf "%s:%d件入力\n",decode("cp932",$in_file),$org_cnt;
    
    my $aoh_ref = $csv_ref->csv2aoh($opts{'ref_file'});
    
    my $aoh_out = CSVAsHash::select_aoh($aoh_in,decode("cp932",$opts{in_key_col_names}),$aoh_ref,ref_col_names=>decode('cp932',$opts{ref_key_col_names}),reverse=>$opts{reverse},exact=>$opts{exact});
    $csv_in->aoh2csv($aoh_out,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@$aoh_out);
}

