use strict;
use warnings;

use Data::Dumper;
use Getopt::Long;
use utf8;
use Encode;

use HashWithKeyCheck;
use Test::More;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my $data={
  	key1 => 'val1',
   	key2 => 'val2'
};

plan (tests=>2);    
&test1;

sub test1{

    my %hash;
    tie %hash,'HashWithKeyCheck',$data,fetch_check=>1,store_check=>0;
    
    $hash{key2}="a123";
    
    #キーなしSTORE/no check
    eval {$hash{key3}="a123";};
	is($@,'','STORE with non exist key/no check');
	
	#キーなしFETCH/check
    eval {print $hash{key4};};
	is(defined($@),1,'FETCH with non exist key/check');
	
}
