using System;
using System.Collections.Generic;
using System.Text;

using System.Diagnostics;

using System.Net.Sockets;
using System.IO;
using System.Xml.Serialization;
using System.Security.Cryptography;

namespace LocalMessenger
{
    // R}hM̃nh
    delegate void CommandHandler(Command command, TcpClient client);

    /// <summary>
    /// R}h𑗎MNX
    /// </summary>
    class Commander
    {
        public event CommandHandler received;    // ڑ̃Cxg

        private Manager manager;
        private Listener listener;
        private XmlSerializer serializer;
        private RijndaelManaged aes;

        public Commander(Manager manager)
        {
            this.manager = manager;

            serializer = new XmlSerializer(typeof(Command));
            aes = new RijndaelManaged();

            listener = new Listener();          // o[̐ڑ҂
            listener.accepted += new AcceptedHandler(receiveCommand);
        }

        public void Start()
        {
            listener.Start();
        }

        public void Stop()
        {
            listener.Stop();
        }

        public void receiveCommand(TcpClient client)
        {
            NetworkStream ns = client.GetStream();

            int count = 0;
            byte[] size = BitConverter.GetBytes(count);
            byte[] buf;
            byte[] key;
            byte[] iv;

            try
            {
                ns.Read(size, 0, size.Length);
                count = BitConverter.ToInt32(size, 0);
                buf = new byte[count];
                ns.Read(buf, 0, count);
                key = manager.Rsa.Decrypt(buf, false);   // AES ̎擾

                ns.Read(size, 0, size.Length);
                count = BitConverter.ToInt32(size, 0);
                buf = new byte[count];
                ns.Read(buf, 0, count);
                iv = manager.Rsa.Decrypt(buf, false);    //AES xN^̎擾
            } catch (CryptographicException e) {
                // łȂf[^MؒfB
                Debug.WriteLine(e);
                client.GetStream().Close();
                return;
            }

            size = BitConverter.GetBytes(count);
            ns.Read(size, 0, size.Length);
            count = BitConverter.ToInt32(size, 0);

            using (MemoryStream ms = new MemoryStream())
            {
                byte[] receiveBytes = new byte[count];
                int len;

                while (count > 0)
                {
                    len = ns.Read(receiveBytes, 0, count);
                    ms.Write(receiveBytes, 0, len);
                    count -= len;
                }

                ms.Seek(0, SeekOrigin.Begin);

                ICryptoTransform transform = aes.CreateDecryptor(key, iv);
                CryptoStream cs =
                    new CryptoStream(ms, transform, CryptoStreamMode.Read);

                try
                {
                    Command command = (Command)serializer.Deserialize(cs);

                    Member member = command.From;
                    command.From =
                        manager.GetMember(member.Name, member.Address);

                    for (int i = 0; i < command.To.Count; i++)
                    {
                        member = command.To[i];
                        command.To[i] =
                            manager.GetMember(member.Name, member.Address);
                    }

                    for (int i = 0; i < command.With.Count; i++)
                    {
                        member = command.With[i];
                        command.With[i] =
                            manager.GetMember(member.Name, member.Address);
                    }

                    if (received != null)
                        received(command, client);
                }
                catch (System.Xml.XmlException e)
                {
                    Debug.WriteLine(e.ToString());
                }

                ms.Close();
                cs.Close();
            }   // stream IuWFNg𖾎Iɔj
        }

        public void sendCommand(TcpClient client, Command command, RSAParameters publicKey)
        {
            NetworkStream ns = client.GetStream();
            byte[] size;

            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
            rsa.ImportParameters(publicKey);
            byte[] key = rsa.Encrypt(command.Key, false);
            byte[] iv = rsa.Encrypt(command.IV, false);

            size = BitConverter.GetBytes(key.Length);
            ns.Write(size, 0, size.Length);     // key ̃TCY̑M
            ns.Write(key, 0, key.Length);       // key {̂̑M

            size = BitConverter.GetBytes(iv.Length);
            ns.Write(size, 0, size.Length);     // iv ̃TCY̑M
            ns.Write(iv, 0, iv.Length);         // iv {̂̑M

            using (MemoryStream ms = new MemoryStream())
            {
                ICryptoTransform transform =
                    aes.CreateEncryptor(command.Key, command.IV);
                CryptoStream cs =
                    new CryptoStream(ms, transform, CryptoStreamMode.Write);

                serializer.Serialize(cs, command);
                cs.FlushFinalBlock();

                byte[] sendBytes = new byte[ms.Length];
                ms.Seek(0, SeekOrigin.Begin);
                int count = ms.Read(sendBytes, 0, (int)ms.Length);
                ms.Close();
                cs.Close();

                size = BitConverter.GetBytes(count);
                ns.Write(size, 0, size.Length);
                ns.Write(sendBytes, 0, count);
                ns.Flush();
            }   // stream IuWFNg𖾎Iɔj
        }
    }
}
