using System;
using System.Collections.Generic;
using System.Text;

using System.Diagnostics;

using System.Threading;
using System.Net;
using System.Net.Sockets;

namespace LocalMessenger
{
    delegate void AcceptedHandler(TcpClient client);

    /// <summary>
    /// R}hM҂̃NX
    /// </summary>
    class Listener
    {
        public event AcceptedHandler accepted;      // ڑ̃Cxg

        private Thread thread;
        private TcpListener listener;
        private Int32 port;

        public Listener()
        {
            try
            {
                port = Properties.Settings.Default.PortNumber;
            }
            catch (NullReferenceException)
            {
                Properties.Settings.Default.PortNumber = Manager.DefaultPort; 
                port = Properties.Settings.Default.PortNumber;
            }
        }

        public void Start()
        {
            thread = new Thread(listen);
            thread.Start();
        }

        public void Stop()
        {
            if (listener != null)
                listener.Stop();

            thread.Abort();
        }

        private void listen()
        {
            IPAddress localhost = NetAdapter.GetAddress();
            IPEndPoint endPoint = new IPEndPoint(localhost, port);
            listener = new TcpListener(endPoint);
            listener.Start();

            while (true)
            {
                try
                {
                    TcpClient client = listener.AcceptTcpClient();

                    if (accepted != null)
                        accepted(client);
                }
                catch (SocketException)
                {
                    Stop();
                }
            }
        }
    }
}
