using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.IO;
using System.Net.Sockets;

namespace LocalMessenger
{
    public delegate void InviteHandler(Messenger messenger, Member member);

    public partial class Manager : Form
    {
        private Int32 port = Properties.Settings.Default.PortNumber;

        // R}hMɃbZW[J
        private Messenger openChatWindow(TcpClient client, Command command)
        {
            List<Member> list = new List<Member>(command.With);

            Messenger messenger = searchChatWindow(list);

            if (messenger == null)
            {   // ܂O[ṽbZW[JĂȂꍇ
                // bZW[EBhE쐬
                messenger = new Messenger(this);
                messenger.closed += new ClosedHandler(closeChatWindow);
                messenger.WindowState = FormWindowState.Minimized;
                chatWindowList.Add(messenger);
                showBalloonTip(messenger, command.From);

                // eo[Ƃ肠bZW[ɓo^
                foreach (Member member in command.With)
                    messenger.Add(member, null, command.Key, command.IV);
            }

            // ڑv̂o[̐ڑێ
            // ɃRlNVĂꍇ͒ȂɂȂ
            messenger.Add(command.From, client, command.Key, command.IV);

            return messenger;
        }

        // bZW[̏
        private void closeChatWindow(Messenger messenger)
        {
            chatWindowList.Remove(messenger);
        }

        // o[̃bZW[Ȃ
        private Messenger searchChatWindow(List<Member> list)
        {
            foreach (Messenger window in chatWindowList)
            {
                if (window.Equals(list))
                    return window;
            }

            return null;
        }
         
        // R}hM̐ڑ
        private void procedure(Command command, TcpClient client)
        {
            Debug.WriteLine("[Begin Process]");
            Messenger messenger;
            List<Member> list;
            List<Member> group;

            switch (command.Request)
            {
                // ڑmFp̃R}h
                case Command.Require.DUMMY:
                    break;

                // ŏ̐ڑ
                case Command.Require.CONNECT:
                    messenger = openChatWindow(client, command);

                    command.From = this.User;
                    list = new List<Member>(command.To);
                    command.To.Clear();
                    group = new List<Member>(command.With);
                    group.Add(this.User);        // O[vXgɒǉ

                    foreach (Member member in list)
                    {
                        command.With = new List<Member>(group);
                        command.With.Remove(member);        // O[vXg폜

                        client = new TcpClient(member.Address, port);
                        commander.sendCommand(client, command, member.PublicKey);

                        messenger.Add(member, client, command.Key, command.IV);
                    }

                    messenger.Show();
                    if (messenger.WindowState == FormWindowState.Minimized)
                        messenger.BlinkTitleBar();
                    else
                        messenger.Activate();
                    break;

                // ҂ꂽ
                case Command.Require.INVITE:
                    messenger = openChatWindow(client, command);

                    list = new List<Member>(command.With);
                    list.Remove(command.From);              // list ͏҂o[ȊÕo[
                    group = new List<Member>(command.With);

                    command.Request = Command.Require.JOIN;
                    command.From = User;
                    command.To.Clear();                     // ɐڑĂ炢l͂Ȃ

                    foreach (Member member in list)
                    {
                        command.With = new List<Member>(group);
                        command.With.Remove(member);        // ɓĂ炢O[v

                        client = new TcpClient(member.Address, port);
                        commander.sendCommand(client, command, member.PublicKey);

                        messenger.Add(member, client, command.Key, command.IV);
                    }

                    messenger.Show();
                    if (messenger.WindowState == FormWindowState.Minimized)
                        messenger.BlinkTitleBar();
                    else
                        messenger.Activate();
                    break;

                // bZW[ւ̎荞ݗv
                case Command.Require.JOIN:
                    messenger = openChatWindow(client, command);

                    messenger.Show();
                    if (messenger.WindowState == FormWindowState.Minimized)
                        messenger.BlinkTitleBar();
                    else
                        messenger.Activate();
                    break;

                // 肩t@C𑗐Mꂽ
                case Command.Require.TRANSFER:
                    {   // commandŎw肳ꂽt@CM
                        FileTransfer transfer = new FileTransfer(command, client);
                        transfer.transferred += new TransferHandler(TransferMessage);
                        transfer.ReceiveFiles(command.Files);
                    }
                    break;

                // 肩t@C̍폜ʒmꂽ
                case Command.Require.REMOVE:
                    RemoveMessage(command.With, command.Files);
                    break;

                // t@C]v󂯎
                case Command.Require.REQUEST:
                    // vꂽt@C]
                    Transfer(command.From, command.With, command.Files);
                    break;

                // ȃR}h󂯎
                default:
                    Debug.WriteLine("[Process] Invalid Command");
                    break;
            }

            Debug.WriteLine(command.Request);
            Debug.WriteLine("[End Process]");
        }

        // t@C]ĨbZ[W
        private void TransferMessage(List<Member> member, string text)
        {
            if (InvokeRequired)
            {
                TransferHandler d = new TransferHandler(TransferMessage);
                this.Invoke(d, new object[] { member, text });
            }
            else
            {
                Messenger messenger = searchChatWindow(member);

                if (messenger == null)
                    return;

                messenger.AppendText(text);
            }
        }

        // R}hM̐ڑ
        public void Connect(List<Member> list)
        {
            Messenger messenger = searchChatWindow(list);

            if (messenger == null)
            {   // ܂O[ṽbZW[JĂȂꍇ
                // bZW[EBhE쐬
                messenger = new Messenger(this);
                messenger.closed += new ClosedHandler(closeChatWindow);
                chatWindowList.Add(messenger);

                Command command = new Command();

                command.Request = Command.Require.CONNECT;
                command.From = this.User;
                command.Key = aes.Key;
                command.IV = aes.IV;

                Object lockObject = new Object();
                lock (lockObject)
                {   // lock KvȂB
                    for (int i = 0; i < list.Count; i++)
                    {
                        Member member = list[i];

                        command.To = new List<Member>();

                        for (int j = (i + 1); j < list.Count; j++)
                            command.To.Add(list[j]);

                        command.With = new List<Member>(list);
                        command.With.Add(this.User);        // O[vXgɒǉ
                        command.With.Remove(member);        // O[vXg폜
                        try
                        {
                            TcpClient client = new TcpClient(member.Address, port);
                            commander.sendCommand(client, command, member.PublicKey);
                            messenger.Add(member, client, aes.Key, aes.IV);
                        }
                        catch (SocketException e)
                        {
                            string message = member.NickName + "Ƃ̐ڑɎs܂B";
                            MessageBox.Show(message);
                            Debug.WriteLine(message);
                            Debug.WriteLine(e);
                            continue;
                        }
                    }
                }
            }

            if (messenger.GetMemberList().Count == 0)
            {
                closeChatWindow(messenger);
                messenger.Close();
            }
            else
            {
                messenger.Show();
                if (messenger.WindowState == FormWindowState.Minimized)
                    messenger.WindowState = FormWindowState.Normal;
                messenger.Activate();
            }
        }

        public void Invite(Messenger messenger, Member member)
        {
            Command command = new Command();

            command.Request = Command.Require.INVITE;
            command.From = this.User;
            command.Key = aes.Key;
            command.IV = aes.IV;

            command.With = new List<Member>(messenger.GetMemberList());
            command.With.Add(this.User);        // O[vXgɒǉ
            command.With.Remove(member);        // O[vXg폜

            TcpClient client = new TcpClient(member.Address, port);
            commander.sendCommand(client, command, member.PublicKey);
            messenger.Add(member, client, aes.Key, aes.IV);
            
            Debug.WriteLine(string.Format("o[ {0}@{1} ҂܂B",
                   member.Name, member.Machine));
        }

        // t@C]
        public void Transfer(Member member, List<Member> with, List<TargetFile> targets)
        {
            Command command = new Command();

            command.From = this.User;
            command.With = with;

            List<string> files = new List<string>();
            List<TargetFile> existFile = new List<TargetFile>();
            List<TargetFile> removeFile = new List<TargetFile>();

            foreach (TargetFile target in targets)
            {
                try
                {
                    FileInfo info = new FileInfo(target.Name);
                    target.Length = info.Length;
                    files.Add(target.Name);    // [JpXł̃t@CXg
                    existFile.Add(target);
                }
                catch (Exception e)
                {
                    Debug.WriteLine(e.ToString());
                    removeFile.Add(target);
                }
            }

            command.To  = new List<Member>();
            command.To.Add(member);
            command.Key = aes.Key;
            command.IV  = aes.IV;

            if (removeFile.Count > 0)
            {   // 폜ꂽt@Cʒm
                TcpClient client = new TcpClient(member.Address, port);
                command.Request = Command.Require.REMOVE;
                command.Files   = removeFile;
                commander.sendCommand(client, command, member.PublicKey);
            }

            if (existFile.Count > 0)
            {
                TcpClient client = new TcpClient(member.Address, port);
                command.Request = Command.Require.TRANSFER;
                command.Files = existFile;
                commander.sendCommand(client, command, member.PublicKey);

                FileTransfer transfer = new FileTransfer(command, client);
                transfer.SendFiles(files);
            }
        }

        // t@C]v
        public void RequestFile(Member member, List<Member> with, List<string> paths)
        {
            Command command = new Command();

            command.Request = Command.Require.REQUEST;
            command.From    = this.User;
            command.With    = with;

            List<TargetFile> target = new List<TargetFile>();

            foreach (string path in paths)
            {
                // tpXŐݒ肵܂B
                TargetFile file = new TargetFile();
                file.Name = path;
                target.Add(file);   // ɑ΂t@CƃTCỸXg
            }

            command.Files = target;

            {
                TcpClient client = new TcpClient(member.Address, port);

                command.To  = new List<Member>();
                command.To.Add(member);
                command.Key = aes.Key;
                command.IV  = aes.IV;
                commander.sendCommand(client, command, member.PublicKey);
            }
        }

        // 폜ꂽt@C̒ʒm
        private void RemoveMessage(List<Member> with, List<TargetFile> targets)
        {
            foreach (TargetFile target in targets)
            {
                string fileName = Messenger.GetFileName(target.Name);
                TransferMessage(with, string.Format(
                        "  -- {0}͍폜܂B--  \r\n",fileName));
            }
        }
    }
}
