#include<stdio.h>
#include<comp/comp.h>

int main(int argc, char *argv[]) {
    int c, ret = 0;
    unsigned long int size;
    FILE *infile = NULL, *outfile = NULL;
    COMP_huffman *huffman = NULL;
    COMP_result result;

    if (argc != 4) {
        fprintf(stderr, 
            "usage: %s E|e|D|d input_file output_file\n", argv[0]);
        ret = -1;
        goto err;
    }
    infile = fopen(argv[2], "rb");
    if (infile == NULL) {
        fprintf(stderr, "can't open input file\n");
        ret = -1;
        goto err;
    }
    outfile = fopen(argv[3], "wb");
    if (outfile == NULL) {
        fprintf(stderr, "can't open output file\n");
        ret = -1;
        goto err;
    }
    c = *argv[1];
    switch(c) {
    case 'E':
    case 'e':
        result = COMP_createHuffman(&huffman);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_createHuffman error\n");
            ret = -1;
            goto err;
        }
        huffman->inbuf_data_size = 
            fread(huffman->inbuf, 1, COMP_INBUF_SIZE, infile);
        result = COMP_encodeHuffman(huffman);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_encodeHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fwrite(huffman->outbuf, 1, huffman->outbuf_data_size, outfile);
        break;
    case 'D':
    case 'd':
        result = COMP_createHuffman(&huffman);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_createHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fread(huffman->inbuf, 1, COMP_INBUF_SIZE, infile);
        result = COMP_decodeHuffman(huffman);
        if (result != COMP_ok) {
            fprintf(stderr, "COMP_encodeHuffman error\n");
            ret = -1;
            goto err;
        }
        size = fwrite(huffman->outbuf, 1, huffman->outbuf_data_size, outfile);
        break;
    default:
        fprintf(stderr, "refer how to use\n");
        ret = -1;
        goto err;
    }

err:
no_err:
    if (huffman != NULL) {
        COMP_disposeHuffman(huffman);
    }
    if (infile != NULL) {
        fclose(infile);
    }
    if (outfile != NULL) {
        fclose(outfile);
    }
    return ret;
}

