#include <stdio.h>
#include <stdlib.h>
#include <comp/comp_lz.h>

#define NIL COMP_LZ_RING_BUF_SIZE

static void COMP_insertSlideDicTree(COMP_lz *lz, int r);
static void COMP_deleteSlideDicTree(COMP_lz *lz, int p);

COMP_result COMP_createLz(COMP_lz **lz) {
	COMP_result result = COMP_ok;
	int i;

    (*lz) = (COMP_lz *)COMP_malloc(sizeof(COMP_lz));
    if ((*lz) == NULL) {
#ifdef DEBUG
        fprintf(stderr, "file=%s, line=%d\n", __FILE__, __LINE__);
#endif
        result = COMP_err;
        goto err;
    }    

	for(i = COMP_LZ_RING_BUF_SIZE + 1; i < COMP_LZ_RING_BUF_SIZE + 257; i++) {
		(*lz)->slide_dic_tree_right[i] = NIL;
	}
	for(i = 0; i < COMP_LZ_RING_BUF_SIZE; i++) {
		(*lz)->slide_dic_tree_parent[i] = NIL;
	}
    (*lz)->inbuf_byte_pos = 0;
    (*lz)->inbuf_bit_space = 8;
    (*lz)->outbuf[0] = 0;
    (*lz)->outbuf_data_size = 0;
    (*lz)->outbuf_byte_pos = 0;
    (*lz)->outbuf_bit_space = 8;
err:
    return result;
}

void COMP_disposeLz(COMP_lz *lz) {

    COMP_free(lz);

    return;
}

static void COMP_insertSlideDicTree(COMP_lz *lz, int r) {
    int i, p, cmp;
    unsigned char *key;

    cmp = 1;
    key = &lz->slide_dic_text[r];
    p = COMP_LZ_RING_BUF_SIZE + 1 + key[0];
	lz->slide_dic_tree_right[r] = NIL;
	lz->slide_dic_tree_left[r] = NIL;
	lz->slide_dic_match_len = 0;
	
    for (;;) {
        if(cmp >= 0) {
			if(lz->slide_dic_tree_right[p] != NIL) {
				p = lz->slide_dic_tree_right[p];
			}
			else {
				lz->slide_dic_tree_right[p] = r;
				lz->slide_dic_tree_parent[r] = p;
				return;
			}
        }
        else {
			if(lz->slide_dic_tree_left[p] != NIL) {
				p = lz->slide_dic_tree_left[p];
            }
            else {
				lz->slide_dic_tree_left[p] = r;
				lz->slide_dic_tree_parent[r] = p;
                return;
            }
        }
        for(i = 1; i < COMP_LZ_MATCH_LENGTH_MAX; i++) {
			if ((cmp = key[i] - lz->slide_dic_text[p + i]) != 0) {
                break;
            }
        }
		if (i > lz->slide_dic_match_len) {
			lz->slide_dic_match_pos = p;
			lz->slide_dic_match_len = i;
			if (lz->slide_dic_match_len >= COMP_LZ_MATCH_LENGTH_MAX) {
                break;
			}
        }
    }
	lz->slide_dic_tree_parent[r] = lz->slide_dic_tree_parent[p];
	lz->slide_dic_tree_left[r] = lz->slide_dic_tree_left[p];
	lz->slide_dic_tree_right[r] = lz->slide_dic_tree_right[p];
	lz->slide_dic_tree_parent[lz->slide_dic_tree_left[p]] = r;
	lz->slide_dic_tree_parent[lz->slide_dic_tree_right[p]] = r;
	if (lz->slide_dic_tree_right[lz->slide_dic_tree_parent[p]] == p)
		lz->slide_dic_tree_right[lz->slide_dic_tree_parent[p]] = r;
    else {
		lz->slide_dic_tree_left[lz->slide_dic_tree_parent[p]] = r;
    }
	lz->slide_dic_tree_parent[p] = NIL;
}

static void COMP_deleteSlideDicTree(COMP_lz *lz, int p) {
    int q;

	if(lz->slide_dic_tree_parent[p] == NIL) {
        return;
	}
	if(lz->slide_dic_tree_right[p] == NIL) {
		q = lz->slide_dic_tree_left[p];
	}
	else if(lz->slide_dic_tree_left[p] == NIL)
		q = lz->slide_dic_tree_right[p];
    else {
		q = lz->slide_dic_tree_left[p];
		if (lz->slide_dic_tree_right[q] != NIL) {
            for(;;) {
				q = lz->slide_dic_tree_right[q];
				if (lz->slide_dic_tree_right[q] == NIL) {
					break;
				}
			}
			lz->slide_dic_tree_right[lz->slide_dic_tree_parent[q]] = lz->slide_dic_tree_left[q];
			lz->slide_dic_tree_parent[lz->slide_dic_tree_left[q]] = lz->slide_dic_tree_parent[q];
			lz->slide_dic_tree_left[q] = lz->slide_dic_tree_left[p];
			lz->slide_dic_tree_parent[lz->slide_dic_tree_left[p]] = q;
        }
		lz->slide_dic_tree_right[q] = lz->slide_dic_tree_right[p];
		lz->slide_dic_tree_parent[lz->slide_dic_tree_right[p]] = q;
    }
	lz->slide_dic_tree_parent[q] = lz->slide_dic_tree_parent[p];
	if (lz->slide_dic_tree_right[lz->slide_dic_tree_parent[p]] == p) {
		lz->slide_dic_tree_right[lz->slide_dic_tree_parent[p]] = q;
	}
    else {
		lz->slide_dic_tree_left[lz->slide_dic_tree_parent[p]] = q;
    }
	lz->slide_dic_tree_parent[p] = NIL;

	return;
}

COMP_result COMP_encodeLzSlideDic(COMP_lz *lz) {
	COMP_result result = COMP_ok;
    int i, len, r, s = 0, encoded_size, encbuf_pos;
    unsigned char encbuf[COMP_LZ_MATCH_LENGTH_MAX - 1], mask;
    unsigned long int incount = 0, printcount = 0, cr;

    /* initialize encoding buffer */
    encbuf[0] = 0;
    encbuf_pos = 1;
    mask = 1;
    /* initialize ring buffer */
	r = COMP_LZ_RING_BUF_SIZE - COMP_LZ_MATCH_LENGTH_MAX;
    for(i = s; i < r; i++) {
		lz->slide_dic_text[i] = 0;
    }
    /* input data to ring buffer */
    for(len = 0; len < COMP_LZ_MATCH_LENGTH_MAX; len++) {
		if(lz->inbuf_byte_pos == lz->inbuf_data_size) {
			break;
		}
        lz->slide_dic_text[r + len] = lz->inbuf[lz->inbuf_byte_pos];
		lz->inbuf_byte_pos++;
    }

    incount = len;
    if(incount == 0) {
        result = COMP_err;
		goto err;
	}
    for(i = 1; i <= COMP_LZ_MATCH_LENGTH_MAX; i++) {
        COMP_insertSlideDicTree(lz, (r - i));
    }
    COMP_insertSlideDicTree(lz, r);

    for(;;) {
		if(lz->slide_dic_match_len > len) {
            lz->slide_dic_match_len = len;
        }
        if(lz->slide_dic_match_len < 3) {
            /* encoded input data size */
			lz->slide_dic_match_len = 1;
            /* set indicator */
            encbuf[0] |= mask;
            /* encode character itself */
			encbuf[encbuf_pos] = lz->slide_dic_text[r];
            encbuf_pos++;
        }
        else { 
            /* encode position 12bits and length 4bits*/
			encbuf[encbuf_pos] = (unsigned char)lz->slide_dic_match_pos;
			encbuf_pos++;
			encbuf[encbuf_pos] = (unsigned char)(((lz->slide_dic_match_pos >> 4) & 0xf0) | (lz->slide_dic_match_len - 3));
			encbuf_pos++;
        }
        mask = mask << 1;
        if(mask == 0) {
            /* after 8 times */
            /* output encoded data */
            for(i = 0; i < encbuf_pos; i++) {
                lz->outbuf[lz->outbuf_byte_pos] = encbuf[i];
                lz->outbuf_byte_pos++;
            }
			lz->outbuf_data_size += encbuf_pos;
            /* initialize encode buffer */
            encbuf[0] = 0;
            encbuf_pos = 1;
            mask = 1;
        }
		encoded_size = lz->slide_dic_match_len;
        /* restructure tree and detect the match string */
        for(i = 0; (i < encoded_size) && (lz->inbuf_byte_pos == lz->inbuf_data_size); i++) {
            /* delete the ring buffer data which dropped off the dictionary from search tree */
            COMP_deleteSlideDicTree(lz, s);
            if (lz->inbuf_byte_pos != lz->inbuf_data_size) {
                /* copy input data to ring buffer */
			    lz->slide_dic_text[s] = lz->inbuf[lz->inbuf_byte_pos];
                if(s < COMP_LZ_MATCH_LENGTH_MAX - 1) {
				    lz->slide_dic_text[s + COMP_LZ_RING_BUF_SIZE] = lz->inbuf[lz->inbuf_byte_pos];
			    }
			    lz->inbuf_byte_pos++;
            }
            else {
                len = len - 1; /* len should not be below 0 */
            }
            s = (s + 1)&(COMP_LZ_RING_BUF_SIZE - 1); /* proceed to next index with circling */
            r = (r + 1)&(COMP_LZ_RING_BUF_SIZE - 1); /* proceed to next index with circling */
            /* insert a ring buffer data to the search tree and detect the match string */
            if (len > 0) {
                COMP_insertSlideDicTree(lz, r);
            }
        }
        /* log */
        if ((incount += i) > printcount) {
            printf("%12lu\r", incount);
            printcount += 1024;
        }
        /* */         
		if(len == 0) {
            /* there is no input data to be encoded */
			break;
		}
    }
    /* if there are any data in encbuf, output */
    if (encbuf_pos > 1) {
        for(i = 0; i < encbuf_pos; i++) {
            lz->outbuf[lz->outbuf_byte_pos] = encbuf[i];
            lz->outbuf_byte_pos++;
        }
        lz->outbuf_data_size += encbuf_pos;
    }
    /* log */
    printf("In : %lu bytes\n", incount);
	printf("Out: %lu bytes\n", lz->outbuf_data_size);
    if (incount != 0) {
		cr = (1000 * lz->outbuf_data_size + incount / 2) / incount;
        printf("Out/In: %lu.%03lu\n", cr/1000, cr%1000);
    }
    /* log */

err:
	return result;
}

COMP_result COMP_decodeLzSlideDic(COMP_lz *lz, unsigned long int size) {
	COMP_result result = COMP_ok;

    int i, j, k, r, c;
    unsigned int flags;

    for(i = 0; i < COMP_LZ_RING_BUF_SIZE - COMP_LZ_MATCH_LENGTH_MAX; i++) {
		lz->slide_dic_text[i] = 0;
	}
    r = COMP_LZ_RING_BUF_SIZE - COMP_LZ_MATCH_LENGTH_MAX;
    flags = 0;
    for(;;) {
        if(((flags >>= 1) & 256) == 0) {
            //if ((c = getc(infile)) == EOF)
                break;
            flags = c | 0xff00;
        }
        if (flags & 1) {
            //if((c = getc(infile)) == EOF)
                break;
            //putc(c, outfile);
				lz->slide_dic_text[r++] = c;
            r &= (COMP_LZ_RING_BUF_SIZE - 1);
        }
        else {
            //if ((i = getc(infile)) == EOF)
                break;
            //if ((j = getc(infile)) == EOF)
                break;
            i |= ((j & 0xf0) << 4);
            j = (j &0x0f) + 2;
            for(k = 0; k <= j; k++) {
				c = lz->slide_dic_text[(i + k)&(COMP_LZ_RING_BUF_SIZE - 1)];
                //putc(c, outfile);
				lz->slide_dic_text[r++] = c;
                r &= (COMP_LZ_RING_BUF_SIZE - 1);
            }
        }
    }
    printf("%12lu\n", size);

	return result;
}
