/*!
	Interrupt.c
	Interrupt Handler and so on.
	(C) 2014 VOSystems.
*/

#include<VaneOS.h>
#include<KeyBoard.h>
#include<Interrupt.h>
#include<scancode.h>
#include<Message.h>
#include<timer.h>

#define UINT_MAX 0x100000000

static volatile unsigned int timer_tick;
int system_key_code_flag,break_flag;
unsigned long long input;

struct msg_data kernel;
int kernelbuf[32];

void timer_interrupt( void )
{
	/*count tick*/
	timer_tick++;
	
	if(timer.next>timer.count)
	{
		return;
	}
	int i;
	for(i=0;i<timer.using;i++)
	{
		if(timer.timers[i]->timeout>timer.count)
		{
			break;
		}
		timer.timers[i]->flags=TIMER_FLAGS_ALLOC;
		msg_put(timer.timers[i]->msg,timer.timers[i]->data);
	}
	int j;
	timer.using-=i;
	for(j=0;j<timer.using;j++)
	{
		timer.timers[j]=timer.timers[j+i];
	}
	if(timer.using>0){
		timer.next=timer.timers[0]->timeout;
	}else{
		timer.next=0xffffffff;
	}
	return;
}

void keyboard_interrupt( void )
{
	msg_put(&kernel,readKbdEncBuffer()+buf_separate_keyboard);
}

inline void enable()
{
  __asm__ __volatile__ ("sti");
}

inline void disable()
{
  __asm__ __volatile__ ("cli");
}
