/*
nullptr interpreter
(C) 2015 VOSystems.
*/

#include"nullptr.h"
#include"Interpreter.h"
#include"Module.h"
#include<regex>
#include<thread>
#include<future>

using namespace std;
using namespace VOSystemsNullptr::Core;

inline LibraryFunction SearchDLL(Library lib, string name);

bool Module::Connect(std::string name)
{
	m_mf=DllSearch(name);
	string dllname=m_mf.dllname;

	if(m_CurrentConnectModuleName==dllname){
		return true;
	}else if(!m_CurrentConnectModuleName.empty()){
		DisConnect();
	}

	m_module=LoadLibrary((dllname+".dll").c_str());
	if(m_module==NULL){
		m_CurrentConnectModuleName="";
		return false;
	}else{
		m_CurrentConnectModuleName=dllname;
		
		return true;
	}
}

bool Module::Run(std::string name, BasicTypes::Int* paramInt, BasicTypes::String* paramString)
{
	if(!Connect(name))return false;
	
	switch(m_mf.mode){
	case System::NotFound:
	case System::BoolType:
	default:
		return false;
		break;
	case System::IntType:
		Core::IntFunc ifunc=(Core::IntFunc)GetProcAddress(m_module,"runRI");
		m_int=(*ifunc)(name,paramInt,paramString);
		
		break;
	case System::StringType:
		Core::StrFunc sfunc=(Core::StrFunc)GetProcAddress(m_module,"runRS");
		m_str=(*sfunc)(name,paramInt,paramString);
		break;
	}
	return true;
}

bool Module::DisConnect(void)
{
	if(m_module==NULL)return true;

	if(FreeLibrary(m_module)){
		m_module=NULL;
		return true;
	}else{
		return false;
	}
}

LibraryFunction Module::DllSearch(std::string name)
{
	this->m_modules.size();
	vector<thread> th(this->m_modules.size());
	vector<future<LibraryFunction>> fu(this->m_modules.size());

	for(size_t C=0; C<this->m_modules.size(); C++){
		Library mod=m_modules[C];
		fu[C]=async([mod,name](string){SearchDLL(mod,name);});//th[C]=thread([mod,name](){SearchDLL(mod,name);});
	}

	vector<LibraryFunction> result(this->m_modules.size());
	for(size_t C=0; C<this->m_modules.size(); C++){
		result[C]=fu[C].get();
		if(!result[C].mode==System::NotFound){
			return result[C];
		}
	}

	LibraryFunction mf;
	mf.mode=System::NotFound;
	return mf;
}

inline LibraryFunction SearchDLL(Library lib, string name)
{
	for(size_t C=0; C<lib.size(); C++){
		if(lib[C].name==name){
			return lib[C];
		}
	}
	LibraryFunction mf;
	mf.mode=VOSystemsNullptr::System::NotFound;
	return mf;
}