var express = require('express');
var app = express();
var path = require('path');
const { graphqlHTTP } = require('express-graphql');
const mongodb = require('mongodb');
const bodyParser = require("body-parser");
const jwt = require('jsonwebtoken');
const fileUpload = require('express-fileupload');
const fs = require('fs');

const dburl = 'mongodb://127.0.0.1:27017/db';

const context = () => mongodb.MongoClient.connect(dburl,
{ useNewUrlParser: true, useUnifiedTopology: true }
).then(client => client.db('ont_database'));

const secret = '3¤e(-arup20/&_Random_319!ipuok5.';
const url = 'http://localhost:9000/graphql';

module.exports = { dburl, context, secret, url };

const schema = require('./schema/schema');
const resolvers = require('./dboperations/resolvers');

const kayttajanhaku = require('./queries/kayttajahaku');
const ilmoituksienhaku = require('./queries/ilmoitustenhaku');
const ilmoituksenhaku = require("./queries/ilmoitushaku");
const ilmoitustekstinhaku = require("./queries/ilmoitustekstihaku");
const kayttajanomat = require("./queries/kayttajanilmoitukset");
const kayttajanhakemukset = require('./queries/kayttajahakemukset');
const hakemuksienhaku = require('./queries/hakemustenhaku');
const hakemuksenhaku = require('./queries/hakemushaku');

const register = require("./mutations/register");
const ilmoituksenlisays = require("./mutations/ilmoituslisays");
const ilmoituksentallennus = require("./mutations/ilmoitustallennus");
const ilmoituksenpoisto = require("./mutations/ilmoituspoisto");
const ilmoituksentallennuspoisto = require("./mutations/ilmoitustallennuspoisto");
const ilmoituksenmuokkaus = require("./mutations/ilmoitusmuokkaus");
const hakemuksenlahetys = require('./mutations/hakemuslahetys');
const hakemuksenlisays = require('./mutations/hakemuslisays');
const hakemuksentallennus = require('./mutations/hakemustallennus');
const hakemuksenpoisto = require('./mutations/hakemuspoisto');
const hakemuksenidpoisto = require('./mutations/hakemusidpoisto');
const hakemuksentallennuspoisto = require('./mutations/hakemustallennuspoisto');
const kuvanlisays = require('./mutations/kuvalisays');
const kuvanpoisto = require('./mutations/kuvapoisto');
const cvnlisays = require('./mutations/cvlisays');
const cvnpoisto = require('./mutations/cvpoisto');
const cvntiedostopoisto = require('./mutations/cvtiedostopoisto');
const cvnchunkpoisto = require('./mutations/cvchunkpoisto');
const profiilinvahvistus = require('./mutations/profiilivahvistus');
const salasananvaihto = require('./mutations/salasanavaihto');
const profiilinpoisto = require('./mutations/profiilipoisto');

const verifyjwt = require('./helpers/jwttarkistus');
const login = require('./helpers/log');
const signin = require('./helpers/sign');
const jatko = require('./helpers/jatkoa');
const poistuminen = require('./helpers/modaalinsulkeminen');
const kirjautuminen = require("./helpers/kirjautuminen");
const logout = require("./helpers/logout");
const omattiedot = require("./helpers/kayttajanomattiedot");
const juuripolku = require('./helpers/root');
const home = require('./helpers/home');
const kaikkiilmoitukset = require('./helpers/ilmoituksetkaikki');
const tekstinhakutulostus = require('./helpers/tekstihakutulostus');
const ilmoituksientulostus = require('./helpers/ilmoitustentulostus');
const ilmoituksenhakemukset = require('./helpers/hakemuksetilmoituksen');
const lisays = require('./helpers/lisays');
const muokkauksenlomake = require('./helpers/muokkauslomake');
const poistomodaali = require('./helpers/ilmoituspoistomodaali');
const hakemuksenlomake = require('./helpers/hakemuslomake');
const omathakemukset = require('./helpers/kayttajanomathakemukset');
const omahakemus = require('./helpers/kayttajanhakemus');
const ilmoittajantiedot = require('./helpers/ilmoittajatiedot');
const ilmoituksentarkistus = require('./helpers/ilmoitustarkistus');
const hakemuksentarkistus = require('./helpers/hakemustarkistus');
const hakemuksentulostus = require('./helpers/hakemustulostus');
const tiedostontarkistus = require('./helpers/tiedostotarkistus');
const profiilinmuokkaus = require('./helpers/profiilimuokkaus');
const cvnlataus = require('./helpers/cvlataus');
const vaihdonmodaali = require('./helpers/vaihtomodaali');
const poistonaloitus = require('./helpers/poistoaloitus');

app.use(fileUpload());

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ "extended": true }));

app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

app.use('/graphql', graphqlHTTP({
    schema: schema,
    rootValue: resolvers,
    graphiql: true,
    context
}));

app.use("/styles", express.static(__dirname + "/styles"));
app.use("/icons", express.static(__dirname + "/icons"));

app.get('/', (req, res) => {
    juuripolku.jp((data) => {
        res.send(data);
    })
});

// front page
app.post('/home', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    home.koti(req.body.access, data, (printeddata) => {
                        res.render('index', printeddata);
                    });
                } else {
                    res.redirect('/logout');
                }
            }); 
        } else {
            home.koti(null, null, (printdata) => {
                res.render('index', printdata);
            });
        }
    });
});

// opens login form
app.post('/log', (req, res) => {
    login.tuoKirjautumisLomake(req.body, (printeddata) => {
        res.render('index', printeddata);
    });
});

// opens signup form
app.post('/sign', (req, res) => {
    signin.tuoRekisteroitumisLomake(req.body, null, (printeddata) => {
        res.render('index', printeddata);
    });
});

// checks the validity of user credentials, then opens second page of the sign up form or throws an error
app.post("/jatka", (req, res) => {
    let fragments = "KayttajaTunnus";
    kayttajanhaku.haeKayttaja(req.body.username, fragments, (data) => {
        jatko.fillLoput(req.body, data, null, (err, printeddata) => {
            if (err) {
                signin.tuoRekisteroitumisLomake(req.body, err, (printeddata) => {
                    res.render('index', printeddata);
                });
            } else {
                res.render('index', printeddata);
            }
        });
    });
});

// creates a new user and logs in or throws an error
app.post("/signup", (req, res) => {
    register.luoTunnus(req.body, (err, bridge) => {
        if (err) {
            jatko.fillLoput(req.body, null, err, (impossible, printeddata) => {
                res.render('index', printeddata);
            });
        } else {
            res.send(bridge);
        }
    });
});

// checks the validity of user credentials submitted by the user, if valid logs in and saves token to the localstorage, if not throws an error
app.post("/login", (req, res) => {
    let fragments = "SalaSana";
    kayttajanhaku.haeKayttaja(req.body.username, fragments, (data) => {
        kirjautuminen.kirjaudu(req.body, data, (err, bridge) => {
            if (err) {
                res.render('index', err);
            } else {
                res.send(bridge);
            }
        });
    });
});

// logs out and clears localstorage
app.get("/logout", (req, res) => {
    logout.bridge((bridge) => {
        res.send(bridge);
    });
});

// closes the modal
app.post('/pois', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    poistuminen.poistaModaali(req.body, data, (printeddata) => {
                        res.render('index', printeddata);
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            if (req.body.kuvaruutu == "etusivu" || req.body.kuvaruutu == "haku") {
                poistuminen.poistaModaali(req.body, null, (printeddata) => {
                    res.render('index', printeddata);
                });
            } else {
                res.redirect('/');
            }
        }
    });
});

// opens a tab for adding new advertisements
app.post('/lisaysvalilehti', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    lisays.lisa(req.body.access, data, (printeddata) => {
                        res.render('index', printeddata);
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens a tab which shows all the advertisements that the user has created
app.post('/omat', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let omatfragmentit = "IlmoitusId\ntitle\ndesc\ndate\nHakemukset";
                    kayttajanomat.haeKayttajanIlmoitukset(data.KayttajaTunnus, omatfragmentit, (array) => {
                        ilmoituksientulostus.tulostaOmat(req.body.access, data, array, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens a modal that shows all the applications that are directed to the current advertisement
app.post("/showapplications", (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
					let hakemusfragmentit = "HakemusId\ndate\ntitle\nauth";
                    hakemuksienhaku.haeHakemukset(req.body.tunnus, hakemusfragmentit, (applications) => {
                        ilmoituksenhakemukset.tulostaHakemukset(req.body, data, applications, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// finds a specific application document and the author user document from the database and prints the information to the screen 
app.post("/hakemus", (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let hakemusfragmentit = "date\ntitle\ndesc";
                    hakemuksenhaku.haeHakemus(req.body.hakemusid, hakemusfragmentit, (application) => {
                        let applicantfragments = "KayttajaTunnus\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\nDescription\nAnsioluettelo";
                        kayttajanhaku.haeKayttaja(req.body.username, applicantfragments, (applicant) => {
                            hakemuksentulostus.tulostaHakemus(req.body, application, data, applicant, (printeddata) => {
                                res.render("index", printeddata);
                            })
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens a tab that shows user information
app.post('/omattiedot', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    omattiedot.tulostaKayttajanTiedot(req.body.access, data, false, (printeddata) => {
                        res.render("index", printeddata);
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens a tab that shows all the applications that the user has created
app.post('/hakemukset', (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let hakemusfragmentit = "date\nHakemusId\nIlmoitusId";
                    kayttajanhakemukset.haeKayttajanHakemukset(data.KayttajaTunnus, hakemusfragmentit, (hakemukset) => {
                        omathakemukset.tulostaHakemukset(req.body.access, data, hakemukset, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens the search tab and prints all the advertisements from the database
app.post('/getall/', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    ilmoituksienhaku.haeKaikki((adverts) => {
                        kaikkiilmoitukset.tulostaIlmoitukset(req.body.access, data, adverts, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            ilmoituksienhaku.haeKaikki((adverts) => {
                kaikkiilmoitukset.tulostaIlmoitukset(req.body.access, null, adverts, (printeddata) => {
                    res.render("index", printeddata);
                });
            });
        }
    });
});

// prints all the advertisements that match the search criteria
app.post("/haeotsikolla/", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    ilmoitustekstinhaku.haeIlmoituksia(req.body, (adverts, regs) => {
                        tekstinhakutulostus.tulostaTulokset(req.body, data, adverts, regs, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            ilmoitustekstinhaku.haeIlmoituksia(req.body, (adverts, regs) => {
                tekstinhakutulostus.tulostaTulokset(req.body, null, adverts, regs, (printeddata) => {
                    res.render("index", printeddata);
                });
            });
        }
    });
});

// inserts a new advertisement to the database, creates an own id to it and saves the id to the user profile
// if invalid information is submitted, then error is thrown
app.post("/lisaa/", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    ilmoituksentarkistus.tarkistaIlmoitus(req.body, data, "lisays", false, (err, printdata) => {
                        if (err) {
                            res.render("index", printdata);
                        } else {
                            ilmoituksenlisays.lisaaIlmoitus(req.body, data.KayttajaTunnus, (advert) => {
                                ilmoituksentallennus.tallennaIlmoitus(req.body.access, data, advert, (printeddata) => {
                                    res.render("index", printeddata);
                                });
                            });
                        }
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens an advertisement deleting modal
app.post('/ilmoituspoisto', (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    poistomodaali.avaaPoistoModaali(req.body, data, (printeddata) => {
                        res.render('index', printeddata);
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// deletes an advertisement from the database and it's id from the user profile,
// deletes all the applications directed to this advertisement from the database and the user documents,
// then prints out the user's own advertisements
app.post("/poista/", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    ilmoituksenpoisto.poistaIlmoitus(req.body.tunnus, () => {
                        ilmoituksentallennuspoisto.poistaTallennus(req.body.tunnus, data.KayttajaTunnus, () => {
                            let hakemusfragmentit = "HakemusId\nauth";
                            hakemuksienhaku.haeHakemukset(req.body.tunnus, hakemusfragmentit, (newdata) => {
                                newdata.forEach(hakemus => {
                                    hakemuksenpoisto.poistaHakemus(hakemus.HakemusId, () => {
                                        hakemuksentallennuspoisto.poistaTallennus(hakemus.HakemusId, hakemus.auth, () => {
                                        });
                                    });
                                });
                            }).then(() => {
                                let ilmoitusfragmentit = "IlmoitusId\ntitle\ndesc\ndate\nHakemukset";
                                kayttajanomat.haeKayttajanIlmoitukset(data.KayttajaTunnus, ilmoitusfragmentit, (array) => {
                                    ilmoituksientulostus.tulostaOmat(req.body.access, data, array, (printeddata) => {
                                        res.render("index", printeddata);
                                    });
                                });
                            });
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens an application form modal
app.post("/teehakemus", (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let ilmoitusfragmentit = "IlmoitusId\ntitle\ndesc\ndate\nauth";
                    ilmoituksenhaku.haeIlmoitus(req.body.tunnus, ilmoitusfragmentit, (ilmoitus) => {
						let newfragments = "Kuva\nEtuNimi\nSukuNimi\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription";
                        kayttajanhaku.haeKayttaja(ilmoitus.auth, newfragments, (recruiter) => {
                            hakemuksenlomake.hakemus(req.body, data, ilmoitus, recruiter, (printeddata) => {
                                res.render("index", printeddata);
                            });
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
	});
});

// inserts a new application to the database, creates an own id to it and saves this id to the user profile and the advertisement document, then prints all the advertisements
app.post("/sendapplication", (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli\nDocuments";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    hakemuksentarkistus.tarkistaHakemus(req.body, data, (err, printdata) => {
                        if (err) {
                            res.render("index", printdata);
                        } else {
                            hakemuksenlahetys.lahetaHakemus(req.body, data.KayttajaTunnus, (hakemusid) => {
                                hakemuksenlisays.lisaaHakemus(req.body.mdlcntnt, hakemusid, () => {
                                    hakemuksentallennus.tallennaHakemus(data.KayttajaTunnus, hakemusid, () => {
                                        ilmoituksienhaku.haeKaikki((adverts) => {
                                            kaikkiilmoitukset.tulostaIlmoitukset(req.body.access, data, adverts, (printeddata) => {
                                                res.render("index", printeddata);
                                            });
                                        });
                                    });
                                });
                            });
                        }
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens a modal which shows the application letter as well as the advertisement that it's directed to
app.post("/omahakemus", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let hakemusfragmentit = "HakemusId\ndate\ntitle\ndesc\nIlmoitusId";
                    hakemuksenhaku.haeHakemus(req.body.tunnus, hakemusfragmentit, (hakemus) => {
                        let ilmoitusfragmentit = "title\ndesc\ndate\nauth";
                        ilmoituksenhaku.haeIlmoitus(hakemus.IlmoitusId, ilmoitusfragmentit, (ilmoitus) => {
                            omahakemus.tulostaOmaHakemus(req.body, data, hakemus, ilmoitus, (printeddata) => {
                                res.render('index', printeddata);
                            });
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// prints the information of advertisement's author to the modal
app.post("/ilmoittajantiedot", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let ilmoittajafragmentit = "KayttajaTunnus\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription"
                    kayttajanhaku.haeKayttaja(req.body.username, ilmoittajafragmentit, (newdata) => {
                        ilmoittajantiedot.tulostaModaali(req.body, data, newdata, (printeddata) => {
                            res.render('index', printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// deletes an application from the database and it's id from the user profile and the advertisement document, then prints all the user's applications
app.post("/vetaydy", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    hakemuksenpoisto.poistaHakemus(req.body.tunnus, () => {
                        hakemuksenidpoisto.poistaHakemusId(req.body.tunnus, req.body.ilmoitustunnus, () => {
                            hakemuksentallennuspoisto.poistaTallennus(req.body.tunnus, data.KayttajaTunnus, () => {
                                let hakemusfragmentit = "date\nHakemusId\nIlmoitusId";
                                kayttajanhakemukset.haeKayttajanHakemukset(data.KayttajaTunnus, hakemusfragmentit, (hakemukset) => {
                                    omathakemukset.tulostaHakemukset(req.body.access, data, hakemukset, (printeddata) => {
                                        res.render("index", printeddata);
                                    });
                                }); 
                            });
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// opens an advertisement editing modal
app.post("/muokkaa", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
            let fragments = "KayttajaTunnus\nRooli";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
                if (data) {
                    let ilmoitusfragmentit = "IlmoitusId\ntitle\ndesc\nala\nmaakunta";
                    ilmoituksenhaku.haeIlmoitus(req.body.tunnus, ilmoitusfragmentit, (ilmoitus) => {
                        muokkauksenlomake.muokkaus(req.body, data, ilmoitus, (printeddata) => {
                            res.render("index", printeddata);
                        });
                    });
                } else {
                    res.redirect('/logout');
                }
            });
        } else {
            res.redirect('/');
        }
    });
});

// checks if the advertisement info is valid, then confirms the changes to be saved to the database and prints all the user's own advertisements or throws an error
app.post("/teemuutokset", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nRooli";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					if (req.body.ala == null || req.body.maakunta == "va" || req.body.title == "" || req.body.desc == "") {
						ilmoituksentarkistus.tarkistaIlmoitus(req.body, data, "omat", "muokkaus", (printeddata) => {
							res.render("index", printeddata);
						});
					} else {
						ilmoituksenmuokkaus.teeMuutokset(req, () => {
							let ilmoitusfragmentit = "IlmoitusId\ntitle\ndesc\ndate\nHakemukset";
							kayttajanomat.haeKayttajanIlmoitukset(data.KayttajaTunnus, ilmoitusfragmentit, (array) => {
								ilmoituksientulostus.tulostaOmat(req.body.access, data, array, (printeddata) => {
									res.render("index", printeddata);
								});
							});
						});
					}
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// adds a picture file to the user profile if the file is valid, then prints out the user information
app.post("/addpicture", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					kuvanlisays.lisaaKuva(req.files, data.KayttajaTunnus, (huom) => {
						let newfragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
						kayttajanhaku.haeKayttaja(confirmation, newfragments, (newdata) => {
							omattiedot.tulostaKayttajanTiedot(req.body.access, newdata, huom, (printeddata) => {
								res.render("index", printeddata);
							});
						});
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// deletes a profile picture from the user document, then prints out the user information
app.post("/deletepicture", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					kuvanpoisto.poistaKuva(data.KayttajaTunnus, () => {
						let newfragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
						kayttajanhaku.haeKayttaja(confirmation, newfragments, (newdata) => {
							omattiedot.tulostaKayttajanTiedot(req.body.access, newdata, null, (printeddata) => {
								res.render("index", printeddata);
							});
						});
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// opens a text field on the user information page to enable user to modify texts
app.post("/profiilimuokkaus", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					profiilinmuokkaus.muokkaaProfiili(req.body, data, (printeddata) => {
						res.render("index", printeddata);
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// updates the user profile, then prints out the user information
app.post("/profiilivahvistus", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nEtuNimi\nSukuNimi\nHomeAddress\nPhoneNumber\nDescription";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					profiilinvahvistus.vahvistaProfiili(req.body, data, () => {
						let newfragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
						kayttajanhaku.haeKayttaja(confirmation, newfragments, (newdata) => {
							omattiedot.tulostaKayttajanTiedot(req.body.access, newdata, null, (printeddata) => {
								res.render("index", printeddata);
							});
						});
					});
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// deletes the cv from the user document, the cv-file- and cv-chunk collections, then prints out the user information
app.post("/deletecv", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					cvnpoisto.poistaCV(data.KayttajaTunnus, () => {
						cvntiedostopoisto.poistaCVFile(data.KayttajaTunnus, () => {
							cvnchunkpoisto.poistaCVChunk(data.KayttajaTunnus, () => {
								let newfragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
								kayttajanhaku.haeKayttaja(confirmation, newfragments, (newdata) => {
									omattiedot.tulostaKayttajanTiedot(req.body.access, newdata, null, (printeddata) => {
										res.render("index", printeddata);
									});
								});
							});
						});
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// downloads the cv file from the database
app.post("/downloadcv", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					cvnlataus.lataaCV(req.body, (tiedosto) => {
						res.setHeader('Content-disposition', 'attachment; filename="' + req.body.cv + '"');
						res.send(tiedosto);
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// first checks that the cv file is valid and throws an error if if's not, then deletes the current cv file from the user document and the cv-file- and cv-chunk collections,
// then inserts the new file to them and prints out the user information
app.post("/addcv", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					tiedostontarkistus.tarkistaTiedosto(req.files, (huom) => {
						if (huom.tiedosto) {
							omattiedot.tulostaKayttajanTiedot(req.body.access, data, huom, (printederrordata) => {
								res.render("index", printederrordata);
							});
						} else {
							cvntiedostopoisto.poistaCVFile(data.KayttajaTunnus, () => {
								cvnchunkpoisto.poistaCVChunk(data.KayttajaTunnus, () => {
									cvnlisays.lisaaCV(req.files, data.KayttajaTunnus, () => {
										kayttajanhaku.haeKayttaja(confirmation, fragments, (newdata) => {
											omattiedot.tulostaKayttajanTiedot(req.body.access, newdata, null, (printeddata) => {
												res.render("index", printeddata);
											});
										});
									});
								});
							});
						}
					});
				} else {
					res.render('/logout');
				}
			});
		} else {
			res.render('/');
		}
    });
});

// opens a modal for password change
app.post("/vaihdonaloitus", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					vaihdonmodaali.avaaModaali(req.body.access, data, null, "vaihto", (printeddata) => {
						res.render("index", printeddata);
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// checks the validity of password information submitted by user, then prints the confirmation or throws an error
app.post("/salasananvaihto", (req, res) => {
	verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
		if (error) {
			res.redirect('/logout');
		} else if (confirmation) {
			let fragments = "KayttajaTunnus\nSalaSana\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					salasananvaihto.vaihdaSalasana(req.body, data, (huom, mc) => {
						vaihdonmodaali.avaaModaali(req.body.access, data, huom, mc, (printeddata) => {
							res.render("index", printeddata);
						});
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
	});
});

// opens a modal that requires user to confirm the profile deletion
app.post("/poistonaloitus", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "KayttajaTunnus\nRooli\nDocuments\nKuva\nEtuNimi\nSukuNimi\nSukuPuoli\nEmailAddress\nHomeAddress\nPhoneNumber\ndate\nDescription\nAnsioluettelo";
            kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					poistonaloitus.aloitaPoisto(req.body.access, data, (printeddata) => {
						res.render("index", printeddata);
					});
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

// removes a profile from the database and all applications and advertisements that are linked to it
// removed advertisements and the applications related to it are deleted from the database
// removed applications are deleted from the database, user documents and advertisement documents
// deletes the cv documents from the file- and chunk-collections
// logs out
app.post("/poistaprofiili", (req, res) => {
    verifyjwt.tarkistaJWT(req.body.access, (error, confirmation) => {
        if (error) {
            res.redirect('/logout');
        } else if (confirmation) {
			let fragments = "Rooli";
			kayttajanhaku.haeKayttaja(confirmation, fragments, (data) => {
				if (data) {
					profiilinpoisto.poistaProfiili(confirmation, () => {
						if (data.Rooli == 'RECRUITER') {
							let ilmoitusfragmentit = "IlmoitusId";
							kayttajanomat.haeKayttajanIlmoitukset(confirmation, ilmoitusfragmentit, (array) => {
								if (array[0].docs) {
                                    let hakemusfragmentit = "HakemusId\nauth";
									array[0].docs.forEach(element => {
										ilmoituksenpoisto.poistaIlmoitus(element.IlmoitusId, () => {
											hakemuksienhaku.haeHakemukset(element.IlmoitusId, hakemusfragmentit, (newdata) => {
												newdata.forEach(hakemus => {
													hakemuksenpoisto.poistaHakemus(hakemus.HakemusId, () => {
														hakemuksentallennuspoisto.poistaTallennus(hakemus.HakemusId, hakemus.auth, () => {
														});
													});
												});
											});
										});
									});
								}
							});
						} else {
							let hakemusfragmentit = "HakemusId\nIlmoitusId";
							kayttajanhakemukset.haeKayttajanHakemukset(confirmation, hakemusfragmentit, (hakemukset) => {
                                cvntiedostopoisto.poistaCVFile(confirmation, () => {
                                    cvnchunkpoisto.poistaCVChunk(confirmation, () => {
                                        hakemukset.forEach(element => {
                                            hakemuksenpoisto.poistaHakemus(element.HakemusId, () => {
                                                hakemuksenidpoisto.poistaHakemusId(element.HakemusId, element.IlmoitusId, () => {
												});
											});
										});
									});
								});
							});
						}
					}).then(
						logout.bridge((bridge) => {
							res.send(bridge);
						}
					));
				} else {
					res.redirect('/logout');
				}
			});
		} else {
			res.redirect('/');
		}
    });
});

app.listen(9000);