// This module is used in updating a user document by deleting an application id from the
// document's "Documents"-array. The function takes an application id-string and an advertisement
// id-string as parameters. Then a graphql-mutation is performed with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "poistaHakemusId": async (hakemustunnus, ilmoitustunnus, cb) => {
        const data = JSON.stringify({
            query: `mutation {
                hakemusidPoisto(ilmoitusid: ${ilmoitustunnus}, hakemusid: ${hakemustunnus})
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.hakemusidPoisto);
        cb();
    }

};