// This module is used in deleting an advertisement document from the database.
// The function takes an advertisement id-integer as a parameter. Then a
// graphql-mutation is performed with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "poistaIlmoitus": async (ilmoitusid, cb) => {
        const data = JSON.stringify({
            query: `mutation {
						ilmoituksenPoisto(id: ${ilmoitusid}) 
					  }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.ilmoituksenPoisto);
        cb();
    }

};