package jp.gr.java_conf.wutse.purewiki.swt;

import java.io.File;
import java.util.List;

import jp.gr.java_conf.wutse.purewiki.PureWikiConfig;
import jp.gr.java_conf.wutse.purewiki.util.PureWikiUtil;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PureWikiPreference extends Dialog {

	protected int result;
	protected Shell shell;
	private Text srcDirText;
	private Text outDirText;
	private Text cssFileText;
	private Text defaultWikiText;

	private PureWikiConfig config = null;

	/**
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public PureWikiPreference(Shell parent, PureWikiConfig config) {
		super(parent, SWT.CLOSE | SWT.TITLE | SWT.APPLICATION_MODAL);
		setText("設定 - PureWiki");
		this.config = config;

	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public int open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(567, 322);
		shell.setText(getText());
		shell.setLayout(new GridLayout(4, false));
		new Label(shell, SWT.NONE);
		new Label(shell, SWT.NONE);
		new Label(shell, SWT.NONE);
		new Label(shell, SWT.NONE);
		new Label(shell, SWT.NONE);

		Group group = new Group(shell, SWT.NONE);
		group.setText("設定");
		group.setLayout(new GridLayout(4, false));
		GridData gd_group = new GridData(SWT.FILL, SWT.FILL, false, false, 3, 1);
		gd_group.heightHint = 197;
		gd_group.widthHint = 458;
		group.setLayoutData(gd_group);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);

		Label srcDirLabel = new Label(group, SWT.NONE);
		srcDirLabel.setAlignment(SWT.RIGHT);
		GridData gd_srcDirLabel = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_srcDirLabel.widthHint = 100;
		srcDirLabel.setLayoutData(gd_srcDirLabel);
		srcDirLabel.setText("ホームフォルダ");

		srcDirText = new Text(group, SWT.BORDER);
		GridData gd_srcDirText = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_srcDirText.widthHint = 300;
		srcDirText.setLayoutData(gd_srcDirText);

		Button srcDirButton = new Button(group, SWT.NONE);
		srcDirButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog dialog = new DirectoryDialog(shell);
				String path = dialog.open();
				if (path != null) {
					srcDirText.setText(path);
				}
			}
		});
		srcDirButton.setText("･･･");
		new Label(group, SWT.NONE);

		Label outDirLabel = new Label(group, SWT.NONE);
		outDirLabel.setAlignment(SWT.RIGHT);
		outDirLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		outDirLabel.setText("出力先フォルダ");

		outDirText = new Text(group, SWT.BORDER);
		outDirText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Button outDirButton = new Button(group, SWT.NONE);
		outDirButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog dialog = new DirectoryDialog(shell);
				String path = dialog.open();
				if (path != null) {
					outDirText.setText(path);
				}
			}
		});
		outDirButton.setText("･･･");
		new Label(group, SWT.NONE);

		Label cssFileLabel = new Label(group, SWT.NONE);
		cssFileLabel.setAlignment(SWT.RIGHT);
		cssFileLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		cssFileLabel.setText("CSSファイル");

		cssFileText = new Text(group, SWT.BORDER);
		cssFileText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Button cssFileButton = new Button(group, SWT.NONE);
		cssFileButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(shell);
				String path = dialog.open();
				if (path != null) {
					cssFileText.setText(path);
				}
			}
		});
		cssFileButton.setText("･･･");
		new Label(group, SWT.NONE);

		Label defaultWikiLabel = new Label(group, SWT.NONE);
		defaultWikiLabel.setAlignment(SWT.RIGHT);
		defaultWikiLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		defaultWikiLabel.setText("初期表示Wiki");

		defaultWikiText = new Text(group, SWT.BORDER);
		defaultWikiText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(shell, SWT.NONE);

		Label spacerLabel = new Label(shell, SWT.NONE);
		spacerLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));

		Button okButton = new Button(shell, SWT.NONE);
		okButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				PureWikiUtil.clearDirectory(new File(config.getOutDirPath()));
				List<String> srcDirPathList = config.getSrcDirPathList();
				srcDirPathList.clear();
				srcDirPathList.add(srcDirText.getText());
				config.setOutDirPath(outDirText.getText());
				config.setCssFile(cssFileText.getText());
				config.setDefaultWiki(defaultWikiText.getText());
				config.store();
				result = SWT.OK;
				shell.close();
			}
		});
		GridData gd_okButton = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1);
		gd_okButton.widthHint = 90;
		okButton.setLayoutData(gd_okButton);
		okButton.setText("OK");

		Button cancelButton = new Button(shell, SWT.NONE);
		cancelButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				result = SWT.CANCEL;
				shell.close();
			}
		});
		GridData gd_cancelButton = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1);
		gd_cancelButton.widthHint = 90;
		cancelButton.setLayoutData(gd_cancelButton);
		cancelButton.setText("キャンセル");

		srcDirText.setText(config.getSrcDirPath());
		outDirText.setText(config.getOutDirPath());
		cssFileText.setText(config.getCssFile());
		defaultWikiText.setText(config.getDefaultWiki());
	}
}
