package jp.gr.java_conf.wutse.purewiki.syntax.line;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;

public class TitleSyntax implements LineSyntax {
	@Override
	public boolean condition(PureWikiContext context) {
		String line = context.getLine();
		if (line.startsWith("! ") || line.startsWith("!! ") || line.startsWith("!!! ")) {
			return true;
		}
		return false;
	}

	@Override
	public String begin(PureWikiContext context) {
		return "";
	}

	@Override
	public String line(PureWikiContext context) {
		if (!condition(context)) {
			return context.getLine() + "<BR>\n";
		}
		String line = context.getLine();
		if (line.startsWith("! ")) {
			line = line.substring("! ".length());
			line = "<h2>" + line + "</h2>";
		}
		else if (line.startsWith("!! ")) {
			line = line.substring("!! ".length());
			line = "<h3>" + line + "</h3>";
		}
		else if (line.startsWith("!!! ")) {
			line = line.substring("!!! ".length());
			line = "<h4>" + line + "</h4>";
		}
		return line;
	}

	@Override
	public String end(PureWikiContext context) {
		return "";
	}
}
