/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ oXg ]
 */

#include "common.h"
#include "target.h"
#include "log.h"
#include "debug.h"
#include "list.h"

/*
 * oXg
 * 
 */
void list_init(list_node NEAR *node)
{
	ASSERT(node != NULL);

	/* oƂڑĂȂ */
	node->prev = NULL;
	node->next = NULL;
}

/*
 * oXg
 * ̃m[h擾
 */
list_node NEAR *list_get_next(list_node NEAR *node)
{
	ASSERT(node != NULL);

	return node->next;
}

/*
 * oXg
 * Xg֒ǉ
 * nodȅI[֑}
 */
void list_add(list_node NEAR *node, list_node NEAR *add)
{
	ASSERT(node != NULL);
	ASSERT(add != NULL);

	/* nodȅI[ֈړ */
	while (node->next != NULL)
	{
		node = node->next;
	}

	/* add->nextNULL */
	add->next = NULL;

	/* nodeadd𑊌݂ɐڑ */
	node->next = add;
	add->prev = node;
}

/*
 * oXg
 * Xg֑}
 * node֑̒}
 */
void list_insert(list_node NEAR *node, list_node NEAR *add)
{
	ASSERT(node != NULL);
	ASSERT(add != NULL);

	/* node->nextύX */
	add->next = node->next;
	if (add->next != NULL)
	{
		add->next->prev = add;
	}

	/* nodeadd𑊌݂ɐڑ */
	node->next = add;
	add->prev = node;
}

/*
 * oXg
 * XgO
 * node̒Ԃ
 */
list_node NEAR *list_remove(list_node NEAR *node)
{
	list_node NEAR *next;

	ASSERT(node != NULL);

	/* node->nextۑ */
	next = node->next;

	/* node菜悤ɐڑ */
	if (node->prev != NULL)
	{
		node->prev->next = node->next;
	}
	if (node->next != NULL)
	{
		node->next->prev = node->prev;
	}

	/* nextԂ */
	return next;
}
