/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ O ]
 */

#ifndef LOG_H
#define LOG_H

/*
 * Oo̓}N
 */
#ifdef NOLOG
#define LOG(msg)
										/* Ȃ */
#define LOG_U1(msg, val_8bit)
										/* Ȃ */
#define LOG_U2(msg, val_16bit)
										/* Ȃ */
#define LOG_U4(msg, val_32bit)
										/* Ȃ */
#else
#define LOG(msg)					log_msg(msg)
										/* o */
#define LOG_U1(msg, val_8bit)		log_uint8(msg, val_8bit)
										/* +uint8o */
#define LOG_U2(msg, val_16bit)		log_uint16(msg, val_16bit)
										/* +uint16o */
#define LOG_U4(msg, val_32bit)		log_uint32(msg, val_32bit)
										/* +uint32o */
#endif

/*
 * O
 * 
 */
void log_init(void);

/*
 * O
 * o
 * far̈ɔzu
 */
void log_msg(const char FAR *msg);

/*
 * O
 * +uint8o
 * far̈ɔzu
 */
void log_uint8(const char FAR *msg, uint8 value);

/*
 * O
 * +uint16o
 * far̈ɔzu
 */
void log_uint16(const char FAR *msg, uint16 value);

/*
 * O
 * +uint32o
 * far̈ɔzu
 */
void log_uint32(const char FAR *msg, uint32 value);

/*
 * O
 * ffo
 * far̈ɔzu
 */
void log_assert(const char FAR *expr, const char FAR *file, int line);

/*
 * O
 * UART荞
 * 荞݋֎~ԂŌĂ΂
 */
void log_isr(uint8 uart_ch);

#endif /* LOG_H */
