//! @file		pf_clock.c
//! @brief		プラットフォーム(Clock)実装ファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#include "pf_types.h"
#include "nrf52833.h"
#include "nrf52833_bitfields.h"
#include "pf_clock.h"

//! @brief		Clock初期化
//! @details	X1(32MHz)から生成される64MHzクリスタルオシレータ(HFXO)を有効にする
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_clock_init(void)
{
	// X1クロック(32MHz)有効イベントをクリア
	NRF_CLOCK->EVENTS_HFCLKSTARTED =
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated
					<< CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos;

	// X1クロック(32MHz)を有効にし、高精度クロック64MHzで動作開始
	NRF_CLOCK->TASKS_HFCLKSTART =
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger << CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos;

	// 高精度クロック(64MHz)が有効になるまで待つ
	while ((CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated
					<< CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos)
					== NRF_CLOCK->EVENTS_HFCLKSTARTED)
	{
		// 何もしない
	}
}
