//! @file ai.h
//! @brief AIcontrolNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef AI_H
#define AI_H

#define AI_TURNRAD (float)M_PI/36		//!< AI̐i]\́j
#define AI_WEAPON_ARMRAD (float)M_PI/5*-1						//!< 폊L̘r̕\px
#define AI_SEARCH_RX (float)M_PI/18*11	//!< G𔭌鉡px
#define AI_SEARCH_RY (float)M_PI/18*6	//!< G𔭌cpx

#define AI_ARRIVALDIST_PATH 5.0f		//!< pXɓBƔ肷鋗
#define AI_ARRIVALDIST_TRACKING 18.0f	//!< ǔΏۂɓBƔ肷鋗
#define AI_ARRIVALDIST_WALKTRACKING 24.0f	//!< ǔΏۂցi炸Ɂjċ߂Â
#define AI_CHECKJUMP_HEIGHT 0.3f		//!< OɃubN肷鍂
#define AI_CHECKJUMP_DIST 2.0f			//!< OɃubN肷鋗
#define AI_CHECKJUMP2_DIST 10.0f			//!< OɃubN肷鋗iDIȑj
#define AI_CHECKBULLET 20.0f			//!< e߂ʂƔ肷鋗

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif
#include "main.h"

//! @brief AIsNX
//! @details pXɂړAɂGւ̔FUA̎g@ȂǂAI̐Sʂs܂B
class AIcontrol
{
	class ObjectManager *ObjMgr;		//!< ObjectManagerNX̃|C^
	class BlockDataInterface *blocks;	//!< ubNf[^ǗNXւ̃|C^
	class PointDataInterface *Points;	//!< |Cgf[^ǗNXւ̃|C^
	class ParameterInfo *Param;		//!< ݒlǗNXւ̃|C^
	class Collision *CollD;				//!< 蔻ǗNXւ̃|C^
	class SoundManager *GameSound;		//!< Q[ʉĐNXւ̃|C^

	int AIlevel;		//!< AIx
	int battlemode;		//!< 퓬[h
	int movemode;		//!< ړ[h
	bool hold;		//!< ړpXǂ܂Ȃ
	float posx;		//!< XW
	float posy;		//!< YW
	float posz;		//!< ZW
	float rx;		//!< X]px
	float ry;		//!< Y]px
	int target_pointid;		//!< pXn@^[Qbg̃f[^ԍ
	float target_posx;		//!< pXn@^[QbgXW
	float target_posz;		//!< pXn@^[QbgZW
	float target_rx;		//!< pXn@^[Qbg̐px
	float total_move;		//!< vړ
	int waitcnt;		//!< ԑ҂JEg
	int movejumpcnt;	//!< WvJEg
	int gotocnt;		//!< ړJEg
	int moveturn_mode;	//!< ړ]̃tO
	int cautioncnt;		//!< xJEg
	int actioncnt;		//!< UJEg
	bool longattack;	//!< ߋEtO
	AIParameter *LevelParam;	//!< AI̐\l

	int random(int num);
	int SearchHumanPos(signed char in_p4, float *out_x, float *out_z);
	bool CheckTargetPos();
	bool SearchTarget(bool next);
	void MoveTarget();
	void MoveTarget2();
	void MoveRandom();
	void TurnSeen();
	bool StopSeen();
	bool MoveJump();
	void Action();
	bool ActionCancel();
	int HaveWeapon();
	void CancelMoveTurn();
	void ControlMoveTurn();
	int ControlWeapon();
	int ThrowGrenade();
	void ArmAngle();
	int SearchEnemy();
	int SearchShortEnemy();
	bool CheckLookEnemy(int id, float search_rx, float search_ry, float maxDist, float *out_minDist);
	bool CheckLookEnemy(class human* thuman, float search_rx, float search_ry, float maxDist, float *out_minDist);
	bool CheckCorpse(int id);
	void MovePath();
	bool ActionMain();
	bool CautionMain();
	bool NormalMain();

	class human *ctrlhuman;		//!< giΏہjhumanNX
	class human *enemyhuman;	//!< UΏۂhumanNX

public:
	AIcontrol(class ObjectManager *in_ObjMgr = NULL, class human *in_ctrlhuman = NULL, class BlockDataInterface *in_blocks = NULL, class PointDataInterface *in_Points = NULL, class ParameterInfo *in_Param = NULL, class Collision *in_CollD = NULL, class SoundManager *in_GameSound = NULL);
	~AIcontrol();
	void SetClass(class ObjectManager *in_ObjMgr, class human *in_ctrlhuman, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound);
	void Init();
	void SetHoldWait(float px, float pz, float rx);
	void SetHoldTracking(int id);
	void Process();
};

//! AI̐䃂[h\萔
enum AImode {
	AI_DEAD = 0,	//!< SĂl
	AI_ACTION,		//!< 퓬̐l
	AI_CAUTION,		//!< x̐l
	AI_NORMAL,		//!< ʏ̃[h

	AI_WALK,		//!< ړpXɂĕĂl
	AI_RUN,			//!< ړpXɂđĂl
	AI_WAIT,		//!< pXɂđҋ@Ăl
	AI_STOP,		//!< pXɂĎԑ҂Ăl
	AI_TRACKING,	//!< ̐lǔ
	AI_GRENADE,		//!< ֒e𓊂
	AI_RUN2,		//!< DIȑ
	AI_RANDOM,		//!< _pX
	AI_NULL			//!< pXȂ
};

//! AȊ샂[h\萔
enum AIcontrolFlag {
	AI_CTRL_MOVEFORWARD = 0x0001,
	AI_CTRL_MOVEBACKWARD = 0x0002,
	AI_CTRL_MOVELEFT = 0x0004,
	AI_CTRL_MOVERIGHT = 0x0008,
	AI_CTRL_MOVEWALK = 0x0010,
	AI_CTRL_TURNUP = 0x0100,
	AI_CTRL_TURNDOWN = 0x0200,
	AI_CTRL_TURNLEFT = 0x0400,
	AI_CTRL_TURNRIGHT = 0x0800
};

#endif