//! @file resource.h
//! @brief ResourceManagerNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef RESOURCE_H
#define RESOURCE_H

#define TOTAL_UPMODE 6			//!< 㔼g̍vf
#define TOTAL_ARMMODE 3			//!< r̍vf
#define TOTAL_WALKMODE 8		//!< ij̍vf
#define TOTAL_RUNMODE 12			//!< ij̍vf

#define MAX_LOADHUMANTEXTURE 10		//!< l̃eNX`ǂݍލő喇

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 2		//!< Select include file.
#endif
#include "main.h"

//! @brief \[XǗNX
//! @details Ɏgp郂feNX`уTEhǗ܂B@iꕔj
class ResourceManager
{
	class ParameterInfo *ParamInfo;			//!< ǗݒlNX
	class D3DGraphics *d3dg;					//!< Ǘ`NX
	class SoundControl *SoundCtrl;				//!< ǗTEhNX

	int human_upmodel[TOTAL_UPMODE];			//!< 㔼g̃f
	int human_armmodel[TOTAL_ARMMODE];			//!< r̃f
	int human_legmodel;							//!< iÎ~ԁj̃f
	int human_walkmodel[TOTAL_WALKMODE];		//!< ij̃f
	int human_runmodel[TOTAL_RUNMODE];			//!< ij̃f
	int human_texture_Param[MAX_LOADHUMANTEXTURE];		//!< l̃eNX`̑Ήԍ
	int human_texture_d3dg[MAX_LOADHUMANTEXTURE];		//!< l̃eNX`̔Fԍ
	int weapon_model[TOTAL_PARAMETERINFO_WEAPON];		//!< ̃fFԍ
	int weapon_texture[TOTAL_PARAMETERINFO_WEAPON];	//!< ̃eNX`Fԍ
	int weapon_sound[TOTAL_PARAMETERINFO_WEAPON];		//!< ̃TEhFԍ
	int weapon_reloadsound;								//!< ̃[hTEhFԍ
	int smallobject_model[TOTAL_PARAMETERINFO_SMALLOBJECT+1];		//!< ̃fFԍ
	int smallobject_texture[TOTAL_PARAMETERINFO_SMALLOBJECT+1];		//!< ̃eNX`Fԍ
	int smallobject_sound[TOTAL_PARAMETERINFO_SMALLOBJECT+1];		//!< ̃TEhFԍ
	int bullet_model[TOTAL_PARAMETERINFO_BULLET];		//!< ẽf
	int bullet_texture[TOTAL_PARAMETERINFO_BULLET];		//!< ẽeNX`

	int scopetexture;		//!< XR[ṽeNX`
	int skymodel;			//!< wĩf
	int skytexture;			//!< wĩeNX`
	int bullet_hitsoundA;		//!< ẽqbgTEhiAj
	int bullet_hitsoundB;		//!< ẽqbgTEhiBj
	int bullet_humanhitsound;	//!< ẽqbgTEhilj
	int bullet_passingsound;	//!< e̒ʉ߃TEh
	int grenade_bang;		//!< ֒e̔
	int grenade_cco;		//!< ֒ẽoEh
	int effecttexture_blood;	//!< GtFNgpEeNX`
	int effecttexture_mflash;	//!< GtFNgpEtbVeNX`
	int effecttexture_smoke;	//!< GtFNgpEeNX`
	int effecttexture_yakkyou;	//!< GtFNgpE䰃eNX`

public:
	ResourceManager();
	~ResourceManager();
	void SetParameterInfo(ParameterInfo *_ParamInfo);
	void SetD3DGraphics(D3DGraphics *_d3dg);
	void SetSoundControl(SoundControl *_SoundCtrl);
	void DestroyResource();

	int LoadHumanModel();
	void GetHumanModel(int out_upmodel[], int out_armmodel[], int *legmodel, int out_walkmodel[], int out_runmodel[]);
	void CleanupHumanModel();
	int AddHumanTexture(int id);
	int GetHumanTexture(int id);
	void CleanupHumanTexture();
	int LoadWeaponModelTexture();
	int GetWeaponModelTexture(int id, int *model, int *texture);
	int GetBugWeaponModelTexture(int id, int *model, int *texture);
	void CleanupWeaponModelTexture();
	int LoadWeaponSound();
	int GetWeaponSound(int id);
	int LoadSmallObjectModelTexture();
	int GetSmallObjectModelTexture(int id, int *model, int *texture);
	void CleanupSmallObjectModelTexture();
	int LoadSmallObjectSound();
	int GetSmallObjectSound(int id);
	int LoadAddSmallObject(char *modelpath, char *texturepath, char *soundpath);
	int LoadBulletModelTexture();
	int GetBulletModelTexture(int id, int *model, int *texture);
	void CleanupBulletModelTexture();

	int LoadScopeTexture();
	int GetScopeTexture();
	void CleanupScopeTexture();
	int LoadSkyModelTexture(int id);
	void GetSkyModelTexture(int *model, int *texture);
	void CleanupSkyModelTexture();
	int LoadBulletSound();
	void GetBulletSound(int *hitsoundA, int *hitsoundB, int *humanhitsound, int *passingsound, int *grenadebang, int *grenadecco);
	int LoadEffectTexture();
	int GetEffectBloodTexture();
	int GetEffectMflashTexture();
	int GetEffectSmokeTexture();
	int GetEffectYakkyouTexture();
	void CleanupEffectTexture();
};

#endif