//! @file d3dgraphics-debugfont.cpp
//! @brief D3DGraphicsgptHgf[^i[

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

// tHgf[^ "OSASK version 4.7" ̕؂肵Ă܂B
// tHg̍쐬҂ ،hY  liKiyotoj łB
// t@Cinewstyle.txtj KL-01CZX ŌJĂ܂B
//  http://osask.net/
//  https://osdn.jp/projects/osask/scm/svn/tree/211/OSAKA/tags/4.7.0/
//
//
// [1]@tHǧ` 8x16 2iŕ\iu0F.vu1F*vŕ\j
//  ........
//  ...*....
//  ..***...
//  .**.**..
//  **...**.
//  **...**.
//  **...**.
//  *******.
//  **...**.
//  **...**.
//  **...**.
//  **...**.
//  ........
//  ........
//  ........
//  ........
//  
//  [2]@es16iɕϊ
//  ........@@00000000@@0x00
//  ...*....@@00010000@@0x10
//  ..***...@@00111000@@0x38
//  .**.**..@@01101100@@0x6C
//  @@`````
//  ........@@00000000@@0x00
//  
//  [3]@}NŔzϐɊi[
//  SetDebugFontData( DebugFontData[xxx], 0x00, 0x10, 0x38, 0x6C,@`````@0x00 );
//
// OpenXOPSNɂ͋tWJsADirectXOpenGLŃeNX`tHg𐶐܂B
//
//
// OpenXOPSɂāA{tHgf[^ҏWEςO͂܂B

#include "d3dgraphics.h"

#ifdef ENABLE_DEBUGCONSOLE

//! @brief fobNptHĝ߂̃}N
#define SetDebugFontData( out16, in0, in1, in2, in3, in4, in5, in6, in7, in8, in9, inA, inB, inC, inD, inE, inF ){\
	/*! buffer */\
	unsigned char *Data = out16;\
	Data[0] = in0; Data[1] = in1; Data[2] = in2; Data[3] = in3;\
	Data[4] = in4; Data[5] = in5; Data[6] = in6; Data[7] = in7;\
	Data[8] = in8; Data[9] = in9; Data[10] = inA; Data[11] = inB;\
	Data[12] = inC; Data[13] = inD; Data[14] = inE; Data[15] = inF;\
}

//! @brief fobNptHgip[^̐ݒj
//! @attention ̊֐ĂяoȂƁAfobNptHĝ@\܂B
void D3DGraphics::InitDebugFontData()
{
	SetDebugFontData( DebugFontData[0], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x20 (' ')
	SetDebugFontData( DebugFontData[1], 0x00, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 );	//char 0x21 ('!')
	SetDebugFontData( DebugFontData[2], 0x6C, 0x6C, 0x6C, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x22 ('"')
	SetDebugFontData( DebugFontData[3], 0x00, 0x6C, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00 );	//char 0x23 ('#')
	SetDebugFontData( DebugFontData[4], 0x00, 0x10, 0x10, 0x7C, 0xC2, 0xC0, 0xC0, 0x7C, 0x06, 0x06, 0x86, 0x7C, 0x10, 0x10, 0x00, 0x00 );	//char 0x24 ('$')
	SetDebugFontData( DebugFontData[5], 0x00, 0x00, 0x00, 0x00, 0x61, 0x63, 0x06, 0x0C, 0x18, 0x30, 0x63, 0xC3, 0x00, 0x00, 0x00, 0x00 );	//char 0x25 ('%')
	SetDebugFontData( DebugFontData[6], 0x00, 0x30, 0x58, 0x50, 0x20, 0x50, 0x56, 0xCE, 0xCE, 0xCC, 0x4C, 0x7A, 0x00, 0x00, 0x00, 0x00 );	//char 0x26 ('&')
	SetDebugFontData( DebugFontData[7], 0x0C, 0x1C, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x27 (''')
	SetDebugFontData( DebugFontData[8], 0x00, 0x06, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00 );	//char 0x28 ('(')
	SetDebugFontData( DebugFontData[9], 0x00, 0xC0, 0x60, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00 );	//char 0x29 (')')
	SetDebugFontData( DebugFontData[10], 0x00, 0x00, 0x00, 0x00, 0x44, 0x6C, 0x28, 0xFE, 0x28, 0x6C, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x2A ('*')
	SetDebugFontData( DebugFontData[11], 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x2B ('+')
	SetDebugFontData( DebugFontData[12], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x10, 0x00, 0x00 );	//char 0x2C (',')
	SetDebugFontData( DebugFontData[13], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x2D ('-')
	SetDebugFontData( DebugFontData[14], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00 );	//char 0x2E ('.')
	SetDebugFontData( DebugFontData[15], 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00 );	//char 0x2F ('/')
	SetDebugFontData( DebugFontData[16], 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x30 ('0')
	SetDebugFontData( DebugFontData[17], 0x00, 0x18, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x31 ('1')
	SetDebugFontData( DebugFontData[18], 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x06, 0x0E, 0x0C, 0x18, 0x30, 0x62, 0xFE, 0x00, 0x00, 0x00, 0x00 );	//char 0x32 ('2')
	SetDebugFontData( DebugFontData[19], 0x00, 0x7C, 0x86, 0x06, 0x06, 0x06, 0x1C, 0x06, 0x06, 0x06, 0x86, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x33 ('3')
	SetDebugFontData( DebugFontData[20], 0x00, 0x04, 0x0C, 0x1C, 0x2C, 0x4C, 0x8C, 0x8C, 0xFE, 0x0C, 0x0C, 0x1E, 0x00, 0x00, 0x00, 0x00 );	//char 0x34 ('4')
	SetDebugFontData( DebugFontData[21], 0x00, 0x7E, 0x60, 0x60, 0x60, 0x60, 0x7C, 0x06, 0x06, 0x06, 0x46, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x35 ('5')
	SetDebugFontData( DebugFontData[22], 0x00, 0x3C, 0x62, 0x60, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x36 ('6')
	SetDebugFontData( DebugFontData[23], 0x00, 0x7E, 0x46, 0x46, 0x06, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 );	//char 0x37 ('7')
	SetDebugFontData( DebugFontData[24], 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x38 ('8')
	SetDebugFontData( DebugFontData[25], 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x06, 0x46, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x39 ('9')
	SetDebugFontData( DebugFontData[26], 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00 );	//char 0x3A (':')
	SetDebugFontData( DebugFontData[27], 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x04, 0x08, 0x00, 0x00 );	//char 0x3B (';')
	SetDebugFontData( DebugFontData[28], 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00 );	//char 0x3C ('<')
	SetDebugFontData( DebugFontData[29], 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x3D ('=')
	SetDebugFontData( DebugFontData[30], 0x00, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00 );	//char 0x3E ('>')
	SetDebugFontData( DebugFontData[31], 0x00, 0x00, 0x3C, 0x66, 0x66, 0x06, 0x0C, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 );	//char 0x3F ('?')
	SetDebugFontData( DebugFontData[32], 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xDE, 0xDE, 0xDE, 0xDC, 0xC0, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x40 ('@')
	SetDebugFontData( DebugFontData[33], 0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x41 ('A')
	SetDebugFontData( DebugFontData[34], 0x00, 0xFC, 0x66, 0x66, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00 );	//char 0x42 ('B')
	SetDebugFontData( DebugFontData[35], 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC2, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x43 ('C')
	SetDebugFontData( DebugFontData[36], 0x00, 0xF8, 0x6C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00, 0x00, 0x00, 0x00 );	//char 0x44 ('D')
	SetDebugFontData( DebugFontData[37], 0x00, 0xFC, 0x66, 0x60, 0x60, 0x64, 0x7C, 0x64, 0x60, 0x60, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00 );	//char 0x45 ('E')
	SetDebugFontData( DebugFontData[38], 0x00, 0xFC, 0x66, 0x60, 0x60, 0x64, 0x7C, 0x64, 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 );	//char 0x46 ('F')
	SetDebugFontData( DebugFontData[39], 0x00, 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0xC0, 0xDE, 0xC6, 0xC6, 0x66, 0x3E, 0x00, 0x00, 0x00, 0x00 );	//char 0x47 ('G')
	SetDebugFontData( DebugFontData[40], 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x48 ('H')
	SetDebugFontData( DebugFontData[41], 0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x49 ('I')
	SetDebugFontData( DebugFontData[42], 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00, 0x00, 0x00, 0x00 );	//char 0x4A ('J')
	SetDebugFontData( DebugFontData[43], 0x00, 0xC6, 0xC6, 0xCC, 0xD8, 0xF0, 0xE0, 0xF0, 0xD8, 0xCC, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x4B ('K')
	SetDebugFontData( DebugFontData[44], 0x00, 0xF0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00 );	//char 0x4C ('L')
	SetDebugFontData( DebugFontData[45], 0x00, 0xC6, 0xC6, 0xEE, 0xEE, 0xFE, 0xFE, 0xFE, 0xD6, 0xD6, 0xD6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x4D ('M')
	SetDebugFontData( DebugFontData[46], 0x00, 0xC6, 0xE6, 0xE6, 0xF6, 0xF6, 0xDE, 0xDE, 0xCE, 0xC6, 0xC6, 0xC2, 0x00, 0x00, 0x00, 0x00 );	//char 0x4E ('N')
	SetDebugFontData( DebugFontData[47], 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x4F ('O')
	SetDebugFontData( DebugFontData[48], 0x00, 0xFC, 0x66, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 );	//char 0x50 ('P')
	SetDebugFontData( DebugFontData[49], 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xD6, 0x7C, 0x10, 0x18, 0x0C, 0x00 );	//char 0x51 ('Q')
	SetDebugFontData( DebugFontData[50], 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xFC, 0xF8, 0xCC, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x52 ('R')
	SetDebugFontData( DebugFontData[51], 0x00, 0x7C, 0xC6, 0xC0, 0xC0, 0xC0, 0x7C, 0x06, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x53 ('S')
	SetDebugFontData( DebugFontData[52], 0x00, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x54 ('T')
	SetDebugFontData( DebugFontData[53], 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x55 ('U')
	SetDebugFontData( DebugFontData[54], 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x6C, 0x6C, 0x6C, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 );	//char 0x56 ('V')
	SetDebugFontData( DebugFontData[55], 0x00, 0xC6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0x7C, 0x7C, 0x6C, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00 );	//char 0x57 ('W')
	SetDebugFontData( DebugFontData[56], 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x6C, 0x38, 0x6C, 0x6C, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x58 ('X')
	SetDebugFontData( DebugFontData[57], 0x00, 0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x59 ('Y')
	SetDebugFontData( DebugFontData[58], 0x00, 0xFE, 0x06, 0x0E, 0x1C, 0x18, 0x38, 0x30, 0x70, 0xE0, 0xC0, 0xFE, 0x00, 0x00, 0x00, 0x00 );	//char 0x5A ('Z')
	SetDebugFontData( DebugFontData[59], 0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x00, 0x00, 0x00, 0x00 );	//char 0x5B ('[')
	SetDebugFontData( DebugFontData[60], 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00 );	//char 0x5C ('\')
	SetDebugFontData( DebugFontData[61], 0x00, 0xF0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xF0, 0x00, 0x00, 0x00, 0x00 );	//char 0x5D (']')
	SetDebugFontData( DebugFontData[62], 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x5E ('^')
	SetDebugFontData( DebugFontData[63], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00 );	//char 0x5F ('_')
	SetDebugFontData( DebugFontData[64], 0x60, 0x70, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x60 ('`')
	SetDebugFontData( DebugFontData[65], 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0xCC, 0xCC, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x61 ('a')
	SetDebugFontData( DebugFontData[66], 0x00, 0xE0, 0x60, 0x60, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x66, 0xFC, 0x00, 0x00, 0x00, 0x00 );	//char 0x62 ('b')
	SetDebugFontData( DebugFontData[67], 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00 );	//char 0x63 ('c')
	SetDebugFontData( DebugFontData[68], 0x00, 0x1C, 0x0C, 0x0C, 0x0C, 0x7C, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x64 ('d')
	SetDebugFontData( DebugFontData[69], 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x65 ('e')
	SetDebugFontData( DebugFontData[70], 0x00, 0x00, 0x1C, 0x36, 0x30, 0xFC, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00 );	//char 0x66 ('f')
	SetDebugFontData( DebugFontData[71], 0x00, 0x00, 0x00, 0x00, 0x06, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x0C, 0xC6, 0xC6, 0x7C, 0x00 );	//char 0x67 ('g')
	SetDebugFontData( DebugFontData[72], 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x68 ('h')
	SetDebugFontData( DebugFontData[73], 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x69 ('i')
	SetDebugFontData( DebugFontData[74], 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCC, 0x78, 0x00 );	//char 0x6A ('j')
	SetDebugFontData( DebugFontData[75], 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC6, 0xCC, 0xD8, 0xF0, 0xD8, 0xCC, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x6B ('k')
	SetDebugFontData( DebugFontData[76], 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00 );	//char 0x6C ('l')
	SetDebugFontData( DebugFontData[77], 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x7E, 0x56, 0x56, 0x56, 0x56, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x6D ('m')
	SetDebugFontData( DebugFontData[78], 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0xE6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x6E ('n')
	SetDebugFontData( DebugFontData[79], 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x6F ('o')
	SetDebugFontData( DebugFontData[80], 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00 );	//char 0x70 ('p')
	SetDebugFontData( DebugFontData[81], 0x00, 0x00, 0x00, 0x00, 0x00, 0x7A, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x1E, 0x00 );	//char 0x71 ('q')
	SetDebugFontData( DebugFontData[82], 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xEC, 0xCC, 0xCC, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00 );	//char 0x72 ('r')
	SetDebugFontData( DebugFontData[83], 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, 0x7C, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00, 0x00 );	//char 0x73 ('s')
	SetDebugFontData( DebugFontData[84], 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00 );	//char 0x74 ('t')
	SetDebugFontData( DebugFontData[85], 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xCE, 0x76, 0x00, 0x00, 0x00, 0x00 );	//char 0x75 ('u')
	SetDebugFontData( DebugFontData[86], 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00 );	//char 0x76 ('v')
	SetDebugFontData( DebugFontData[87], 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xD6, 0xD6, 0x7C, 0x6C, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00 );	//char 0x77 ('w')
	SetDebugFontData( DebugFontData[88], 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0xC6, 0x00, 0x00, 0x00, 0x00 );	//char 0x78 ('x')
	SetDebugFontData( DebugFontData[89], 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x7C, 0x3C, 0x18, 0x18, 0x30, 0x60, 0x00 );	//char 0x79 ('y')
	SetDebugFontData( DebugFontData[90], 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0xFE, 0x00, 0x00, 0x00, 0x00 );	//char 0x7A ('z')
	SetDebugFontData( DebugFontData[91], 0x00, 0x0E, 0x18, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00, 0x00 );	//char 0x7B ('{')
	SetDebugFontData( DebugFontData[92], 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00 );	//char 0x7C ('|')
	SetDebugFontData( DebugFontData[93], 0x00, 0xE0, 0x30, 0x30, 0x30, 0x30, 0x1C, 0x30, 0x30, 0x30, 0x30, 0xE0, 0x00, 0x00, 0x00, 0x00 );	//char 0x7D ('}')
	SetDebugFontData( DebugFontData[94], 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x7E ('~')
	SetDebugFontData( DebugFontData[95], 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 );	//char 0x7F ('')
}

#endif