//! @file event.cpp
//! @brief EventControlNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2017, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "event.h"

//! @brief RXgN^
EventControl::EventControl(PointDataInterface *in_Point, ObjectManager *in_ObjMgr)
{
	Point = in_Point;
	ObjMgr = in_ObjMgr;
	nextp4 = 0;
	waitcnt = 0;
}

//! @brief fBXgN^
EventControl::~EventControl()
{}

//! @brief ΏۃNXݒ
//! @param in_Point |Cgf[^ǗNX
//! @param in_ObjMgr IuWFNgǗNX
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void EventControl::SetClass(PointDataInterface *in_Point, ObjectManager *in_ObjMgr)
{
	Point = in_Point;
	ObjMgr = in_ObjMgr;
}

//! @brief Zbg
//! @param EntryP4 CxgJnFԍ@i-100A-110A-120@Ȃǁj
void EventControl::Reset(signed char EntryP4)
{
	nextp4 = EntryP4;
	waitcnt = 0;
}

//! @brief ɏFԍ
//! @return P4FFԍ
signed char EventControl::GetNextP4()
{
	return nextp4;
}

//! @brief Ώۂ̐lP[XĂ邩`FbN
//! @param in_human ׂΏۂhumañ|C^
//! @return ĂFtrue@ĂȂFfalse
bool EventControl::CheckHaveCase(human *in_human)
{
	int selectweapon;
	weapon *out_weapon[TOTAL_HAVEWEAPON];
	int weaponid;

	//L镐IuWFNgSĎ擾
	in_human->GetWeapon(&selectweapon, out_weapon);

	//SĒׂ
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		if( out_weapon[i] != NULL ){

			//̎ޔԍ擾AꂪP[XǂB
			out_weapon[i]->GetParamData(&weaponid, NULL, NULL);
			if( weaponid == ID_WEAPON_CASE ){
				return true;
			}
		}
	}
	return false;
}

//! @brief s
//! @param endcnt IJEg̃|C^
//! @param complete ~bVtÕ|C^
//! @param MessageID CxgbZ[Wԍ̃|C^
//! @param SetMessageID CxgbZ[WǂݏotO
//! @return sXebv
//! @attention nꂽɕύXȂꍇAnꂽ̃f[^͑삳܂B
//! @attention SetMessageID ́AbZ[WCxgsꂽꍇ true ɂȂ܂B<b>O񂩂ύXꂽƂ͌܂B</b>
int EventControl::Execution(int *endcnt, bool *complete, int *MessageID, bool *SetMessageID)
{
	pointdata data, pathdata;
	int cnt = 0;
	human* thuman;
	smallobject* tsmallobject;
	float hx, hy, hz;
	float x, y, z;
	int pid;

	for(int i=0; i<TOTAL_EVENTFRAMESTEP; i++){
		cnt = i;

		//̃|CgT
		if( Point->SearchPointdata(&data, 0x08, 0, 0, 0, nextp4, 0) == 0 ){ return cnt; }

		//ȔԍȂ珈Ȃ
		if( (data.p1 < 10)||(19 < data.p1) ){ return cnt; }

		switch(data.p1){
			case 10:	//CB
				*endcnt += 1;
				*complete = true;
				return cnt;

			case 11:	//Cs
				*endcnt += 1;
				*complete = false;
				return cnt;

			case 12:	//S҂
				thuman = ObjMgr->SearchHuman(data.p2);
				if( thuman == NULL ){ return cnt; }
				if( thuman->GetDeadFlag() == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 13:	//҂
				thuman = ObjMgr->SearchHuman(data.p2);
				if( thuman == NULL ){ return cnt; }
				thuman->GetPosData(&hx, &hy, &hz, NULL);
				x = hx - data.x;
				y = hy - data.y;
				z = hz - data.z;
				if( sqrt(x*x + y*y+ + z*z) > DISTANCE_CHECKPOINT ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 14:	//ɕύX
				if( Point->SearchPointdata(&pid, 0x08, 0, 0, 0, data.p2, 0) > 0 ){
					//ΏۂAIpXȂ΁AIɃp[^
					Point->Getdata(&pathdata, pid);
					if( (pathdata.p1 == 3)||(pathdata.p1 == 8) ){
						pathdata.p2 = 0;
					}
					Point->SetParam(pid, pathdata.p1, pathdata.p2, pathdata.p3, pathdata.p4);
				}
				nextp4 = data.p3;
				break;

			case 15:	//j҂
				tsmallobject = ObjMgr->SearchSmallobject(data.p2);
				if( tsmallobject != NULL ){
					if( tsmallobject->GetEnableFlag() == true ){ return cnt; }
				}
				nextp4 = data.p3;
				break;

			case 16:	//P[X҂
				thuman = ObjMgr->SearchHuman(data.p2);
				if( thuman == NULL ){ return cnt; }
				thuman->GetPosData(&hx, &hy, &hz, NULL);
				x = hx - data.x;
				y = hy - data.y;
				z = hz - data.z;
				if( sqrt(x*x + y*y+ + z*z) > DISTANCE_CHECKPOINT ){ return cnt; }
				if( CheckHaveCase(thuman) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 17:	//ԑ҂
				if( (int)GAMEFPS * ((unsigned char)data.p2) > waitcnt ){
					waitcnt += 1;
					return cnt;
				}
				waitcnt = 0;
				nextp4 = data.p3;
				break;

			case 18:	//bZ[W
				if( (0 <= data.p2)&&(data.p2 < MAX_POINTMESSAGES) ){
					*MessageID = data.p2;
				}
				nextp4 = data.p3;
				*SetMessageID = true;
				break;
				//return cnt;

			case 19:	//`[ύX
				thuman = ObjMgr->SearchHuman(data.p2);
				if( thuman == NULL ){ return cnt; }
				thuman->SetTeamID(0);
				nextp4 = data.p3;
				break;

			//VȃCxg|CgǉꍇAɏB
			//@ ޔԍ̋ 
			//@ {switchOɂAi͈̓`FbNj邱ƁB
		}
	}
	return cnt;
}