//! @file scene.cpp
//! @brief eʂǗNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2018, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "scene.h"

//! @brief RXgN^
scene::scene()
{
	WindowCtrl = NULL; 
	d3dg = NULL;
	inputCtrl = NULL;
	framecnt = 0;
}

//! @brief fBXgN^
scene::~scene()
{}

//! @brief NXݒ
void scene::SetClass(StateMachine *in_GameState, WindowControl *in_WindowCtrl, D3DGraphics *in_d3dg, InputControl *in_inputCtrl)
{
	GameState = in_GameState;
	WindowCtrl = in_WindowCtrl; 
	d3dg = in_d3dg;
	inputCtrl = in_inputCtrl;
}

//! @brief V[쐬
int scene::Create()
{
	inputCtrl->MoveMouseCenter();
	framecnt = 0;

	GameState->NextState();
	return 0;
}

//! @brief V[`
int scene::Recovery()
{
	return 0;
}

//! @brief V[͏
void scene::Input()
{
	inputCtrl->GetInputState(false);

	if( inputCtrl->CheckKeyDown(GetEscKeycode()) ){
		GameState->PushBackSpaceKey();
	}
	else if( inputCtrl->CheckMouseButtonUpL() ){
		GameState->PushMouseButton();
	}
}

//! @brief V[vZ
void scene::Process()
{
	framecnt += 1;
}

//! @brief V[`揈
//! @return Ffalse@sFtrue
//! @attention sꍇAD3DGraphicsNXResetD3D()֐ĂяoĂB
bool scene::RenderMain()
{
	if( d3dg->StartRender() ){ return true; }

	d3dg->Draw2DBox(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, d3dg->GetColorCode(0.0f,0.0f,0.0f,1.0f));
	d3dg->Draw2DTextureFontText(10, 10, "hello world !", d3dg->GetColorCode(1.0f,1.0f,1.0f,1.0f), 20, 32);

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGHT, GameConfig.GetBrightness());

	return d3dg->EndRender();
}

//! @brief V[
void scene::Destroy()
{
	GameState->NextState();
}

//! @brief t[JEgɃAt@lExݒi1j
//! @param tframecnt ΏۂƂJEgl
//! @param MaxAlpha őAt@l
//! @param timingsec ԊuEb
//! @param offsetsec ItZbgEb
//! @param reversal ]tOifalseFtB[hC@trueFtB[hAEgj
//! @return At@l
float scene::GetEffectAlpha(unsigned int tframecnt, float MaxAlpha, float timingsec, float offsetsec, bool reversal)
{
	float alpha;
	unsigned int frametiming;
	unsigned int frameoffset;

	frametiming = (unsigned int)(timingsec*GAMEFPS);
	frameoffset = (unsigned int)(offsetsec*GAMEFPS);
	alpha = MaxAlpha/frametiming * (tframecnt - frameoffset);

	if( alpha < 0.0f ){ alpha = 0.0f; }
	if( alpha > 1.0f ){ alpha = 1.0f; }

	if( reversal == true ){
		return 1.0f - alpha;
	}
	return alpha;
}

//! @brief t[JEgɃAt@lExݒi[vj
//! @param tframecnt ΏۂƂJEgl
//! @param MaxAlpha őAt@l
//! @param timingsec ԊuEb
//! @param reversal ]tOifalseFtB[hC@trueFtB[hAEgj
//! @return At@l
float scene::GetEffectAlphaLoop(unsigned int tframecnt, float MaxAlpha, float timingsec, bool reversal)
{
	float alpha;
	unsigned int frametiming;

	frametiming = (unsigned int)(timingsec*GAMEFPS);
	alpha = MaxAlpha/frametiming * (tframecnt%frametiming);

	if( reversal == true ){
		return 1.0f - alpha;
	}
	return alpha;
}

//! @brief RXgN^
D2Dscene::D2Dscene()
{}

//! @brief fBXgN^
D2Dscene::~D2Dscene()
{}

//! @brief 2DV[
int D2Dscene::Create()
{
	gametitle = d3dg->LoadTexture("data\\title.dds", false, false);
	GameState->NextState();
	if( gametitle == -1 ){ return 1; }
	return 0;
}

//! @brief V[`
int D2Dscene::Recovery()
{
	//
	gametitle = d3dg->LoadTexture("data\\title.dds", false, false);
	if( gametitle == -1 ){ return 1; }
	return 0;
}

//! @brief 2DV[`揈i2Dj
void D2Dscene::Render2D()
{
	d3dg->Draw2DTextureFontText(10, 10, "hello world !", d3dg->GetColorCode(1.0f,1.0f,1.0f,1.0f), 20, 32);
}

//! @brief 2DV[`揈iCj
//! @return Ffalse@sFtrue
//! @attention sꍇAD3DGraphicsNXResetD3D()֐ĂяoĂB
bool D2Dscene::RenderMain()
{
	if( d3dg->StartRender() ){ return true; }

	d3dg->Draw2DTexture(0, 0, gametitle, SCREEN_WIDTH, SCREEN_HEIGHT, 0.4f);
	d3dg->Draw2DBox(11, 11, SCREEN_WIDTH - 10, SCREEN_HEIGHT - 10, d3dg->GetColorCode(0.0f,0.0f,0.0f,0.75f));

	Render2D();

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGHT, GameConfig.GetBrightness());

	return d3dg->EndRender();
}

//! @brief 2DV[
void D2Dscene::Destroy()
{
	d3dg->CleanupTexture(gametitle);
	GameState->NextState();
}


//! @brief RXgN^
D3Dscene::D3Dscene()
{}

//! @brief fBXgN^
D3Dscene::~D3Dscene()
{}

//! @brief 3DV[NXݒ
void D3Dscene::SetClass(StateMachine *in_GameState, WindowControl *in_WindowCtrl, D3DGraphics *in_d3dg, InputControl *in_inputCtrl, SoundManager *in_GameSound)
{
	GameState = in_GameState;
	WindowCtrl = in_WindowCtrl; 
	d3dg = in_d3dg;
	inputCtrl = in_inputCtrl;
	GameSound = in_GameSound;
}

//! @brief 3DV[vZ
void D3Dscene::Process()
{}

//! @brief 3DV[TEhĐ
void D3Dscene::Sound()
{
	//TEhĐ
	GameSound->PlayWorldSound(camera_x, camera_y, camera_z, camera_rx, 1);
}

//! @brief 3DV[`揈i3Dj
void D3Dscene::Render3D()
{}

//! @brief 3DV[`揈i2Dj
void D3Dscene::Render2D()
{}

//! @brief 3DV[`揈iCj
//! @return Ffalse@sFtrue
//! @attention sꍇAD3DGraphicsNXResetD3D()֐ĂяoĂB
bool D3Dscene::RenderMain()
{
	if( d3dg->StartRender() ){ return true; }

	Render3D();
	Render2D();

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGHT, GameConfig.GetBrightness());

	return d3dg->EndRender();
}