//! @file datafile.cpp
//! @brief f[^ǗNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2019, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "datafile.h"

//! @brief RXgN^
DataInterface::DataInterface()
{
	datas = 0;
}

//! @brief fBXgN^
DataInterface::~DataInterface()
{}

//! @brief f[^t@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int DataInterface::LoadFiledata(char *fname)
{
	//gp΍
	UNREFERENCED_PARAMETER(fname);

	return 0;
}

//! @brief vf[^̎擾
//! @return vf[^
int DataInterface::GetTotaldatas()
{
	return datas;
}

//! @brief f[^擾
//! @param out_data 󂯎|C^
//! @param id Fԍ
//! @return F0@sF0ȊO
int DataInterface::Getdata(void *out_data, int id)
{
	//gp΍
	UNREFERENCED_PARAMETER(out_data);
	UNREFERENCED_PARAMETER(id);

	return 0;
}

//! @brief RXgN^
BlockDataInterface::BlockDataInterface()
{
	//blockdata\̏
	data = new blockdata[MAX_BLOCKS];

	//eNX`ݒ菉
	for(int i=0; i<TOTAL_BLOCKTEXTURE; i++){
		strcpy(texture[i], "");
	}
}

//! @brief fBXgN^
BlockDataInterface::~BlockDataInterface()
{
	//blockdata\̉
	if( data != NULL ){ delete [] data; }

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	//OutputLog.WriteLog(LOG_CLEANUP, "BD1", "");
#endif
}

//! @brief ubNf[^t@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int BlockDataInterface::LoadFiledata(char *fname)
{
	FILE *fp;
	unsigned char bdata_header[2];
	float bdata_main[80];
	char bdata_mainb[30];

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "BD1", fname);
#endif

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	//t@Cǂݍ
	fp = fopen(fname, "rb");
	if( fp == NULL ){
		return 1;
	}

	//eNX`擾
	for(int i=0; i<TOTAL_BLOCKTEXTURE; i++){
		fread(texture[i], 1, 31, fp );
	}

	//f[^擾
	fread( bdata_header, 1, 2, fp );
	datas = (int)bdata_header[1]*256 + bdata_header[0];
	if( datas > MAX_BLOCKS ){
		datas = MAX_BLOCKS;
	}

	//ubNf[^擾
	for(int i=0; i<datas; i++){
		//ubN̂𒸓_Ɩʏ擾
		fread( bdata_main, 4, 24+48, fp );
		fread( bdata_mainb, 1, 28, fp );

		//f[^ԍݒ
		data[i].id = i;

		//ubN̒_ɐݒ
		for(int j=0; j<8; j++){
			data[i].x[j] = bdata_main[j];
			data[i].y[j] = bdata_main[j+8];
			data[i].z[j] = bdata_main[j+16];
		}

		//ubN̖ʏݒ
		for(int j=0; j<6; j++){
			data[i].material[j].textureID = (int)bdata_mainb[j*4];
			data[i].material[j].u[0] = bdata_main[j*4+24];
			data[i].material[j].v[0] = bdata_main[j*4+48];
			data[i].material[j].u[1] = bdata_main[j*4+25];
			data[i].material[j].v[1] = bdata_main[j*4+49];
			data[i].material[j].u[2] = bdata_main[j*4+26];
			data[i].material[j].v[2] = bdata_main[j*4+50];
			data[i].material[j].u[3] = bdata_main[j*4+27];
			data[i].material[j].v[3] = bdata_main[j*4+51];
		}
	}

	//t@Cnh
	fclose( fp );

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	return 0;
}

//! @brief ubNf[^̖@EeZo
//! @param darkflag ubNÂ
//! @attention LoadBlockdata()֐œǂ݂񂾌AxsB
void BlockDataInterface::CalculationBlockdata(bool darkflag)
{
	int vID[4];
	int uvID[4];
	float g;
	float xs, ys, zs;
	float g1;
	float xs1, ys1, zs1;
	float g2;
	float xs2, ys2, zs2;
	float lx, ly, lz;
	float rx, ry, rz, a;

	//̊pxݒ
	lx = cos(LIGHT_RX);
	ly = sin(LIGHT_RY);
	lz = sin(LIGHT_RX);

	//eubN̖ʏ񕪏
	for(int i=0; i<datas; i++){
		for(int j=0; j<6; j++){

			//ubN_f[^̊֘At擾
			blockdataface(j, vID, uvID);

			//S_
			data[i].material[j].center_x = 0.0f;
			data[i].material[j].center_y = 0.0f;
			data[i].material[j].center_z = 0.0f;

			//4_̒S_Zo
			for(int k=0; k<4; k++){
				data[i].material[j].center_x += data[i].x[ vID[k] ];
				data[i].material[j].center_y += data[i].y[ vID[k] ];
				data[i].material[j].center_z += data[i].z[ vID[k] ];
			}
			data[i].material[j].center_x /= 4;
			data[i].material[j].center_y /= 4;
			data[i].material[j].center_z /= 4;

			//ʂ̖@ixNgjƁA̒߂
			xs1 = ((data[i].y[ vID[3] ] - data[i].y[ vID[2] ]) * (data[i].z[ vID[0] ] - data[i].z[ vID[2] ])) - ((data[i].y[ vID[0] ] - data[i].y[ vID[2] ]) * (data[i].z[ vID[3] ] - data[i].z[ vID[2] ]));
			ys1 = ((data[i].z[ vID[3] ] - data[i].z[ vID[2] ]) * (data[i].x[ vID[0] ] - data[i].x[ vID[2] ])) - ((data[i].z[ vID[0] ] - data[i].z[ vID[2] ]) * (data[i].x[ vID[3] ] - data[i].x[ vID[2] ]));
			zs1 = ((data[i].x[ vID[3] ] - data[i].x[ vID[2] ]) * (data[i].y[ vID[0] ] - data[i].y[ vID[2] ])) - ((data[i].x[ vID[0] ] - data[i].x[ vID[2] ]) * (data[i].y[ vID[3] ] - data[i].y[ vID[2] ]));
			g1 = (float)sqrt(xs1 * xs1 + ys1 * ys1 + zs1 * zs1);

			//̎Op`łvZ
			xs2 = ((data[i].y[ vID[1] ] - data[i].y[ vID[0] ]) * (data[i].z[ vID[2] ] - data[i].z[ vID[0] ])) - ((data[i].y[ vID[2] ] - data[i].y[ vID[0] ]) * (data[i].z[ vID[1] ] - data[i].z[ vID[0] ]));
			ys2 = ((data[i].z[ vID[1] ] - data[i].z[ vID[0] ]) * (data[i].x[ vID[2] ] - data[i].x[ vID[0] ])) - ((data[i].z[ vID[2] ] - data[i].z[ vID[0] ]) * (data[i].x[ vID[1] ] - data[i].x[ vID[0] ]));
			zs2 = ((data[i].x[ vID[1] ] - data[i].x[ vID[0] ]) * (data[i].y[ vID[2] ] - data[i].y[ vID[0] ])) - ((data[i].x[ vID[2] ] - data[i].x[ vID[0] ]) * (data[i].y[ vID[1] ] - data[i].y[ vID[0] ]));
			g2 = (float)sqrt(xs2 * xs2 + ys2 * ys2 + zs2 * zs2);

			//vZʂ̗p
			if( g1 > g2 ){
				xs = xs1;
				ys = ys1;
				zs = zs1;
				g = g1;
			}
			else{
				xs = xs2;
				ys = ys2;
				zs = zs2;
				g = g2;
			}

			//@ixNgj𐳋K
			data[i].material[j].vx = xs / g;
			data[i].material[j].vy = ys / g;
			data[i].material[j].vz = zs / g;

			//ʂ̖邳߂
			rx = data[i].material[j].vx + lx;
			ry = data[i].material[j].vy + ly;
			rz = data[i].material[j].vz + lz;
			//a = sqrt(fabs(rx*rx + ry*ry + rz*rz)) / 2.0f;
			//data[i].material[j].shadow = a/2 + 0.5f;
			a = sqrt(rx*rx + ry*ry + rz*rz) / 3.0f;
			data[i].material[j].shadow = a/2;
			if( darkflag == false ){
				data[i].material[j].shadow += 0.5f;
			}
			else{
				data[i].material[j].shadow += 0.3f;
			}
		}
	}
}

//! @brief ubNf[^ɐݒ肳ꂽeNX`̃t@C擾
//! @param fname t@C󂯎镶^|C^
//! @param id eNX`ԍ
//! @return F0@sF0ȊO
int BlockDataInterface::GetTexture(char *fname, int id)
{
	if( data == NULL ){ return 1; }
	if( (id < 0)||((TOTAL_BLOCKTEXTURE -1) < id) ){ return 2; }

	//|C^ɃeNX`Rs[
	strcpy(fname, texture[id]);

	return 0;
}

//! @brief ubNf[^擾
//! @param out_data 󂯎blockdata^|C^
//! @param id Fԍ
//! @return F0@sF0ȊO
int BlockDataInterface::Getdata(blockdata *out_data, int id)
{
	if( data == NULL ){ return 1; }
	if( (id < 0)||((datas -1) < id) ){ return 2; }

	//ubNf[^擾
	memcpy(out_data, &(data[id]), sizeof(blockdata));

	return 0;
}

//! @brief ubN_f[^̊֘At擾
//
//	    3 E----E2
//	     /|    /|
//	    / |   / |
//	0 E----E1 |
//	  |7 E-| --E6
//	  |  /  |  /
//	  | /   | /
//	4 E----E5
//
//	C-----D
//	|     |
//	|     |
//	B-----A
//
//	[0](ABCD) =  (1032)
//	[1]		=  (6745)
//	O[2]		=  (5401)
//	E[3]		=  (6512)
//	[4]		=  (7623)
//	[5]		=  (4730)
bool blockdataface(int faceID, int* vID, int* uvID)
{
	if( faceID == 0 ){
		if( vID != NULL ){
			vID[0] = 1;		vID[1] = 0;		vID[2] = 3;		vID[3] = 2;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	if( faceID == 1 ){
		if( vID != NULL ){
			vID[0] = 6;		vID[1] = 7;		vID[2] = 4;		vID[3] = 5;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	if( faceID == 2 ){
		if( vID != NULL ){
			vID[0] = 5;		vID[1] = 4;		vID[2] = 0;		vID[3] = 1;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	if( faceID == 3 ){
		if( vID != NULL ){
			vID[0] = 6;		vID[1] = 5;		vID[2] = 1;		vID[3] = 2;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	if( faceID == 4 ){
		if( vID != NULL ){
			vID[0] = 7;		vID[1] = 6;		vID[2] = 2;		vID[3] = 3;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	if( faceID == 5 ){
		if( vID != NULL ){
			vID[0] = 4;		vID[1] = 7;		vID[2] = 3;		vID[3] = 0;
		}
		if( uvID != NULL ){
			uvID[0] = 2;	uvID[1] = 3;	uvID[2] = 0;	uvID[3] = 1;
		}
		return true;
	}
	return false;
}

//! @brief RXgN^
PointDataInterface::PointDataInterface()
{
	//pointdata\̏
	data = new pointdata[MAX_POINTS];

	//CxgbZ[W
	for(int i=0; i<MAX_POINTMESSAGES; i++){
		text[i] = new char[MAX_POINTMESSAGEBYTE];
		text[i][0] = '\0';
	}
}

//! @brief fBXgN^
PointDataInterface::~PointDataInterface()
{
	//pointdata\̉
	if( data != NULL ){ delete [] data; }

	//CxgbZ[W
	for(int i=0; i<MAX_POINTMESSAGES; i++){
		if( text[i] != NULL ){ delete [] text[i]; }
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	//OutputLog.WriteLog(LOG_CLEANUP, "PD1", "");
#endif
}

//! @brief |Cgf[^t@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int PointDataInterface::LoadFiledata(char *fname)
{
	FILE *fp;
	unsigned char pdata_header[2];
	float pdata_mainf[MAX_POINTS][4];
	char pdata_mainc[MAX_POINTS][4];
	char fname2[MAX_PATH];

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "PD1", fname);
#endif

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	//t@Cǂݍ
	fp = fopen( fname, "rb" );
	if( fp == NULL ){
		return 1;
	}

	//f[^擾
	fread( pdata_header, 1, 2, fp );
	datas = (int)pdata_header[1]*256 + pdata_header[0];
	if( datas > MAX_POINTS ){
		datas = MAX_POINTS;
	}

	//|Cgf[^
	for(int i=0; i<datas; i++){
		//f[^ԍݒ
		data[i].id = i;

		//Wf[^擾
		fread( pdata_mainf[i], 4, 4, fp );
		data[i].x = pdata_mainf[i][0];
		data[i].y = pdata_mainf[i][1];
		data[i].z = pdata_mainf[i][2];
		data[i].r = pdata_mainf[i][3];

		//p[^擾
		fread( pdata_mainc[i], 1, 4, fp );
		data[i].p1 = pdata_mainc[i][0];
		data[i].p2 = pdata_mainc[i][1];
		data[i].p3 = pdata_mainc[i][2];
		data[i].p4 = pdata_mainc[i][3];
	}

	//t@C|C^
	fclose( fp );

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	//ut@C.msgv𐶐
	strcpy(fname2, fname);
	//PathRemoveExtension(fname2);
	for(int i=strlen(fname2)-1; i>0; i--){
		if( fname2[i] == '.' ){
			fname2[i] = '\0';
			break;
		}
	}
	strcat(fname2, ".msg");

	LoadMSGFiledata(fname2);

	return 0;
}

//! @brief bZ[Wf[^t@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int PointDataInterface::LoadMSGFiledata(char *fname)
{
	FILE *fp;

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "MSG", fname);
#endif

	//t@Cǂݍ
	fp = fopen( fname, "r" );
	if( fp != NULL ){
		//bZ[Wf[^擾
		for(int i=0; i<MAX_POINTMESSAGES; i++){
			if( fgets(text[i], MAX_POINTMESSAGEBYTE, fp) == NULL ){ break; }

			//'\r''\n'ɒu
			for(int j=0; j<MAX_POINTMESSAGEBYTE; j++){
				if( text[i][j] == '\r' ){ text[i][j] = '\n'; }
			}
		}

		//t@C|C^J
		fclose( fp );

#ifdef ENABLE_DEBUGLOG
		//Oɏo
		OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
		return 0;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_ERROR, "", "");
#endif
	return 1;
}

//! @brief |Cgf[^擾
//! @param out_data 󂯎pointdata^|C^
//! @param id Fԍ
//! @return F0@sF0ȊO
int PointDataInterface::Getdata(pointdata *out_data, int id)
{
	if( data == NULL ){ return 1; }
	if( (id < 0)||((datas -1) < id) ){ return 2; }

	//f[^|C^ɃRs[
	memcpy(out_data, &(data[id]), sizeof(pointdata));

	return 0;
}

//! @brief |Cg̃p[^[
//! @param id Fԍ
//! @param p1 1p[^
//! @param p2 2p[^
//! @param p3 3p[^
//! @param p4 4p[^
//! @return F0@sF0ȊO
//! @warning AIgppXip1:3 or p1:8jȊOւ̎gṕAۏ؂Ă炸܂B
int PointDataInterface::SetParam(int id, signed char p1, signed char p2, signed char p3, signed char p4)
{
	if( data == NULL ){ return 1; }
	if( (id < 0)||((datas -1) < id) ){ return 2; }

	//p[^㏑
	data[id].p1 = p1;
	data[id].p2 = p2;
	data[id].p3 = p3;
	data[id].p4 = p4;

	return 0;
}

//! @brief bZ[Wi1sj擾
//! @param str 󂯎|C^
//! @param id Fԍ
//! @return F0@sF1
int PointDataInterface::GetMessageText(char *str, int id)
{
	if( (id < 0)||((MAX_POINTMESSAGES -1) < id) ){ return 1; }

	//|C^ɃbZ[WRs[
	strcpy(str, text[id]);
	return 0;
}

//! @brief |Cgf[^
//! @param id ŏɊYf[^ԍ󂯎|C^@iNULL j
//! @param pmask p[^̃}XN
//! @param p1 1p[^
//! @param p2 2p[^
//! @param p3 3p[^
//! @param p4 4p[^
//! @param offset Jnf[^
//! @return Y|Cg
//! @note p[^̃}XŃAp1`p4̌Ώۂw肵܂B
//! @note 1`4rbgڂ܂łgpAp1F1rbgځAp2F2rbgځAp3F3rbgځAp4F4rbgځ@ꂼӖ܂B
//! @note ̑ΏۃrbgF1@ΏۊÕrbgF0@ɐݒ肵ĂB@ȂA7`5rbgڂ͖܂B
//! @code
//! //16iŋLq̏ꍇ\
//! 0x02	// p2݂̂Ώۂɂ
//! 0x05	// p1p3Ώۂɂ
//! 0xF1	// p1݂̂Ώۂɂ@i7`5rbgڂ͖j
//! @endcode
int PointDataInterface::SearchPointdata(int* id, unsigned char pmask, signed char p1, signed char p2, signed char p3, signed char p4, int offset)
{
	int cnt = 0;

	if( offset < 0 ){ offset = 0; }
	if( offset >= datas ){ offset = datas; }

	//ItZbglf[^
	for(int i=offset; i<datas; i++){

		if( ((pmask&0x01) == 0)||(p1 == data[i].p1) ){		//}XNŎw肳ĂȂAp1v
			if( ((pmask&0x02) == 0)||(p2 == data[i].p2) ){		//}XNŎw肳ĂȂAp2v
				if( ((pmask&0x04) == 0)||(p3 == data[i].p3) ){		//}XNŎw肳ĂȂAp3v
					if( ((pmask&0x08) == 0)||(p4 == data[i].p4) ){		//}XNŎw肳ĂȂAp4v

						if( (cnt == 0)&&(id != NULL) ){			//ŏɊYAidNULLłȂB
							*id = i;
						}

						//Y+1
						cnt += 1;

					}
				}
			}
		}

	}

	//YԂ
	return cnt;
}

//! @brief |Cgf[^
//! @param out_data ŏɊYf[^󂯎pointdata^|C^@iNULL j
//! @param pmask p[^̃}XN
//! @param p1 1p[^
//! @param p2 2p[^
//! @param p3 3p[^
//! @param p4 4p[^
//! @param offset Jnf[^
//! @return Y|Cg
//! @attention ̊֐̏ڂ́AI[o[[h֐B
int PointDataInterface::SearchPointdata(pointdata *out_data, unsigned char pmask, signed char p1, signed char p2, signed char p3, signed char p4, int offset)
{
	int id, total;

	//Ń|Cg
	total = SearchPointdata(&id, pmask, p1, p2, p3, p4, offset);
	
	//Y΃f[^擾
	if( total > 0 ){
		Getdata(out_data, id);
	}

	//YԂ
	return total;
}

//! @brief RXgN^
MIFInterface::MIFInterface()
{
	datas = 0;

	mif = false;
	strcpy(mission_name, "");
	strcpy(mission_fullname, "");
	strcpy(blockfile_path, "");
	strcpy(pointfile_path, "");
	skynumber = 0;
	strcpy(picturefileA_path, "!");
	strcpy(picturefileB_path, "!");
	strcpy(addsmallobject_path, "");
	strcpy(briefingtext, "");
	collision = false;
	screen = false;
	AddSmallObjectData = new addsmallobject[MAX_ADDSMALLOBJECT];
}

//! @brief fBXgN^
MIFInterface::~MIFInterface()
{
	if( AddSmallObjectData != NULL ){ delete [] AddSmallObjectData; }
}

//! @brief f[^t@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int MIFInterface::LoadFiledata(char *fname)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "MIF", fname);
#endif

	mif = true;

	//gq.txtȂ
	//if( strcmp(PathFindExtension(fname), ".txt") == 0 ){
	//	//MIFtO𖳌
	//	mif = false;
	//}
	for(int i=strlen(fname)-1; i>0; i--){
		if( fname[i] == '.' ){
			if( strcmp(&(fname[i]), ".txt") == 0 ){
				//MIFtO𖳌
				mif = false;
			}
			break;
		}
	}

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	if( mif == false ){
		if( LoadDefaultTextFiledata(fname) != 0 ){
			//briefing data open failed
			return 1;
		}
	}
	else{
		if( LoadMissionInfoFiledata(fname) != 0 ){
			//briefing data open failed
			return 1;
		}
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif


	//ǉl
	for(int i=0; i<MAX_ADDSMALLOBJECT; i++){
		strcpy(AddSmallObjectData[i].modelpath, "");
		strcpy(AddSmallObjectData[i].texturepath, "");
		AddSmallObjectData[i].decide = 0;
		AddSmallObjectData[i].hp = 0;
		strcpy(AddSmallObjectData[i].soundpath, "");
		AddSmallObjectData[i].jump = 0;
	}

	//̒ǉt@Cw肳Ă
	if( (strcmp(addsmallobject_path, "") != 0)&&(strcmp(addsmallobject_path, "!") != 0) ){
		LoadAddSmallObjectFiledata(addsmallobject_path);
	}
#ifdef ENABLE_DEBUGLOG
	else{
		//Oɏo
		OutputLog.WriteLog(LOG_CHECK, "iǉj", "t@CȂ");
	}
#endif

	return 0;
}

//! @brief ~bVt@Ci.txtjǂ݂
//! @param fname t@C
//! @return F0@sF1
int MIFInterface::LoadDefaultTextFiledata(char *fname)
{
	FILE *fp;
	char str[64];

	//t@CJ
	fp = fopen( fname, "r" );
	if( fp != NULL ){
		//摜A擾
		fgets(str, 64, fp);
		DeleteLinefeed(str);
		if( strcmp(str, "!") == 0 ){
			strcpy(picturefileA_path, "!");
		}
		else{
			//udata\\briefing\\@`@.bmpv𐶐
			strcpy(picturefileA_path, "data\\briefing\\");
			strcat(picturefileA_path, str);
			strcat(picturefileA_path, ".bmp");
		}

		//摜B擾
		fgets(str, 64, fp);
		DeleteLinefeed(str);
		if( strcmp(str, "!") == 0 ){
			strcpy(picturefileB_path, "!");
		}
		else{
			//udata\\briefing\\@`@.bmpv𐶐
			strcpy(picturefileB_path, "data\\briefing\\");
			strcat(picturefileB_path, str);
			strcat(picturefileB_path, ".bmp");
		}

		//wi̔ԍ
		fgets(str, 16, fp);
		DeleteLinefeed(str);
		skynumber = atoi(str);

		//u[tBOeLXg擾
		strcpy(briefingtext, "");
		for(int i=0; i<17; i++ ){
			if( fgets(str, 50, fp) == NULL ){ break; }
			strcat(briefingtext, str);
			datas += 1;
		}

		//擾łȂl̏
		strcpy(mission_name, "");
		strcpy(mission_fullname, "");
		strcpy(blockfile_path, "");
		strcpy(pointfile_path, "");
		strcpy(addsmallobject_path, "");
		collision = false;
		screen = false;

		return 0;
	}

	return 1;
}

//! @brief ~bVt@Ci.mifjǂ݂
//! @param fname t@C
//! @return F0@sF1
int MIFInterface::LoadMissionInfoFiledata(char *fname)
{
	FILE *fp;
	char str[64];

	//t@CJ
	fp = fopen( fname, "r" );
	if( fp != NULL ){
		//~bVʖ
		fgets(mission_name, 24, fp);
		DeleteLinefeed(mission_name);

		//~bV
		fgets(mission_fullname, 64, fp);
		DeleteLinefeed(mission_fullname);

		//ubNf[^t@C
		fgets(blockfile_path, _MAX_PATH, fp);
		DeleteLinefeed(blockfile_path);

		//|Cgf[^t@C
		fgets(pointfile_path, _MAX_PATH, fp);
		DeleteLinefeed(pointfile_path);

		//wi̔ԍ
		fgets(str, 16, fp);
		DeleteLinefeed(str);
		skynumber = atoi(str);

		//蔻Eʐݒ̎擾
		fgets(str, 16, fp);
		DeleteLinefeed(str);
		if( strcmp(str, "1") == 0 ){
			collision = true;
			screen = false;
		}
		else if( strcmp(str, "2") == 0 ){
			collision = false;
			screen = true;
		}
		else if( strcmp(str, "3") == 0 ){
			collision = true;
			screen = true;
		}
		else{	// == "0"
			collision = false;
			screen = false;
		}

		//ǉt@C擾
		fgets(addsmallobject_path, _MAX_PATH, fp);
		DeleteLinefeed(addsmallobject_path);

		//摜A擾
		fgets(picturefileA_path, _MAX_PATH, fp);
		DeleteLinefeed(picturefileA_path);

		//摜B擾
		fgets(picturefileB_path, _MAX_PATH, fp);
		DeleteLinefeed(picturefileB_path);

		//u[tBOeLXg擾
		strcpy(briefingtext, "");
		for(int i=0; i<17; i++ ){
			if( fgets(str, 50, fp) == NULL ){ break; }
			strcat(briefingtext, str);
			datas += 1;
		}
		return 0;
	}

	return 1;
}

//! @brief ǉt@Cǂ݂
//! @param fname t@C
//! @return F0@sF1
int MIFInterface::LoadAddSmallObjectFiledata(char *fname)
{
	FILE *fp;
	char str1[_MAX_PATH];
	char str2[_MAX_PATH];
	char str3[32];
	char str4[32];
	char str5[_MAX_PATH];
	char str6[32];

	char str[64];

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "iǉj", fname);
#endif

	//t@CJ
	fp = fopen( fname, "r" );
	if( fp != NULL ){
		for(int i=0; i<MAX_ADDSMALLOBJECT; i++){
			//6s擾
			//6sׂĎ擾łȂΎs
			if( fgets(str1, _MAX_PATH, fp) == NULL ){ break; }
			if( fgets(str2, _MAX_PATH, fp) == NULL ){ break; }
			if( fgets(str3, 16, fp) == NULL ){ break; }
			if( fgets(str4, 16, fp) == NULL ){ break; }
			if( fgets(str5, _MAX_PATH, fp) == NULL ){ break; }
			if( fgets(str6, 16, fp) == NULL ){ break; }


			//ff[^pX
			DeleteLinefeed(str1);
			strcpy(AddSmallObjectData[i].modelpath, str1);

			//eNX`pX
			DeleteLinefeed(str2);
			strcpy(AddSmallObjectData[i].texturepath, str2);

			//蔻̑傫
			DeleteLinefeed(str3);
			AddSmallObjectData[i].decide = atoi(str3);
#ifdef ENABLE_ADDOBJ_PARAM8BIT
			AddSmallObjectData[i].decide = AddSmallObjectData[i].decide & 0x0000007F;
#endif

			//ϋv
			DeleteLinefeed(str4);
			AddSmallObjectData[i].hp = atoi(str4);
#ifdef ENABLE_ADDOBJ_PARAM8BIT
			AddSmallObjectData[i].hp = AddSmallObjectData[i].hp & 0x0000007F;
#endif

			//TEhf[^pX
			DeleteLinefeed(str5);
			strcpy(AddSmallObjectData[i].soundpath, str5);

			//ы
			DeleteLinefeed(str6);
			AddSmallObjectData[i].jump = atoi(str6);
#ifdef ENABLE_ADDOBJ_PARAM8BIT
			AddSmallObjectData[i].jump = AddSmallObjectData[i].jump & 0x000000FF;
#endif

			//̒ǉ̑OɂA_~[ 1sǂݏo
			if( i+1 < MAX_ADDSMALLOBJECT ){
				if( fgets(str, 32, fp) == NULL ){ break; }
			}
		}

		//t@CnhJ
		fclose( fp );

#ifdef ENABLE_DEBUGLOG
		//Oɏo
		OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
		return 0;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_ERROR, "", "");
#endif
	return 1;
}

//! @brief ǂݍ񂾃f[^t@Č`擾
//! @return W`Ffalse@MIF`Ftrue
//! @attention t@C𐳏ɓǂݍ񂾌ɎsĂB
bool MIFInterface::GetFiletype()
{
	return mif;
}

//! @brief ~bVʖ擾
//! @return ʖ̃|C^iőF24j
char* MIFInterface::GetMissionName()
{
	return mission_name;
}

//! @brief ~bV̂擾
//! @return ̂̃|C^iőF64j
char* MIFInterface::GetMissionFullname()
{
	return mission_fullname;
}

//! @brief ubNf[^ƃ|Cgf[^̃pX擾
//! @param *blockfile ubNf[^󂯎|C^
//! @param *pointfile |Cgf[^󂯎|C^
void MIFInterface::GetDatafilePath(char *blockfile, char *pointfile)
{
	strcpy(blockfile, blockfile_path);
	strcpy(pointfile, pointfile_path);
}

//! @brief wi擾
//! @return ̔ԍi0`5j
//! @attention ԍ 0 ́uwiȂvӖ܂B
int MIFInterface::GetSkynumber()
{
	return skynumber;
}

//! @brief u[tBO摜t@C̃pX擾
//! @param *picturefileA 摜t@CÃpX󂯎|C^
//! @param *picturefileB 摜t@CB̃pX󂯎|C^
//! @attention ݒ肳ĂȂꍇ́u!vԂ܂B
//! @attention 摜1gpȂꍇA摜t@CB́u!vԂ܂B
void MIFInterface::GetPicturefilePath(char *picturefileA, char *picturefileB)
{
	strcpy(picturefileA, picturefileA_path);
	strcpy(picturefileB, picturefileB_path);
}

//! @brief u[tBÓi{j擾
//! @return ͂̃|C^iőF816j
//! @attention sR[h܂߂āAő17sxɕԂ܂B
//! @attention s GetTotaldatas() Ŏ擾ł܂B
char* MIFInterface::GetBriefingText()
{
	return briefingtext;
}

//! @brief ǉ̓蔻tO擾
//! @return LFtrue@Ffalse
bool MIFInterface::GetCollisionFlag()
{
	return collision;
}

//! @brief ʂÂtO擾
//! @return LFtrue@Ffalse
bool MIFInterface::GetScreenFlag()
{
	return screen;
}

//! @brief ǉt@CpX擾
//! @return ǉt@CpX̃|C^iőF_MAX_PATHj
//! @attention {֐͒ʏKv܂Bff[^pXȂǂ̃t@C̏́Å֐Ŏ擾ł܂B
char* MIFInterface::GetAddSmallobjectFile()
{
	return addsmallobject_path;
}

//! @brief ǉ̃ff[^pX擾
//! @param id f[^ԍiʏ 0 Œj
//! @return ff[^pX̃|C^iőF_MAX_PATHj
char* MIFInterface::GetAddSmallobjectModelPath(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return NULL; }
	return AddSmallObjectData[id].modelpath;
}

//! @brief ǉ̃eNX`pX擾
//! @param id f[^ԍiʏ 0 Œj
//! @return eNX`pX̃|C^iőF_MAX_PATHj
char* MIFInterface::GetAddSmallobjectTexturePath(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return NULL; }
	return AddSmallObjectData[id].texturepath;
}

//! @brief ǉ̓蔻̑傫擾
//! @param id f[^ԍiʏ 0 Œj
//! @return 蔻̑傫
int MIFInterface::GetAddSmallobjectDecide(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return 0; }
	return AddSmallObjectData[id].decide;
}

//! @brief ǉ̑ϋv͂擾
//! @param id f[^ԍiʏ 0 Œj
//! @return ϋv
int MIFInterface::GetAddSmallobjectHP(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return 0; }
	return AddSmallObjectData[id].hp;
}

//! @brief ǉ̃TEhf[^pX擾
//! @param id f[^ԍiʏ 0 Œj
//! @return TEhf[^pX̃|C^iőF_MAX_PATHj
char* MIFInterface::GetAddSmallobjectSoundPath(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return NULL; }
	return AddSmallObjectData[id].soundpath;
}

//! @brief ǉ̔ы擾
//! @param id f[^ԍiʏ 0 Œj
//! @return ы
int MIFInterface::GetAddSmallobjectJump(int id)
{
	if( (id < 0)||(MAX_ADDSMALLOBJECT-1 < id) ){ return 0; }
	return AddSmallObjectData[id].jump;
}

//! @brief RXgN^
AddonList::AddonList()
{
	datas = 0;

	for(int i=0; i<MAX_ADDONLIST; i++){
		strcpy(filename[i], "");
		strcpy(mission_name[i], "");
	}
}

//! @brief fBXgN^
AddonList::~AddonList()
{}

//! @brief .mift@C擾
void AddonList::GetMIFlist(char *dir)
{
	char SearchDIR[_MAX_PATH];
	HANDLE hFind;
	WIN32_FIND_DATA FindFileData;

	//.mif̌𐶐
	strcpy(SearchDIR, dir);
	strcat(SearchDIR, "\\*.mif");

	//
	hFind = FindFirstFile(SearchDIR, &FindFileData);
	if( hFind != INVALID_HANDLE_VALUE ){
		strcpy(filename[0], FindFileData.cFileName);
		datas += 1;

		while( FindNextFile(hFind, &FindFileData) == TRUE ){
			strcpy(filename[datas], FindFileData.cFileName);
			datas += 1;
		}
	}
	FindClose(hFind);
}

//! @brief ~bV擾
void AddonList::GetMissionName(char *dir)
{
	char str[_MAX_PATH];
	MIFInterface mifdata;

	for(int i=0; i<datas; i++){
		//t@C𐶐
		strcpy(str, dir);
		strcat(str, "\\");
		strcat(str, filename[i]);

		//MIFInterfaceœǂݍ
		mifdata.LoadFiledata(str);

		//~bV擾
		strcpy(mission_name[i], mifdata.GetMissionName());
	}
}

//! @brief ~bV\[g
void AddonList::Sort()
{
	char mission_name_c[MAX_ADDONLIST][24];
	char temp[_MAX_PATH];
	int cmp;

	//~bVxɕϊ
	for(int i=0; i<datas; i++){
		for(int j=0; j<(int)strlen(mission_name[i]); j++){
			mission_name_c[i][j] = (char)tolower(mission_name[i][j]);
		}
		mission_name_c[i][strlen(mission_name[i])] = '\0';
	}

	//ᑬȃou\[g@iOOG
	for(int i=0; i<datas-1; i++){
		for(int j=i+1; j<datas; j++){
			cmp = strcmp(mission_name_c[i], mission_name_c[j]);
			if(cmp > 0){
				strcpy(temp, mission_name_c[i]);
				strcpy(mission_name_c[i], mission_name_c[j]);
				strcpy(mission_name_c[j], temp);

				strcpy(temp, mission_name[i]);
				strcpy(mission_name[i], mission_name[j]);
				strcpy(mission_name[j], temp);

				strcpy(temp, filename[i]);
				strcpy(filename[i], filename[j]);
				strcpy(filename[j], temp);
			}
		}
	}

}

//! @brief ADDONXg擾
//! @param dir ADDONi.mifjfBNg@iWF"addon\\"j
//! @return addon̑
int AddonList::LoadFiledata(char *dir)
{
	datas = 0;

	//.mift@C擾
	GetMIFlist(dir);

	//~bV擾
	GetMissionName(dir);

	//~bV\[g
	Sort();

#ifdef ENABLE_DEBUGLOG
	char str[128];
	sprintf(str, "addontH_ifBNgF%s@vF%dj", dir, datas);

	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "fBNg", str);
#endif

	return datas;
}

//! @brief ~bV擾
//! @param id Fԍ
//! @return ~bV
char* AddonList::GetMissionName(int id)
{
	return mission_name[id];
}

//! @brief t@C擾
//! @param id Fԍ
//! @return t@C
char* AddonList::GetFileName(int id)
{
	return filename[id];
}


//! @brief fgets()p@sR[h菜
//! @param str 
//! @return F0@sF1
int DeleteLinefeed(char str[])
{
	char *pstr;

	pstr = strchr(str, '\n');
	if( pstr ){
		*pstr = '\0';
		return 0;
	}
	return 1;
}
