//! @file object.cpp
//! @brief objectNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2019, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "object.h"

//! @brief RXgN^
object::object(class ParameterInfo *in_Param, float x, float y, float z, float rx, float size, bool flag)
{
	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	EnableFlag = flag;
	model_size = size;

	id_parameter = 0;
	id_model = -1;
	id_texture = -1;
	DarkModelFlag = false;
}

//! @brief fBXgN^
object::~object()
{}

//! @brief ݒlǗNXo^
//! @attention e֐gpOɎs邱ƁB
void object::SetParameterInfoClass(class ParameterInfo *in_Param)
{
	Param = in_Param;
}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
void object::SetPosData(float x, float y, float z, float rx)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
}

//! @brief WƊpx擾
//! @param x XW󂯎|C^iNULLj
//! @param y YW󂯎|C^iNULLj
//! @param z ZW󂯎|C^iNULLj
//! @param rx ]󂯎|C^iNULLj
void object::GetPosData(float *x, float *y, float *z, float *rx)
{
	if( x != NULL ){ *x = pos_x; }
	if( y != NULL ){ *y = pos_y; }
	if( z != NULL ){ *z = pos_z; }
	if( rx != NULL ){ *rx = rotation_x; }
}

//! @brief LtOݒ
//! @param flag ݒ肷tO
void object::SetEnableFlag(bool flag)
{
	EnableFlag = flag;
}

//! @brief LtO擾
//! @return ݐݒ肳ĂtO
bool object::GetEnableFlag()
{
	return EnableFlag;
}

//! @brief ff[^ݒ
//! @param id fFԍ
//! @param size `{
void object::SetModel(int id, float size)
{
	id_model = id;
	model_size = size;
}

//! @brief ff[^擾
//! @param id fFԍ󂯎|C^iNULLj
//! @param size `{󂯎|C^iNULLj
void object::GetModel(int *id, float *size)
{
	if( id != NULL ){ *id = id_model; }
	if( size != NULL ){ *size = model_size; }
}

//! @brief eNX`ݒ
//! @param id eNX`Fԍ
void object::SetTexture(int id)
{
	id_texture = id;
}

//! @brief eNX`擾
//! @return eNX`Fԍ
int object::GetTexture()
{
	return id_texture;
}

//! @brief fÂtOݒ
//! @param flag tO
void object::SetDarkModelFlag(bool flag)
{
	DarkModelFlag = flag;
}

//! @brief vZsiRȂǁj
int object::RunFrame()
{
	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void object::Render(D3DGraphics *d3dg)
{
	if( d3dg == NULL ){ return; }
	if( EnableFlag == false ){ return; }

	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, 0.0f, model_size);
	d3dg->RenderModel(id_model, id_texture, DarkModelFlag);
}

//! @brief RXgN^
human::human(class ParameterInfo *in_Param, float x, float y, float z, float rx, int id_param, int dataid, signed char p4, int team, bool flag)
{
	//HumanParameter data;

	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	move_y_flag = false;
	rotation_x = rx;
	id_parameter = id_param;
	upmodel_size = 9.4f;
	armmodel_size = 9.0f;
	legmodel_size = 9.0f;
	EnableFlag = flag;
	rotation_y = 0.0f;
	armrotation_y = 0.0f;
	point_dataid = dataid;
	point_p4 = p4;
	teamid = team;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}
	selectweapon = 1;
	selectweaponcnt = 0;
	weaponshotcnt = 0;
	weaponreloadcnt = 0;
	//if( Param->GetHuman(id_param, &data) == 0 ){
	//	hp = data.hp;
	//}
	//else{
		hp = 0;
	//}
	deadstate = 0;
	add_ry = 0.0f;
	id_texture = -1;

	move_rx = 0.0f;
	MoveFlag = 0x00;
	MoveFlag_lt = MoveFlag;
	scopemode = 0;
	HitFlag = false;
	Hit_rx = 0.0f;
	totalmove = 0.0f;
	StateGunsightErrorRange = 0;
	ReactionGunsightErrorRange = 0;

	MotionCtrl = new HumanMotionControl;
}

//! @brief fBXgN^
human::~human()
{
	delete MotionCtrl;
}

//! @brief ݒlǗNXo^
//! @attention e֐gpOɎs邱ƁB
void human::SetParameterInfoClass(class ParameterInfo *in_Param)
{
	Param = in_Param;

	MotionCtrl->SetParameterInfoClass(in_Param);
}

//! @brief ݒlݒ
//! @param id_param l̎ޔԍ
//! @param dataid |Cg̃f[^ԍ
//! @param p4 4p[^
//! @param team `[ԍ
//! @param init IuWFNg
//! @warning inittrueɂďꍇASetPosData()֐Ŋpxݒ肵ĂƁB
void human::SetParamData(int id_param, int dataid, signed char p4, int team, bool init)
{
	id_parameter = id_param;
	point_dataid = dataid;
	point_p4 = p4;
	teamid = team;

	if( init == true ){
		HumanParameter data;

		move_x = 0.0f;
		move_y = 0.0f;
		move_z = 0.0f;
		move_y_flag = false;
		rotation_y = 0.0f;
		armrotation_y = DegreeToRadian(-30);

		for(int i=0; i<TOTAL_HAVEWEAPON; i++){
			weapon[i] = NULL;
		}
		selectweapon = 1;
		selectweaponcnt = 0;
		weaponshotcnt = 0;
		weaponreloadcnt = 0;
		if( Param->GetHuman(id_param, &data) == 0 ){
			hp = data.hp;
		}
		else{
			hp = 0;
		}
		deadstate = 0;
		add_ry = 0.0f;
		MoveFlag = 0x00;
		MoveFlag_lt = MoveFlag;
		scopemode = 0;
		HitFlag = false;
		Hit_rx = 0.0f;
		totalmove = 0.0f;
		Invincible = false;

		MotionCtrl->Init(rotation_x);
	}
}

//! @brief ݒl擾
//! @param id_param l̎ޔԍ󂯎|C^iNULLj
//! @param dataid |Cg̃f[^ԍ󂯎|C^iNULLj
//! @param p4 4p[^󂯎|C^iNULLj
//! @param team `[ԍ󂯎|C^iNULLj
void human::GetParamData(int *id_param, int *dataid, signed char *p4, int *team)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( dataid != NULL ){ *dataid = point_dataid; }
	if( p4 != NULL ){ *p4 = point_p4; }
	if( team != NULL ){ *team = teamid; }
}

//! @brief HP擾
//! @return HP
int human::GetHP()
{
	return hp;
}

//! @brief HPݒ
//! @param in_hp Vɐݒ肷HP
//! @return Ftrue@sFfalse
//! @attention HP1ȏ̐lɑ΂ĎsȂƎs܂B
bool human::SetHP(int in_hp)
{
	if( hp > 0 ){
		hp = in_hp;
		return true;
	}
	return false;
}


//! @brief ̂ǂ
//! @return ́Ftrue@̂łȂFfalse
//! @warning SɐÎ~ԂúvƔ肵܂B|ĂŒ̐l͑ΏۂɊ܂܂Ȃ߁Ahp <= 0 SĎ̂Ɣ肳Ƃ͌܂B
bool human::GetDeadFlag()
{
	if( deadstate == 5 ){ return true; }
	return false;
}

//! @brief `[ԍݒi㏑j
//! @param id V`[ԍ
void human::SetTeamID(int id)
{
	teamid = id;
}

//! @brief GtO擾
//! @return GFtrue@ʏFfalse
//! @attention GԂ̏ꍇAeeE֒e̔E@ɂ_[W؎󂯂܂B
bool human::GetInvincibleFlag()
{
	return Invincible;
}

//! @brief GtOݒ
//! @param flag GFtrue@ʏFfalse
//! @attention GԂ̏ꍇAeeE֒e̔E@ɂ_[W؎󂯂܂B
void human::SetInvincibleFlag(bool flag)
{
	Invincible = flag;
}

//! @brief Öړʂ擾
//! @param *x Xړʂ擾|C^iNULLj
//! @param *y Yړʂ擾|C^iNULLj
//! @param *z Zړʂ擾|C^iNULLj
void human::GetMovePos(float *x, float *y, float *z)
{
	if( x != NULL ){ *x = move_x; }
	if( y != NULL ){ *y = move_y; }
	if( z != NULL ){ *z = move_z; }
}

//! @brief ff[^ݒ
//! @param upmodel 㔼g̃f
//! @param armmodel[] r̃f̔ziz񐔁FTOTAL_ARMMODEj
//! @param legmodel iÎ~ԁj̃f
//! @param walkmodel[] r̃f̔ziz񐔁FTOTAL_WALKMODEj
//! @param runmodel[] r̃f̔ziz񐔁FTOTAL_RUNMODEj
void human::SetModel(int upmodel, int armmodel[], int legmodel, int walkmodel[], int runmodel[])
{
	MotionCtrl->SetModel(upmodel, armmodel, legmodel, walkmodel, runmodel);
}

//! @brief ݒ
//! @param in_weapon[] ݒ肷weaponNX̃|C^z
//! @warning ʏ PickupWeapon()֐ gp邱
void human::SetWeapon(class weapon *in_weapon[])
{
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		if( in_weapon[i] == NULL ){
			weapon[i] = NULL;
		}
		else{
			//𐳂E΁AƂēo^
			if( in_weapon[i]->Pickup() == 0 ){
				weapon[i] = in_weapon[i];
			}
		}
	}
}

//! @brief E
//! @param in_weapon[] ݒ肷weaponNX̃|C^
//! @return F1@sF0
int human::PickupWeapon(class weapon *in_weapon)
{
	if( in_weapon == NULL ){
		return 0;
	}

	if( weapon[selectweapon] == NULL ){
		//𐳂E΁AƂēo^
		if( in_weapon->Pickup() == 0 ){
			weapon[selectweapon] = in_weapon;

			//r̊pxijݒ
			class weapon *nowweapon;
			int id_param = 0;
			nowweapon = weapon[selectweapon];
			nowweapon->GetParamData(&id_param, NULL, NULL);
			MotionCtrl->PickupWeapon(id_param);

			//؂ւ̃JEg
			selectweaponcnt = 10;

			return 1;
		}
	}
	return 0;
}

//! @brief ؂ւiւj
//! @param id ւ镐@i-1 Ŏ̕j
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::ChangeWeapon(int id)
{
	//̗͂ȂΎs
	if( hp <= 0 ){ return; }

	//[hȂ玸s
	if( weaponreloadcnt > 0 ){ return; }

	//ɐ؂ւ悤ƂĂȂAs
	if( selectweapon == id ){ return; }

	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return; }

	if( id == -1 ){
		//̕ԍI
		selectweapon += 1;
		if( selectweapon == TOTAL_HAVEWEAPON ){
			selectweapon = 0;
		}
	}
	else{
		//ԍ͈͓mF
		if( (id < 0)||((TOTAL_HAVEWEAPON -1) < id ) ){ return; }
		selectweapon = id;
	}

	//XR[v\
	SetDisableScope();

	//ݑ镐̃NX擾
	class weapon *nowweapon;
	nowweapon = weapon[selectweapon];

	//r̊pxijݒ
	if( nowweapon == NULL ){	//Ԃ
		MotionCtrl->ChangeWeapon(ID_WEAPON_NONE);
	}
	else{
		int id_param = 0;
		nowweapon->GetParamData(&id_param, NULL, NULL);
		MotionCtrl->ChangeWeapon(id_param);
	}

	//؂ւ̃JEg
	selectweaponcnt = 10;
}

//! @brief ̐؂ւJEg擾
//! @return JEg@i1ȏŐ؂ւj
int human::GetChangeWeaponCnt()
{
	return selectweaponcnt;
}

//! @brief ̃[hJEg擾
//! @return JEg@i[hF1ȏj
int human::GetWeaponReloadCnt()
{
	return weaponreloadcnt;
}

//! @brief 擾
//! @param out_selectweapon IĂ镐@i0 ` [TOTAL_HAVEWEAPON]-1j
//! @param out_weapon 󂯎weaponNX̃|C^z@iz񐔁FTOTAL_HAVEWEAPONj
void human::GetWeapon(int *out_selectweapon, class weapon *out_weapon[])
{
	*out_selectweapon = selectweapon;
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		out_weapon[i] = weapon[i];
	}
}

//! @brief ݑĂ镐̎ޔԍ擾
//! @return ̎ޔԍi0 ` TOTAL_PARAMETERINFO_WEAPON -1j
//! @attention ݎɎĂ镐̎ޔԍłB@GetWeapon()֐ pĒׂ̂ƓłB
int human::GetMainWeaponTypeNO()
{
	if( weapon[selectweapon] == NULL ){
		return ID_WEAPON_NONE;
	}

	int id_param;
	weapon[selectweapon]->GetParamData(&id_param, NULL, NULL);
	return id_param;
}

//! @brief Aːݒ擾
//! @return Aˉ\Ftrue@A˕sFfalse
bool human::GetWeaponBlazingmode()
{
	int param_id;
	WeaponParameter data;

	//𑕔ĂȂ΁As
	if( weapon[selectweapon] == NULL ){ return false; }

	//Ă镐̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);

	//AːݒԂ
	Param->GetWeapon(param_id, &data);
	return data.blazingmode;
}

//! @brief C
//! @param weapon_paramid C̔ԍ󂯎|C^
//! @param GunsightErrorRange Cۂ̏Ə덷󂯎|C^
//! @return Ftrue@sFfalse
//! @attention eIuWFNg̏AC̍Đ͕ʓrsKv܂B
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::ShotWeapon(int *weapon_paramid, int *GunsightErrorRange)
{
	int param_id;

	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//𑕔ĂȂ΁As
	if( weapon[selectweapon] == NULL ){ return false; }

	//ˊԊuɖȂA[hȂΎs
	if( weaponshotcnt > 0 ){ return false; }
	if( weaponreloadcnt > 0 ){ return false; }

	//e̔ˏs
	if( weapon[selectweapon]->Shot() != 0 ){ return false; }

	//̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);


	//̐ݒl擾
	WeaponParameter ParamData;
	if( Param->GetWeapon(param_id, &ParamData) != 0 ){ return false; }

	//A˃JEgݒ
	weaponshotcnt = ParamData.blazings;

	//XR[v̕ŃXR[v`ĂȂ΁A덷 20B
	if( (scopemode == 0)&&(ParamData.scopemode == 2) ){
		ReactionGunsightErrorRange = 20;
	}


	//̎ޔԍƌ덷Ԃ
	*weapon_paramid = param_id;
	*GunsightErrorRange = StateGunsightErrorRange + ReactionGunsightErrorRange;


	//덷vZ
	if( (scopemode == 1)||(ParamData.scopemode == 2) ){
		//ȈՃXR[vgpAXR[vĂȂA
		//Ə̌덷Ȃ
	}
	else {
		//ݒ肳ꂽ덷ZB
		ReactionGunsightErrorRange += ParamData.reaction;
	}

	//XR[vgpĂԂ̔Z
	if( (ParamData.scopemode == 1)&&(scopemode != 0) ){
		int rx_rnds, ry_rnds;
		float rx_degree, ry_degree;

		//_̐l͈͌vZ
		rx_rnds = (int)(WEAPONRECOIL_SCOPE_1_RX*10) * 2;
		ry_rnds = (int)(WEAPONRECOIL_SCOPE_1_RYMAX*10) - (int)(WEAPONRECOIL_SCOPE_1_RYMIN*10);

		//ipxj
		rx_degree = WEAPONRECOIL_SCOPE_1_RX*-1 + ((float)GetRand(rx_rnds))/10;
		ry_degree = WEAPONRECOIL_SCOPE_1_RYMIN + ((float)GetRand(ry_rnds))/10;

		//Z
		rotation_x += DegreeToRadian(rx_degree);
		armrotation_y += DegreeToRadian(ry_degree);
	}
	if( ParamData.scopemode == 2 ){
		int rx_rnds, ry_rnds;
		float rx_degree, ry_degree;

		//_̐l͈͌vZ
		rx_rnds = (int)(WEAPONRECOIL_SCOPE_2_RX*10) * 2;
		ry_rnds = (int)(WEAPONRECOIL_SCOPE_2_RYMAX*10) - (int)(WEAPONRECOIL_SCOPE_2_RYMIN*10);

		//ipxj
		rx_degree = WEAPONRECOIL_SCOPE_2_RX*-1 + ((float)GetRand(rx_rnds))/10;
		ry_degree = WEAPONRECOIL_SCOPE_2_RYMIN + ((float)GetRand(ry_rnds))/10;

		//Z
		rotation_x += DegreeToRadian(rx_degree);
		armrotation_y += DegreeToRadian(ry_degree);
	}

	//rɔ`
	MotionCtrl->ShotWeapon(param_id);

	//킪ȂĂ΁AOɁB@i֒epj
	if( weapon[selectweapon]->GetEnableFlag() == false ){
		weapon[selectweapon] = NULL;
	}
	return true;
}

//! @brief [h
//! @return Ftrue@sFfalse
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::ReloadWeapon()
{
	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//̕𑕔Ă΁`
	if( weapon[selectweapon] != NULL ){
		//[hȂ玸s
		if( weaponreloadcnt > 0 ){ return false; }

		//[hJn
		if( weapon[selectweapon]->StartReload() != 0 ){ return false; }

		//XR[v[h
		SetDisableScope();

		//[Vs
		class weapon *nowweapon;
		int id_param = 0;
		nowweapon = weapon[selectweapon];
		nowweapon->GetParamData(&id_param, NULL, NULL);
		MotionCtrl->ReloadWeapon(id_param);

		//̐\l擾
		int param_id;
		WeaponParameter ParamData;
		weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);
		if( Param->GetWeapon(param_id, &ParamData) != 0 ){ return 1; }

		//[hJEgݒ
		weaponreloadcnt = ParamData.reloads + 1;

		return true;
	}
	return false;
}

//! @brief ̂Ă
//! @return Ftrue@sFfalse
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::DumpWeapon()
{
	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//̕𑕔Ă΁`
	if( weapon[selectweapon] != NULL ){
		//[hȂ玸s
		if( weaponreloadcnt > 0 ){ return false; }

		//̂āA
		weapon[selectweapon]->Dropoff(pos_x, pos_y, pos_z, rotation_x, 1.63f);
		weapon[selectweapon] = NULL;

		//XR[v[h
		SetDisableScope();

		//[Vs
		MotionCtrl->DumpWeapon();

		return true;
	}

	return false;
}

//! @brief ̃Vbg[h؂ւ
//! @return F0@sF1
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
int human::ChangeShotMode()
{
	//𑕔ĂȂΎs
	if( weapon[selectweapon] == NULL ){ return 1; }

	//Ă镐̏擾
	int param_id, lnbs, nbs;
	weapon[selectweapon]->GetParamData(&param_id, &lnbs, &nbs);

	//̃Vbg[h؂ւiVԍj𒲂ׂ
	WeaponParameter ParamData;
	int ChangeWeapon;
	if( Param->GetWeapon(param_id, &ParamData) != 0 ){ return 1; }
	ChangeWeapon = ParamData.ChangeWeapon;

	//VԍmF
	if( ChangeWeapon == param_id ){ return 1; }
	if( (ChangeWeapon < 0)||(TOTAL_PARAMETERINFO_WEAPON-1 < ChangeWeapon) ){ return 1; }

	//ݒKp
	weapon[selectweapon]->SetParamData(ChangeWeapon, lnbs, nbs, false);

	//XR[vgpȂ
	if( scopemode != 0 ){
		//V̏擾
		if( Param->GetWeapon(ChangeWeapon, &ParamData) != 0 ){ return 1; }

		if( scopemode == ParamData.scopemode ){
			//XR[vgȂ΁AXR[vێ
		}
		else if( ParamData.scopemode == 0 ){
			//XR[vgȂȂ΁AXR[v
			SetDisableScope();
		}
		else{
			//قȂXR[vgȂ΁AXR[vĐݒ
			SetEnableScope();
		}
	}

	//[Vs
	MotionCtrl->ChangeShotMode(ChangeWeapon);

	return 0;
}

//! @brief Oiijݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveForward()
{
	SetFlag(MoveFlag, MOVEFLAG_FORWARD);
}

//! @brief ނݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveBack()
{
	SetFlag(MoveFlag, MOVEFLAG_BACK);
}

//! @brief ݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveLeft()
{
	SetFlag(MoveFlag, MOVEFLAG_LEFT);
}

//! @brief Eݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveRight()
{
	SetFlag(MoveFlag, MOVEFLAG_RIGHT);
}

//! @brief ݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveWalk()
{
	SetFlag(MoveFlag, MOVEFLAG_WALK);
}

//! @brief l̈ړ[h擾
//! @param nowdata ݂̒l擾Ftrue@Ot[̒lgpFfalse
//! @return F1@F2@ړĂȂF0
int human::GetMovemode(bool nowdata)
{
	//gpĂȂAĂȂΏI
	if( EnableFlag == false ){ return 0; }
	if( hp <= 0 ){ return 0; }

	if( nowdata == false ){	//Õf[^
		//Ȃ 1
		if( GetFlag(MoveFlag_lt, MOVEFLAG_WALK) ){
			return 1;
		}
		//Ȃ 2
		if( GetFlag(MoveFlag_lt, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
			return 2;
		}
	}
	else{					//݂̃f[^
		//Ȃ 1
		if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
			return 1;
		}
		//Ȃ 2
		if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
			return 2;
		}
	}

	//ړĂȂ
	return 0;
}

//! @brief XR[vݒ
//! @return Ftrue@sFfalse
bool human::SetEnableScope()
{
	int param_id;
	WeaponParameter data;

	//𑕔ĂȂΎs
	if( weapon[selectweapon] == NULL ){ return false; }

	//[hȂ玸s
	if( weaponreloadcnt > 0 ){ return false; }

	//̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);

	//̐ݒl擾
	Param->GetWeapon(param_id, &data);

	//XR[vݒ
	scopemode = data.scopemode;
	return true;
}

//! @brief XR[v
void human::SetDisableScope()
{
	scopemode = 0;
}

//! @brief XR[vݒ擾
int human::GetScopeMode()
{
	return scopemode;
}

//! @brief Əč擾
//! @param rx 擾|C^
//! @param ry c擾|C^
void human::GetRxRy(float *rx, float *ry)
{
	*rx = rotation_x;
	*ry = armrotation_y;
}

//! @brief Əčݒ
//! @param rx ݒ肷鉡
//! @param ry ݒ肷c
void human::SetRxRy(float rx, float ry)
{
	rotation_x = rx;
	armrotation_y = ry;
}

//! @brief Ŝ̉]px擾
//! @return c擾|C^
//! @warning Sē|ۂ̊pxłBGetRxRy()֐Ŏ󂯎lƂ͈قȂ܂B
float human::GetDeadRy()
{
	return rotation_y;
}

//! @brief Wv
//! @return F0@sF1
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
int human::Jump()
{
	//nʂɐGĂAx0.0Ȃ
	if( move_y_flag == false ){
		if( move_y == 0.0f ){
			move_y = HUMAN_JUMP_SPEED;

			//[Vs
			MotionCtrl->Jump();
			return 0;
		}
	}
	return 1;
}

//! @brief E͂
//! @param rx 
//! @param ry c
//! @param speed x
void human::AddPosOrder(float rx, float ry, float speed)
{
	move_x += cos(rx) * cos(ry) * speed;
	move_y += sin(ry) * speed;
	move_z += sin(rx) * cos(ry) * speed;
}

//! @brief e  Ƀqbg
//! @param attacks e̍U
void human::HitBulletHead(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_HEAD) + GetRand(16);
	}
	ReactionGunsightErrorRange = 15;
}

//! @brief e 㔼g Ƀqbg
//! @param attacks e̍U
void human::HitBulletUp(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_UP) + GetRand(8);
	}
	ReactionGunsightErrorRange = 12;
}

//! @brief e g Ƀqbg
//! @param attacks e̍U
void human::HitBulletLeg(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_LEG) + GetRand(6);
	}
	ReactionGunsightErrorRange = 8;
}

//! @brief ]r̍Uqbg
void human::HitZombieAttack()
{
	if( Invincible == false ){
		hp -= HUMAN_DAMAGE_ZOMBIEU + GetRand(HUMAN_DAMAGE_ZOMBIEA);
	}
	ReactionGunsightErrorRange = 10;
}

//! @brief ֒e̔qbg
//! @param attacks ̍U
//! @attention ɂvZOɍς܂ĂB
void human::HitGrenadeExplosion(int attacks)
{
	if( Invincible == false ){
		hp -= attacks;
	}
	ReactionGunsightErrorRange = 10;
}

//! @brief etOZbg
//! @param rx e
void human::SetHitFlag(float rx)
{
	HitFlag = true;
	Hit_rx = rx;
}

//! @brief e`FbN
//! @param rx e󂯎|C^iNULLj
//! @return eFtrue@eĂȂFfalse
//! @attention sƁAtO false ɏ܂B
bool human::CheckHit(float *rx)
{
	bool returnflag = HitFlag;
	if( rx != NULL ){ *rx = Hit_rx; }
	HitFlag = false;
	//Hit_rx = 0.0f;
	return returnflag;
}

//! @brief vړʂ擾
//! @return vړ
float human::GetTotalMove()
{
	return totalmove;
}

//! @brief Ə̏Ԍ덷̏
//!	@attention ControlProcess()Oŏ邱
void human::GunsightErrorRange()
{
	//
	StateGunsightErrorRange = 0;

	//eɂ덷ݒ
	if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
		StateGunsightErrorRange = 4;
	}
	if( GetFlag(MoveFlag, MOVEFLAG_FORWARD) ){
		StateGunsightErrorRange = 8;
	}
	if( GetFlag(MoveFlag, MOVEFLAG_BACK) ){
		StateGunsightErrorRange = 6;
	}
	if( GetFlag(MoveFlag, (MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
		StateGunsightErrorRange = 7;
	}
	if( move_y_flag == true ){
		StateGunsightErrorRange = 22;
	}
	if( hp < 40 ){
		StateGunsightErrorRange += 3;
	}

	//𑕔Ă
	if( weapon[selectweapon] != NULL ){
		//̐ݒf[^擾
		int param;
		WeaponParameter data;
		weapon[selectweapon]->GetParamData(&param, NULL, NULL);
		Param->GetWeapon(param, &data);

		//덷 1 炷
		ReactionGunsightErrorRange -= 1;

		//덷͈̔͂␳
		if( ReactionGunsightErrorRange < 0 ){ ReactionGunsightErrorRange = 0; }
		if( ReactionGunsightErrorRange > data.ErrorRangeMAX ){ ReactionGunsightErrorRange = data.ErrorRangeMAX; }
	}
	else{
		ReactionGunsightErrorRange = 0;
	}
}

//! @brief SƓ|鏈
//! @return Î~́F4@|IF3@|ĂŒF2@|n߂F1@ȂF0
int human::CheckAndProcessDead(class Collision *CollD)
{
#ifdef HUMAN_DEADBODY_COLLISION

	//F
	//
	//ԁF0
	//mȂn
	//@HP0ȉŁAtʂȂ@ԁF1
	//@HP0ȉŁAǂɓtȂ@ԁF4
	//
	//ԁF1
	//mXn߂n
	//@135xs@ԁF2
	//@ǂɓł@ԁF3
	//
	//ԁF2
	//mn
	//@nʂɕt@ԁF4
	//
	//ԁF3
	//m点n
	//@@
	//ԁF4
	//mŒn

	float check_posx, check_posy, check_posz;

	if( deadstate == 0 ){
		if( hp <= 0 ){		//HP 0 ȉɂȂiSjuԂȂA|n߂
			float tr;

			//ŌɍU󂯂vZ
			tr = Hit_rx - rotation_x;
			for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
			for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

			//̂̊px
			if( ((float)M_PI/2*-1 < tr)&&(tr < (float)M_PI/2) ){
				add_ry = HUMAN_DEADADDRY;
			}
			else{
				add_ry = HUMAN_DEADADDRY * -1;
			}

			//r̊px
			if( armrotation_y < 0.0f ){
				armrotation_y = DegreeToRadian(-90);
			}
			else{
				armrotation_y = DegreeToRadian(90);
			}

			//̂܂ʂ悤A +1.0 
			pos_y += 1.0f;

			//Ă镐SĎ̂Ă
			for(int i=0; i<TOTAL_HAVEWEAPON; i++){
				if( weapon[i] != NULL ){
					weapon[i]->Dropoff(pos_x, pos_y, pos_z, DegreeToRadian(10)*GetRand(36), 1.5f);
					weapon[i] = NULL;
				}
			}

			//XR[v[h
			SetDisableScope();

			//̃t[̓̍W擾
			check_posx = pos_x + cos(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGHT;
			check_posy = pos_y + cos(add_ry) * HUMAN_HEIGHT;
			check_posz = pos_z + sin(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGHT;

			if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
				deadstate = 2;
			}
			else{
				rotation_y += add_ry;
				deadstate = 1;
			}
			return 1;
		}
		return 0;
	}

	if( deadstate == 1 ){
		//135xȏ|Ă
		if( fabs(rotation_y) >= DegreeToRadian(135) ){
			deadstate = 2;
			move_y = 0.0f;
			return 2;
		}

		if( pos_y <= (HUMAN_DEADLINE + 10.0f) ){
			//90xȏ|Ă
			if( fabs(rotation_y) >= DegreeToRadian(90) ){
				deadstate = 4;
				return 2;
			}
		}

		//Oɓ|
		if( rotation_y > 0.0f ){		//rotation_y < DegreeToRadian(135)
			add_ry += HUMAN_DEADADDRY;
		}
		else if( rotation_y < 0.0f ){	//rotation_y > DegreeToRadian(-135)
			add_ry -= HUMAN_DEADADDRY;
		}

		if( pos_y <= HUMAN_DEADLINE ){
			rotation_y += add_ry;
		}
		else{
			//̃t[̓̍W擾
			check_posx = pos_x + cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;
			check_posy = pos_y + cos(rotation_y + add_ry) * HUMAN_HEIGHT;
			check_posz = pos_z + sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;

			if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
				deadstate = 3;
			}
			else{
				rotation_y += add_ry;
			}
		}

		return 2;
	}

	if( deadstate == 2 ){
		if( pos_y <= HUMAN_DEADLINE ){
			deadstate = 4;
			return 2;
		}

		if( move_y > -4.0f ){
			move_y -= 0.1f;
		}

		//̃t[̑̍W
		check_posx = pos_x;
		check_posy = pos_y - move_y - HUMAN_HEIGHT*0.5f;
		check_posz = pos_z;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
		}
		else{
			pos_y += move_y;
		}

		return 2;
	}

	if( deadstate == 3 ){
		//deadstate = 4;

		//90xȏ|Ă
		if( fabs(rotation_y) >= DegreeToRadian(90) ){
			deadstate = 4;
			return 2;
		}

		//Oɓ|
		if( rotation_y > 0.0f ){		//rotation_y < DegreeToRadian(90)
			add_ry += HUMAN_DEADADDRY;
		}
		else if( rotation_y < 0.0f ){	//rotation_y > DegreeToRadian(-90)
			add_ry -= HUMAN_DEADADDRY;
		}

		//̃t[̑̍W擾
		check_posx = pos_x - cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;
		check_posy = pos_y + 0.1f;
		check_posz = pos_z - sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
			return 2;
		}

		//̃t[̓̍W擾
		check_posx = pos_x - cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;
		check_posy = pos_y + cos(rotation_y + add_ry) * HUMAN_HEIGHT;
		check_posz = pos_z - sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGHT;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
			return 2;
		}

		//̍Wړ
		pos_x -= cos(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGHT;
		pos_z -= sin(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGHT;

		rotation_y += add_ry;
		return 2;
	}

	if( deadstate == 4 ){
		//ȂiŒj
		deadstate = 5;
		return 3;
	}

	if( deadstate == 5 ){
		//ȂiŒj
		return 4;
	}

	return 0;
#else
	if( fabs(rotation_y) >= DegreeToRadian(90) ){
		return 4;
	}
	else if( rotation_y > 0.0f ){		//|n߂Ă΁Â܂ܓ|B
		add_ry += HUMAN_DEADADDRY;
		rotation_y += add_ry;
		if( rotation_y >= DegreeToRadian(90) ){
			rotation_y = DegreeToRadian(90);
			deadstate = 5;
			return 3;
		}
		return 2;
	}
	else if( rotation_y < 0.0f ){	//|n߂Ă΁Â܂ܓ|B
		add_ry -= HUMAN_DEADADDRY;
		rotation_y += add_ry;
		if( rotation_y <= DegreeToRadian(-90) ){
			rotation_y = DegreeToRadian(-90);
			deadstate = 5;
			return 3;
		}
		return 2;
	}
	else if( hp <= 0 ){		//HP 0 ȉɂȂiSjuԂȂA|n߂
		//̂̊pxEr̊px
		switch( GetRand(4) ){
			case 0:
				add_ry = HUMAN_DEADADDRY;
				armrotation_y = DegreeToRadian(90);
				break;
			case 1:
				add_ry = HUMAN_DEADADDRY * -1;
				armrotation_y = DegreeToRadian(90);
				break;
			case 2:
				add_ry = HUMAN_DEADADDRY;
				armrotation_y = DegreeToRadian(-90);
				break;
			case 3:
				add_ry = HUMAN_DEADADDRY * -1;
				armrotation_y = DegreeToRadian(-90);
				break;
		}

		rotation_y += add_ry;

		//̂܂ʂ悤A +1.0 
		pos_y += 1.0f;

		//Ă镐SĎ̂Ă
		for(int i=0; i<TOTAL_HAVEWEAPON; i++){
			if( weapon[i] != NULL ){
				weapon[i]->Dropoff(pos_x, pos_y, pos_z, DegreeToRadian(10)*GetRand(36), 1.5f);
				weapon[i] = NULL;
			}
		}

		//XR[v[h
		SetDisableScope();

		deadstate = 1;
		return 1;
	}

	return 0;
#endif
}

//! @brief ɂړvZ
//! @attention sƁAeL[tO false ɏ܂B
void human::ControlProcess()
{
	//isƑx
	if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
		move_rx = DegreeToRadian(0);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSWALK_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_FORWARD ){
		move_rx = DegreeToRadian(0);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_BACK ){
		move_rx = DegreeToRadian(180);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_LEFT ){
		move_rx = DegreeToRadian(90);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_SIDEWAYSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_RIGHT ){
		move_rx = DegreeToRadian(-90);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_SIDEWAYSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_LEFT) ){
		move_rx = DegreeToRadian(45);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_SIDEWAYSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_LEFT) ){
		move_rx = DegreeToRadian(135);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_SIDEWAYSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_RIGHT) ){
		move_rx = DegreeToRadian(-135);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_SIDEWAYSRUN_ACCELERATION);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_RIGHT) ){
		move_rx = DegreeToRadian(-45);
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_SIDEWAYSRUN_ACCELERATION);
	}
	else{
		move_rx = 0.0f;
	}

	//tOobNAbv
	MoveFlag_lt = MoveFlag;

	//L[tOɖ߂
	MoveFlag = 0x00;
}

//! @brief }bvƂ̓蔻
//! @param CollD CollisionNX̃|C^
//! @param inblockdata BlockDataInterfaceNX̃|C^
//! @param AddCollisionFlag ǉ̓蔻tO
//! @param FallDist Ÿړʂ擾|C^
//! @param nowmove_x Ẍړʂ擾|C^
//! @param nowmove_z Z̈ړʂ擾|C^
//! @return ubNɖ܂ĂFtrue@܂ĂȂFfalse
bool human::MapCollisionDetection(class Collision *CollD, class BlockDataInterface *inblockdata, bool AddCollisionFlag, float *FallDist, float *nowmove_x, float *nowmove_z)
{
	bool inside = false;
	int id;
	int face;
	float vx, vz;
	float vy = 0.1f;
	float speed;
	float Dist;
	float FallDistance;
	float offset;
	float move_x2 = move_x;
	float move_z2 = move_z;

	//MM͓蔻肩珜O
	offset = 0.1f;

	//@㉺̓蔻iWvERj
	//--------------------------------------------------

	//ubNɖ܂ĂȂ
	if( CollD->CheckALLBlockInside(pos_x, pos_y + offset, pos_z) == false ){
		//xvZ
		move_y -= HUMAN_DAMAGE_SPEED;
		if( move_y < HUMAN_DAMAGE_MAXSPEED ){ move_y = HUMAN_DAMAGE_MAXSPEED; }

		if( move_y > 0.0f ){
			//֓蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_HEIGHT, pos_z, 0, 1, 0, NULL, NULL, &Dist, move_y) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + HUMAN_HEIGHT, pos_z, 0, 1, 0, NULL, NULL, &Dist, move_y);

				FallDistance = Dist;
				move_y = 0.0f;
			}
			else{
				FallDistance = move_y;
			}
			move_y_flag = true;

			//DummyRay() ֐̌ʂɊւ炸 FallDistance = move_y; łǂ̂낤H
		}
		else{
			 int id, face;
			 struct blockdata bdata;

			//֓蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + offset, pos_z, 0, -1, 0, NULL, NULL, &Dist, move_y*-1 + offset) == true ){
				if( CollD->CheckALLBlockIntersectRay(pos_x, pos_y + offset, pos_z, 0, -1, 0, &id, &face, &Dist, move_y*-1 + offset) == false ){
					//A-DummyRay()֐ł̓ubN̂ -Ray()֐ŌȂȂA炭ubNcłB
					//Ƃ肠KȒlŌ떂AUhB
					Dist = offset;
				}

				if( Invincible == false ){
					//_[WvZ
					if( move_y > HUMAN_DAMAGE_MINSPEED ){ hp -= 0; }
					else{ hp -= (int)((float)HUMAN_DAMAGE_MAXFALL / fabs(HUMAN_DAMAGE_MAXSPEED - (HUMAN_DAMAGE_MINSPEED)) * fabs(move_y - (HUMAN_DAMAGE_MINSPEED))); }
				}

				FallDistance = (Dist - offset) * -1;
				move_y = 0.0f;
				
				inblockdata->Getdata(&bdata, id);

				//ΖʂɗĂȂ
				if( acos(bdata.material[face].vy) > HUMAN_MAPCOLLISION_SLOPEANGLE ){
					//nʂƔF߂Ȃ@iWv΍j
					move_y_flag = true;

					float angvx = atan2(bdata.material[face].vz, bdata.material[face].vx);
					float angvy = acos(bdata.material[face].vy);

					//o͂̌
					//y = -0.6*x*x + 1.9*x - 0.2
					float force = -0.6f*angvy*angvy + 1.9f*angvy - 0.2f;

					//o
					move_x = cos(angvx) * cos(HUMAN_MAPCOLLISION_SLOPEFORCEANGLE) * force;
					move_y = sin(HUMAN_MAPCOLLISION_SLOPEFORCEANGLE) * force;
					move_z = sin(angvx) * cos(HUMAN_MAPCOLLISION_SLOPEFORCEANGLE) * force;

					move_x2 = move_x;
					move_z2 = move_z;
				}
				else{
					move_y_flag = false;
				}
			}
			else{
				FallDistance = move_y;
				move_y_flag = true;
			}
		}
	}
	else{	//܂Ă
		FallDistance = move_y;
		move_y = 0.0f;
		move_y_flag = false;
	}


	//@̓蔻iړj
	//--------------------------------------------------

	if( (move_x2*move_x2 + move_z2*move_z2) ){
		int surface;
		float ang = atan2(move_z2, move_x2);
		float newpos_x, newpos_y, newpos_z;

		//t߂𓖂蔻
		for(int i=0; i<MAX_BLOCKS; i++){
			float min_x, min_y, min_z, max_x, max_y, max_z;
			CollD->GetBlockPosMINMAX(i, &min_x, &min_y, &min_z, &max_x, &max_y, &max_z);

			//t߂AABBōr
			if( CollideBoxAABB(min_x, min_y, min_z, max_x, max_y, max_z,
				pos_x - HUMAN_MAPCOLLISION_R - 1.0f, pos_y + HUMAN_MAPCOLLISION_HEIGHT - 1.0f, pos_z - HUMAN_MAPCOLLISION_R - 1.0f, pos_x + HUMAN_MAPCOLLISION_R + 1.0f, pos_y + HUMAN_MAPCOLLISION_HEIGHT + 1.0f, pos_z + HUMAN_MAPCOLLISION_R + 1.0f) == true
			){
				surface = -1;
				CollD->CheckBlockInside(i, pos_x, pos_y + HUMAN_MAPCOLLISION_HEIGHT, pos_z, false, &surface);

				if( surface != -1 ){
					//HUMAN_MAPCOLLISION_R ̐𒲂ׂ
					if( CollD->CheckBlockInside(i, pos_x + cos(ang)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGHT, pos_z + sin(ang)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
						CollD->ScratchVector(i, surface, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
					}

					//E90xÂ𒲂ׂ
					if( CollD->CheckBlockInside(i, pos_x + cos(ang + (float)M_PI/2)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGHT, pos_z + sin(ang + (float)M_PI/2)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
						if( CollD->CheckPolygonFrontRx(i, surface, ang) == true ){		//isɑ΂ĕ\Ȃ`
							CollD->ScratchVector(i, surface, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
						}
					}
					if( CollD->CheckBlockInside(i, pos_x + cos(ang - (float)M_PI/2)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGHT, pos_z + sin(ang - (float)M_PI/2)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
						if( CollD->CheckPolygonFrontRx(i, surface, ang) == true ){		//isɑ΂ĕ\Ȃ`
							CollD->ScratchVector(i, surface, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
						}
					}
				}
			}
		}

		//isxNgZo
		vx = move_x2;
		vz = move_z2;
		speed = sqrt(vx*vx + vz*vz);
		if( speed > 0.0f ){
			vx = vx / speed;
			vz = vz / speed;
		}

		//𓖂蔻
		if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_HEIGHT, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
			CollD->CheckALLBlockIntersectRay(pos_x, pos_y + FallDistance + HUMAN_HEIGHT, pos_z, vx, 0, vz, &id, &face, &Dist, speed);
			CollD->ScratchVector(id, face, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
		}

		if( AddCollisionFlag == true ){
			//t߂̒ǉ蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_MAPCOLLISION_ADD_HEIGHT_A, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + FallDistance + HUMAN_MAPCOLLISION_ADD_HEIGHT_A, pos_z, vx, 0, vz, &id, &face, &Dist, speed);
				CollD->ScratchVector(id, face, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
			}

			//t߂̒ǉ蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_MAPCOLLISION_ADD_HEIGHT_B, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + FallDistance + HUMAN_MAPCOLLISION_ADD_HEIGHT_B, pos_z, vx, 0, vz, &id, &face, &Dist, speed);
				CollD->ScratchVector(id, face, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
			}
		}

		//ubNɖ܂ĂȂ
		if( CollD->CheckALLBlockInside(pos_x, pos_y + offset, pos_z) == false ){

			//isxNgZo
			vx = move_x2;
			vz = move_z2;
			speed = sqrt(vx*vx + vz*vz);
			if( speed > 0.0f ){
				vx = vx / speed;
				vz = vz / speed;
			}

			//𓖂蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + offset, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + offset, pos_z, vx, 0, vz, &id, &face, &Dist, speed);

				struct blockdata bdata;
				inblockdata->Getdata(&bdata, id);
				float surface_ang = acos(bdata.material[face].vy);

				if( surface_ang > DegreeToRadian((90.0f-1.0f)) ){			//ǂȂ
					//z鍂ׂ
					if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + 3.5f + offset, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == false ){
						//lɎグ
						FallDistance = 0.4f;
						move_y = 0.0f;
					}

					//𓖂蔻
					CollD->ScratchVector(id, face, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
				}
				else if( surface_ang > HUMAN_MAPCOLLISION_SLOPEANGLE ){		//Ζʁ`ǂȂ
					//𓖂蔻
					CollD->ScratchVector(id, face, move_x2, vy, move_z2, &move_x2, &vy, &move_z2);
				}
				else{														//`ΖʂȂ
					//nʂƔF߂Ȃ@iWv΍j
					move_y_flag = true;

					//ړ̈ʒuvZ
					newpos_x = pos_x + move_x2;
					newpos_y = pos_y + FallDistance;
					newpos_z = pos_z + move_z2;

					//ړ̍𒲂ׂ
					if( CollD->CheckALLBlockInside(newpos_x, newpos_y + HUMAN_HEIGHT, newpos_z) == false ){
						if( CollD->CheckALLBlockIntersectRay(newpos_x, newpos_y + HUMAN_HEIGHT, newpos_z, 0, -1, 0, NULL, NULL, &Dist, HUMAN_HEIGHT) == true ){
							float height = HUMAN_HEIGHT - Dist;

							//lɎグ
							FallDistance = height;

							if( height > 0.4f ){
								move_x2 *= 0.75f;
								move_z2 *= 0.75f;
								move_x = move_x2;
								move_z = move_z2;
							}

							move_y = 0.0f;
						}
					}
				}
			}
		}

		//ړ̈ʒuvZ
		newpos_x = pos_x + move_x2;
		newpos_y = pos_y + FallDistance;
		newpos_z = pos_z + move_z2;

		//Sg߂ĊmF
		if(
			(CollD->CheckALLBlockInside(newpos_x, newpos_y + offset, newpos_z) == true)||
			(CollD->CheckALLBlockIntersectRay(newpos_x, newpos_y + offset, newpos_z, 0, 1, 0, NULL, NULL, &Dist, HUMAN_HEIGHT - offset - 1.0f) == true)
		){
			//߂荞ނȂړȂ
			move_x2 = 0.0f;
			move_z2 = 0.0f;
			inside = true;
		}
	}

	*FallDist = FallDistance;
	*nowmove_x = move_x2;
	*nowmove_z = move_z2;
	return inside;
}

//! @brief vZsi蔻j
//! @param CollD Collisioñ|C^
//! @param inblockdata BlockDataInterfacẽ|C^
//! @param AddCollisionFlag ǉ̓蔻tO
//! @param player Ώۂ̐lvC[ǂ
//! @param F5mode ㏸@\iF5Zj̃tO@iLFtrue@Ffalsej
//! @return ȂF0@ʏ폈F1@Sē|IF2@Î~́F3@n`ɂ莀SF4
int human::RunFrame(class Collision *CollD, class BlockDataInterface *inblockdata, bool AddCollisionFlag, bool player, bool F5mode)
{
	if( CollD == NULL ){ return 0; }
	if( EnableFlag == false ){ return 0; }

	if( deadstate == 5 ){ return 3; }

	int WeaponReloadMotionCnt;
	float FallDistance;
	float nowmove_x, nowmove_z;
	int CheckDead;
	int hp_old;

	//؂ւJEg
	if( selectweaponcnt > 0 ){
		selectweaponcnt -= 1;
	}

	//A˃JEgcĂ΁A1 炷
	if( weaponshotcnt > 0 ){
		weaponshotcnt -= 1;
	}

	//[hJEgcĂ 1 炵AA˃JEgу[hJEg 0 Ȃ΃[hs
	if( weaponreloadcnt > 0 ){
		weaponreloadcnt -= 1;
		if( (weaponshotcnt == 0)&&(weaponreloadcnt == 0) ){
			if( weapon[selectweapon] != NULL ){ weapon[selectweapon]->RunReload(); }
		}
	}

	//[hJEg擾i[Vpj
	if( weapon[selectweapon] != NULL ){
		WeaponReloadMotionCnt = weaponreloadcnt;
	}
	else{
		WeaponReloadMotionCnt = 0;
	}

	//Ə̏Ԍ덷̏
	GunsightErrorRange();

	//SƓ|鏈
	CheckDead = CheckAndProcessDead(CollD);
	if( CheckDead == 3 ){ return 2; }

	if( CheckDead == 0 ){
		//isƑx
		ControlProcess();

		//}bvƂ̓蔻
		hp_old = hp;
		MapCollisionDetection(CollD, inblockdata, AddCollisionFlag, &FallDistance, &nowmove_x, &nowmove_z);

		//ړȂ
		if( (nowmove_x*nowmove_x + nowmove_z*nowmove_z) > 0.0f ){
			totalmove += sqrt(nowmove_x*nowmove_x + nowmove_z*nowmove_z);
		}

		//Wړ
		pos_x += nowmove_x;
		pos_z += nowmove_z;

		//ړʂ
		move_x *= HUMAN_ATTENUATION;
		move_z *= HUMAN_ATTENUATION;

		//F5gpĂȂ΁AvZʂ𔽉f
		if( F5mode == false ){
			pos_y += FallDistance;
		}
		else{
			move_y = 0.0f;
			pos_y += 5.0f;	//gpĂ΁AIɏ㏸
		}


		//-100.0艺ɗAS
		if( pos_y < HUMAN_DEADLINE ){
			pos_y = HUMAN_DEADLINE;
			hp = 0;
			return 4;
		}

		//̃}bvƂ̓蔻HP[ɂȂȂAn`ɂ鎀S
		if( (hp_old >0)&&(hp <= 0) ){
			return 4;
		}
	}


	//ݑ镐̃NX擾
	class weapon *nowweapon;
	int weapon_paramid;
	nowweapon = weapon[selectweapon];

	if( nowweapon == NULL ){		//Ԃ
		weapon_paramid = ID_WEAPON_NONE;
	}
	else{							//Ă
		nowweapon->GetParamData(&weapon_paramid, NULL, NULL);
	}

	//[VvZ
	MotionCtrl->RunFrame(rotation_x, armrotation_y, weapon_paramid, WeaponReloadMotionCnt, MoveFlag_lt, hp, player);

	if( CheckDead != 0 ){ return 3; }
	return 1;
}

//! @brief W덷擾
int human::GetGunsightErrorRange()
{
	return StateGunsightErrorRange + ReactionGunsightErrorRange;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
//! @param Resource ResourceManager̃|C^
//! @param DrawArm rƕ̂ݕ`悷
//! @param player Ώۂ̐lvC[ǂ
//! @todo r̈ʒusŋ߂
//! @todo ̂̕ʂ̍iYj
void human::Render(class D3DGraphics *d3dg, class ResourceManager *Resource, bool DrawArm, bool player)
{
	//gp΍
	UNREFERENCED_PARAMETER(player);

	//ĂȂ΁AȂ
	if( d3dg == NULL ){ return; }
	if( EnableFlag == false ){ return; }

	//[V擾
	int upmodel, armmodel, legmodel;
	float armry, legrx;
	MotionCtrl->GetRenderMotion(&armry, &legrx, &upmodel, &armmodel, &legmodel);

	if( DrawArm == false ){
		//㔼g`
		d3dg->SetWorldTransform(pos_x, pos_y - 1.0f, pos_z, rotation_x + (float)M_PI, rotation_y, upmodel_size);
		d3dg->RenderModel(upmodel, id_texture, DarkModelFlag);

		//`
		d3dg->SetWorldTransform(pos_x, pos_y, pos_z, legrx + (float)M_PI, rotation_y, legmodel_size);
		d3dg->RenderModel(legmodel, id_texture, DarkModelFlag);
	}

	//ݑ镐̃NX擾
	class weapon *nowweapon;
	nowweapon = weapon[selectweapon];

	//r`
	if( rotation_y != 0.0f ){		//Sē|Ă or |n߂
		float x = pos_x + cos(rotation_x*-1 - (float)M_PI/2)*sin(rotation_y)*16.0f;
		float y = pos_y + cos(rotation_y)*16.0f;
		float z = pos_z + sin(rotation_x*-1 - (float)M_PI/2)*sin(rotation_y)*16.0f;
		d3dg->SetWorldTransform(x, y, z, rotation_x + (float)M_PI, armrotation_y + rotation_y, armmodel_size);
		d3dg->RenderModel(armmodel, id_texture, DarkModelFlag);
	}
	else if( nowweapon == NULL ){	//Ԃ
		d3dg->SetWorldTransform(pos_x, pos_y + 16.0f, pos_z, rotation_x + (float)M_PI, armry, armmodel_size);
		d3dg->RenderModel(armmodel, id_texture, DarkModelFlag);
	}
	else{							//Ă
		//̃fƃeNX`擾
		int id_param;
		WeaponParameter paramdata;
		int model, texture;
		nowweapon->GetParamData(&id_param, NULL, NULL);
		Param->GetWeapon(id_param, &paramdata);
		Resource->GetWeaponModelTexture(id_param, &model, &texture);

		//r`
		d3dg->SetWorldTransform(pos_x, pos_y + 16.0f, pos_z, rotation_x + (float)M_PI, armry, armmodel_size);
		d3dg->RenderModel(armmodel, id_texture, DarkModelFlag);

		//`
		d3dg->SetWorldTransformHumanWeapon(pos_x, pos_y + 16.0f, pos_z, paramdata.mx/10*-1, paramdata.my/10, paramdata.mz/10*-1, rotation_x + (float)M_PI, armry, paramdata.size);
		d3dg->RenderModel(model, texture, DarkModelFlag);
	}
}

//! @brief RXgN^
weapon::weapon(class ParameterInfo *in_Param, float x, float y, float z, float rx, int id_param, int nbs, bool flag)
{
	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	rotation_x = rx;
	EnableFlag = flag;

	id_parameter = id_param;
	usingflag = false;
	bullets = nbs;
	Loadbullets = 0;
	motionflag = true;

	if( Param != NULL ){
		WeaponParameter ParamData;
		if( Param->GetWeapon(id_param, &ParamData) == 0 ){
			model_size = ParamData.size;
			//id_model = ParamData.id_model;
			//id_texture = ParamData.id_texture;
		}
	}
	id_model = -1;
	id_texture = -1;
}

//! @brief fBXgN^
weapon::~weapon()
{}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
void weapon::SetPosData(float x, float y, float z, float rx)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	rotation_x = rx;
}

//! @brief ݒlݒ
//! @param id_param ̎ޔԍ
//! @param lnbs e
//! @param nbs ve
//! @param init IuWFNg
void weapon::SetParamData(int id_param, int lnbs, int nbs, bool init)
{
	id_parameter = id_param;
	bullets = nbs;
	Loadbullets = lnbs;

	if( init == true ){
		usingflag = false;
		motionflag = true;
	}
}

//! @brief ݒl擾
//! @param id_param ̎ޔԍ󂯎|C^iNULLj
//! @param lnbs e󂯎|C^iNULLj
//! @param nbs ve󂯎|C^iNULLj
void weapon::GetParamData(int *id_param, int *lnbs, int *nbs)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( lnbs != NULL ){ *lnbs = Loadbullets; }
	if( nbs != NULL ){ *nbs = bullets; }
}

//! @brief ̎gp󋵂̎擾
//! @return gpFtrue@gpFfalse
bool weapon::GetUsingFlag()
{
	return usingflag;
}

//! @brief E
//! @return F0@sF1
int weapon::Pickup()
{
	if( usingflag == true ){ return 1; }
	usingflag = true;
	return 0;
}

//! @brief ̂Ă
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
//! @param speed ̂Ă鏉
void weapon::Dropoff(float x, float y, float z, float rx, float speed)
{
	//`悷WƊpxݒ
	move_x = cos(rx*-1 + (float)M_PI/2) * speed;
	move_y = 0.0f;
	move_z = sin(rx*-1 + (float)M_PI/2) * speed;
	pos_x = x + cos(rx*-1 + (float)M_PI/2) * 5.0f;
	pos_y = y + 16.0f + move_y;
	pos_z = z + sin(rx*-1 + (float)M_PI/2) * 5.0f;
	rotation_x = rx + (float)M_PI;

	//gpijɐݒ肵AWړL
	usingflag = false;
	motionflag = true;
}

//! @brief C
//! @return F0@sF1
//! @attention AˊԊul܂B
//! @attention ֐ŝ́Aꂩ̏łB@uAˊԊuɖȂvu[hsvueȂvuȕ̎ނݒ肳Ăv
int weapon::Shot()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//eΎs
	if( Loadbullets == 0 ){ return 1; }

	//ݒl擾
	WeaponParameter ParamData;
	if( Param->GetWeapon(id_parameter, &ParamData) == 1 ){ return 1; }

	//킪֒eȂ΁`
	if( id_parameter == ID_WEAPON_GRENADE ){
		//e炷
		bullets -= 1;
		Loadbullets -= 1;

		if( (bullets - Loadbullets) <= 0 ){		//i[hĂȂjeȂ΁A킲ƏłB
			EnableFlag = false;
			usingflag = false;
		}
		else if( Loadbullets <= 0 ){			//[h
			Loadbullets = 1;
		}
		return 0;
	}

	//e炷
	Loadbullets -= 1;
	bullets -= 1;
	return 0;
}

//! @brief [hJn
//! @return F0@sF1
//! @attention [hԂl܂B
//! @attention ֐ŝ́Aꂩ̏łB@ueȂvuȕ̎ނݒ肳Ăv
int weapon::StartReload()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//eΎs
	if( (bullets - Loadbullets) == 0 ){ return 1; }
	return 0;
}

//! @brief [hs
//! @attention StartReload()֐ƈقȂAuɒe[܂B[hԂ͍l܂B
int weapon::RunReload()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//eΎs
	if( (bullets - Loadbullets) == 0 ){ return 1; }

	//̐\lAUe擾
	WeaponParameter ParamData;
	int nbsmax = 0;
	if( Param->GetWeapon(id_parameter, &ParamData) == 0 ){
		nbsmax = ParamData.nbsmax;
	}

	if( (bullets - Loadbullets) < nbsmax ){	//c̒e葕Ue
		bullets = (bullets - Loadbullets);
		Loadbullets = bullets;
	}
	else{									//c̒e̕
		bullets -= Loadbullets;
		Loadbullets = nbsmax;
	}

	return 0;
}

//! @brief ̎ށEe̕ύX
//! @param Resource ResourceManager̃|C^
//! @param id_param ޔԍ
//! @param lnbs e
//! @param nbs ve
//! @return Ftrue@sFfalse
//! @attention vC[ɂ闠ZiF6EF7jpɗpӂꂽ֐łB֒eIꂽꍇAIɒe[܂B
//! @attention gpĂȂIuWFNgɑ΂ĎsƁÅ֐͎s܂B
bool weapon::ResetWeaponParam(class ResourceManager *Resource, int id_param, int lnbs, int nbs)
{
	//ĂȂ΁As
	if( EnableFlag == false ){ return false; }

	//w肳ꂽݒl֏㏑
	id_parameter = id_param;
	bullets = nbs;
	Loadbullets = lnbs;

	//֒eȂ΁A[h
	if( id_param == ID_WEAPON_GRENADE ){
		if( (bullets > 0)&&(Loadbullets == 0) ){
			Loadbullets = 1;
		}
	}

	//fƃeNX`ݒ
	Resource->GetWeaponModelTexture(id_param, &id_model, &id_texture);
	WeaponParameter param;
	if( Param->GetWeapon(id_param, &param) == 0 ){
		model_size = param.size;
	}

	return true;
}

//! @brief vZsiRj
//! @param CollD Collisioñ|C^
int weapon::RunFrame(class Collision *CollD)
{
	//NXݒ肳ĂȂΎs
	if( CollD == NULL ){ return 0; }

	//ĂȂ΁As
	if( EnableFlag == false ){ return 0; }

	//NɂgĂ炸AړtOLȂ΁`
	if( (usingflag == false)&&(motionflag == true) ){
		float Dist;
		float maxDist;

		//ړxXV
		move_x *= 0.96f;
		move_z *= 0.96f;
		if( move_y > -1.8f ){
			move_y -= 0.3f;
		}

		//ubNɖ܂ĂΏȂ
		if( CollD->CheckALLBlockInside(pos_x, pos_y, pos_z) == true ){
			motionflag = false;
			return 0;
		}

		//̈ړx߂
		maxDist = sqrt(move_x*move_x + move_z*move_z);
		if( maxDist < 0.1f ){
			maxDist = 0.0f;
			move_x = 0.0f;
			move_z = 0.0f;
		}

		//ubNɐڂĂ΁Aȏ͐ړȂB
		if( maxDist > 0.0f ){
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y, pos_z, move_x/maxDist, 0, move_z/maxDist, NULL, NULL, &Dist, maxDist) == true ){
				//ubNɖ܂Ȃ悤ɎO
				Dist -= 0.1f;

				//ڂĂW܂ňړ
				pos_x += move_x/maxDist * Dist;
				pos_z += move_z/maxDist * Dist;

				//ړʂ 0 
				move_x = 0.0f;
				move_z = 0.0f;
			}
		}

		//ubNɐڂĂ΁A܂ŗ
		if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y, pos_z, 0, -1, 0, NULL, NULL, &Dist, fabs(move_y)) == true ){
			CollD->CheckALLBlockIntersectRay(pos_x, pos_y, pos_z, 0, -1, 0, NULL, NULL, &Dist, fabs(move_y));
			pos_y -= Dist - 0.2f;
			motionflag = false;
			return 0;
		}

		//W𔽉f
		pos_x += move_x;
		pos_y += move_y;
		pos_z += move_z;
	}

	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void weapon::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂANɎgĂΏȂ
	if( EnableFlag == false ){ return; }
	if( usingflag == true ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, 0.0f, (float)M_PI/2, model_size);
	d3dg->RenderModel(id_model, id_texture, DarkModelFlag);
}

//! @brief RXgN^
smallobject::smallobject(class ParameterInfo *in_Param, class MIFInterface *in_MIFdata, float x, float y, float z, float rx, int id_param, signed char p4, bool flag)
{
	Param = in_Param;
	MIFdata = in_MIFdata;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	rotation_y = 0.0f;
	EnableFlag = flag;
	model_size = 5.0f;

	id_parameter = id_param;
	point_p4 = p4;

	hp = 0;		//b
	jump_rx = 0.0f;
	move_rx = 0.0f;
	add_rx = 0.0f;
	add_ry = 0.0f;
	jump_cnt = 0;

	if( Param != NULL ){
		SmallObjectParameter ParamData;
		if( Param->GetSmallObject(id_param, &ParamData) == 0 ){
			hp = ParamData.hp;
		}
	}
	id_model = -1;
	id_texture = -1;
}

//! @brief fBXgN^
smallobject::~smallobject()
{}

//! @brief MIFf[^ǗNXݒ
//! @param in_MIFdata MIFInterfaceNX̃|C^
void smallobject::SetMIFInterfaceClass(class MIFInterface *in_MIFdata)
{
	MIFdata = in_MIFdata;
}

//! @brief ݒlݒ
//! @param id_param ̎ޔԍ
//! @param p4 4p[^
//! @param init IuWFNg
void smallobject::SetParamData(int id_param, signed char p4, bool init)
{
	rotation_y = 0.0f;
	id_parameter = id_param;
	point_p4 = p4;

	if( init == true ){
		hp = 0;		//b
		jump_rx = 0.0f;
		move_rx = 0.0f;
		add_rx = 0.0f;
		add_ry = 0.0f;
		jump_cnt = 0;

		if( (TOTAL_PARAMETERINFO_SMALLOBJECT <= id_param)&&(id_param <= (TOTAL_PARAMETERINFO_SMALLOBJECT + MAX_ADDSMALLOBJECT -1)) ){
			if( MIFdata != NULL ){
				hp = MIFdata->GetAddSmallobjectHP(id_param - TOTAL_PARAMETERINFO_SMALLOBJECT);
			}
		}
		else{
			if( Param != NULL ){
				SmallObjectParameter ParamData;
				if( Param->GetSmallObject(id_param, &ParamData) == 0 ){
					hp = ParamData.hp;
				}
			}
		}
	}
}

//! @brief ݒl擾
//! @param id_param ̎ޔԍ󂯎|C^iNULLj
//! @param p4 4p[^󂯎|C^iNULLj
void smallobject::GetParamData(int *id_param, signed char *p4)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( p4 != NULL ){ *p4 = point_p4; }
}

//! @brief ̗͂擾
//! @return ̗͒l
int smallobject::GetHP()
{
	return hp;
}

//! @brief ubN̏Ɉړ
//! @param CollD Collisioñ|C^
//! @return ̍Ẅړʁi0ňړȂj
//! @attention ubNɖ܂ĂꍇłÃubN܂ 蔲܂B
float smallobject::CollisionMap(class Collision *CollD)
{
	//NXݒ肳ĂȂΎs
	if( CollD == NULL ){ return 0.0f; }

	float Dist;
	SmallObjectParameter ParamData;

	//ɓ蔻
	if( CollD->CheckALLBlockIntersectRay(pos_x, pos_y + COLLISION_ADDSIZE, pos_z, 0, -1, 0, NULL, NULL, &Dist, 1000.0f) == true ){
		//蔻̑傫擾
		if( (TOTAL_PARAMETERINFO_SMALLOBJECT <= id_parameter)&&(id_parameter <= (TOTAL_PARAMETERINFO_SMALLOBJECT + MAX_ADDSMALLOBJECT -1)) ){
			Dist -= (float)MIFdata->GetAddSmallobjectDecide(id_parameter - TOTAL_PARAMETERINFO_SMALLOBJECT)/10.0f;
		}
		else{
			if( Param->GetSmallObject(id_parameter, &ParamData) == 0 ){
				Dist -= (float)ParamData.decide/10.0f;
			}
		}

		//Wړ
		pos_y -= Dist;
		return Dist;
	}

	return 0.0f;
}

//! @brief eqbg
//! @param attacks e̍U
void smallobject::HitBullet(int attacks)
{
	hp -= attacks;
	if( hp <= 0 ){
		Destruction();
	}
}

//! @brief ֒e̔qbg
//! @param attacks ̍U
//! @attention ɂvZOɍς܂ĂB
void smallobject::HitGrenadeExplosion(int attacks)
{
	hp -= attacks;
	if( hp <= 0 ){
		Destruction();
	}
}

//! @brief j󂷂
//! @attention ʏ HitBullet()֐  GrenadeExplosion()֐ 玩IɎs邽߁AڌĂяoKv͂܂B
void smallobject::Destruction()
{
	//EnableFlag = false;
	//return;

	int jump;

	//ы擾
	if( (TOTAL_PARAMETERINFO_SMALLOBJECT <= id_parameter)&&(id_parameter <= (TOTAL_PARAMETERINFO_SMALLOBJECT + MAX_ADDSMALLOBJECT -1)) ){
		jump = MIFdata->GetAddSmallobjectJump(id_parameter - TOTAL_PARAMETERINFO_SMALLOBJECT);
	}
	else{
		SmallObjectParameter paramdata;
		Param->GetSmallObject(id_parameter, &paramdata);
		jump = paramdata.jump;
	}

	//΂
	hp = 0;
	jump_cnt = jump;

	//pݒ
	jump_rx = DegreeToRadian(10) * GetRand(36);
	move_rx = (float)jump * 0.04243f;
	add_rx = DegreeToRadian(1) * GetRand(20);
	add_ry = DegreeToRadian(1) * GetRand(20);
}

//! @brief vZsij󎞂̈ړȂǁj
int smallobject::RunFrame()
{
	//`悳ĂȂA̗͂cĂȂΏȂB
	if( EnableFlag == false ){ return 0; }
	if( hp > 0 ){ return 0; }

	int cnt;
	int jump;

	//ы擾
	if( (TOTAL_PARAMETERINFO_SMALLOBJECT <= id_parameter)&&(id_parameter <= (TOTAL_PARAMETERINFO_SMALLOBJECT + MAX_ADDSMALLOBJECT -1)) ){
		jump = MIFdata->GetAddSmallobjectJump(id_parameter - TOTAL_PARAMETERINFO_SMALLOBJECT);
	}
	else{
		SmallObjectParameter paramdata;
		Param->GetSmallObject(id_parameter, &paramdata);
		jump = paramdata.jump;
	}
	
	//łJEgvZ
	cnt = jump - jump_cnt;

	//pWEpxvZ
	pos_x += cos(jump_rx) * move_rx;
	pos_y += jump_cnt * 0.1f;
	pos_z += sin(jump_rx) * move_rx;
	rotation_x += add_rx;
	rotation_y += add_ry;

	jump_cnt -= 1;

	//1bł`I
	if( cnt > (int)GAMEFPS ){
		EnableFlag = false;
		return 2;
	}

	return 1;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void smallobject::Render(D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( EnableFlag == false ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, rotation_y, model_size);
	d3dg->RenderModel(id_model, id_texture, DarkModelFlag);
}

//! @brief RXgN^
bullet::bullet(int modelid, int textureid)
{
	model_size = 1.0f;
	id_model = modelid;
	id_texture = textureid;
	EnableFlag = false;
}

//! @brief fBXgN^
bullet::~bullet()
{}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
//! @param ry c]
void bullet::SetPosData(float x, float y, float z, float rx, float ry)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	rotation_y = ry;
}

//! @brief ݒlݒ
//! @param _attacks U
//! @param _penetration ђʗ
//! @param _speed e
//! @param _teamid `[ԍ
//! @param _humanid l̃f[^ԍ
//! @param _ontargetcnt ̃JEg
//! @param init IuWFNg
void bullet::SetParamData(int _attacks, int _penetration, int _speed, int _teamid, int _humanid, float _ontargetcnt, bool init)
{
	attacks = _attacks;
	penetration = _penetration;
	speed = _speed;
	teamid = _teamid;
	humanid = _humanid;
	ontargetcnt = _ontargetcnt;

	if( init == true ){
		cnt = 0;
	}
}

//! @brief WƊpx擾
//! @param x XW󂯎|C^iNULLj
//! @param y YW󂯎|C^iNULLj
//! @param z ZW󂯎|C^iNULLj
//! @param rx ]󂯎|C^iNULLj
//! @param ry c]󂯎|C^iNULLj
void bullet::GetPosData(float *x, float *y, float *z, float *rx, float *ry)
{
	if( x != NULL ){ *x = pos_x; }
	if( y != NULL ){ *y = pos_y; }
	if( z != NULL ){ *z = pos_z; }
	if( rx != NULL ){ *rx = rotation_x; }
	if( ry != NULL ){ *ry = rotation_y; }
}

//! @brief ݒl擾
//! @param _attacks U͂󂯎|C^iNULLj
//! @param _penetration ђʗ͂󂯎|C^iNULLj
//! @param _speed e󂯎|C^iNULLj
//! @param _teamid `[ԍ󂯎|C^iNULLj
//! @param _humanid l̃f[^ԍ󂯎|C^iNULLj
//! @param _ontargetcnt ̃JEg󂯎|C^iNULLj
void bullet::GetParamData(int *_attacks, int *_penetration, int *_speed, int *_teamid, int *_humanid, float *_ontargetcnt)
{
	if( _attacks != NULL ){ *_attacks = attacks; }
	if( _penetration != NULL ){ *_penetration = penetration; }
	if( _speed != NULL ){ *_speed = speed; }
	if( _teamid != NULL ){ *_teamid = teamid; }
	if( _humanid != NULL ){ *_humanid = humanid; }
	if( _ontargetcnt != NULL ){ *_ontargetcnt = ontargetcnt; }
}

//! @brief vZsie̐isEԏŁj
int bullet::RunFrame()
{
	//ĂȂΏȂ
	if( EnableFlag == false ){ return 0; }

	//ŎԂ߂Ă΁AIuWFNg𖳌
	if( cnt > BULLET_DESTROYFRAME ){
		EnableFlag = false;
		return 0;
	}

	//ړ
	pos_x += cos(rotation_x)*cos(rotation_y)*speed;
	pos_y += sin(rotation_y)*speed;
	pos_z += sin(rotation_x)*cos(rotation_y)*speed;
	cnt += 1;

	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void bullet::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( EnableFlag == false ){ return; }

	//eړO`悵Ȃ
	//@e˂Č΍
	if( cnt == 0 ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, (rotation_x * -1 - (float)M_PI/2), rotation_y, model_size);
	d3dg->RenderModel(id_model, id_texture, false);
}

//! @brief RXgN^
grenade::grenade(int modelid, int textureid) : bullet(modelid, textureid)
{
	if( Param != NULL ){
		WeaponParameter ParamData;
		if( Param->GetWeapon(ID_WEAPON_GRENADE, &ParamData) == 0 ){
			model_size = ParamData.size;
		}
	}
}

//! @brief fBXgN^
grenade::~grenade()
{}

//! @brief WƏݒ
//! @param speed 
//! @param _teamid `[ԍ
//! @param _humanid l̃f[^ԍ
//! @param _ontargetcnt ̃JEg
//! @param init IuWFNg
//! @attention  SetPosData() sĂB
void grenade::SetParamData(float speed, int _teamid, int _humanid, float _ontargetcnt, bool init)
{
	move_x = cos(rotation_x) * cos(rotation_y) * speed;
	move_y = sin(rotation_y) * speed;
	move_z = sin(rotation_x) * cos(rotation_y) * speed;
	teamid = _teamid;
	humanid = _humanid;
	ontargetcnt = _ontargetcnt;

	if( init == true ){
		cnt = 0;
	}
}

//! @brief ݒl擾
//! @param _speed x󂯎|C^iNULLj
//! @param _teamid `[ԍ󂯎|C^iNULLj
//! @param _humanid l̃f[^ԍ󂯎|C^iNULLj
//! @param _ontargetcnt ̃JEg󂯎|C^iNULLj
void grenade::GetParamData(float *_speed, int *_teamid, int *_humanid, float *_ontargetcnt)
{
	if( _speed != NULL ){ *_speed = GetSpeed(); }
	if( _teamid != NULL ){ *_teamid = teamid; }
	if( _humanid != NULL ){ *_humanid = humanid; }
	if( _ontargetcnt != NULL ){ *_ontargetcnt = ontargetcnt; }
}

//! @brief x擾
//! @return x
float grenade::GetSpeed()
{
	return sqrt(move_x*move_x + move_y*move_y + move_z*move_z);
}

//! @brief vZsi֒e̐isEj
//! @return F2@oEhE˕ԂF1@ȊOF0
int grenade::RunFrame(class Collision *CollD)
{
	//ĂȂΏȂ
	if( EnableFlag == false ){ return 0; }

	//Ԃ߂Ă΁AIuWFNg𖳌AuvƂĕԂB
	if( cnt > GRENADE_DESTROYFRAME ){
		EnableFlag = false;
		return 2;
	}

	//Î~ĂΏȂ
	if( (move_x == 0.0f)&&(move_y == 0.0f)&&(move_z == 0.0f) ){
		cnt += 1;
		return 0;
	}

	int id, face;
	float Dist;
	float maxDist = sqrt(move_x*move_x + move_y*move_y + move_z*move_z);

	//}bvɑ΂ē蔻s
	if( CollD->CheckALLBlockIntersectRay(pos_x, pos_y, pos_z, move_x/maxDist, move_y/maxDist, move_z/maxDist, &id, &face, &Dist, maxDist) == true ){
		//Փ˂Ăꍇ`

		float Angle, Acceleration;
		float vx, vy, vz;

		//px߂
		CollD->AngleVector(id, face, move_x, move_y, move_z, &Angle);

		//˂xNg߂
		CollD->ReflectVector(id, face, move_x, move_y, move_z, &vx, &vy, &vz);

		//߂
		Acceleration = Angle*-1 * 0.2546f + 0.7f;

		// and 
		move_x = vx * Acceleration;
		move_y = vy * Acceleration;
		move_z = vz * Acceleration;

		//@Փ˂uԁit[j́AړȂB

		//ړxvZ
		move_x *= 0.98f;
		move_y = (move_y - 0.17f) * 0.98f;
		move_z *= 0.98f;

		cnt += 1;
		return 1;
	}

	//Wړ
	pos_x += move_x;
	pos_y += move_y;
	pos_z += move_z;

	//ړxvZ
	move_x *= 0.98f;
	move_y = (move_y - 0.17f) * 0.98f;
	move_z *= 0.98f;

	cnt += 1;
	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void grenade::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( EnableFlag == false ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, (rotation_x * -1 - (float)M_PI/2), 0.0f, (float)M_PI/2, model_size);
	d3dg->RenderModel(id_model, id_texture, DarkModelFlag);
}

//! @brief RXgN^
effect::effect(float x, float y, float z, float size, float rotation, int count, int texture, int settype)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	model_size = size;
	rotation_x = 0.0f;
	rotation_y = 0.0f;
	rotation_texture = rotation;
	cnt = count;
	setcnt = count;
	id_texture = texture;
	type = settype;
	if( cnt > 0 ){
		EnableFlag = true;
	}
	else{
		EnableFlag = false;
	}
	alpha = 1.0f;
}

//! @brief fBXgN^
effect::~effect()
{}

//! @brief ݒlݒ
//! @param in_move_x Xړ
//! @param in_move_y Yړ
//! @param in_move_z Zړ
//! @param size `{
//! @param rotation ]px
//! @param count `t[
//! @param texture eNX`̔Fԍ
//! @param settype GtFNg̎ށ@iEffect_Type gݍj
//! @param init IuWFNg
void effect::SetParamData(float in_move_x, float in_move_y, float in_move_z, float size, float rotation, int count, int texture, int settype, bool init)
{
	move_x = in_move_x;
	move_y = in_move_y;
	move_z = in_move_z;
	model_size = size;
	rotation_texture = rotation;
	cnt = count;
	setcnt = count;
	id_texture = texture;
	type = settype;

	if( type & EFFECT_TRANSLUCENT ){
		set_alpha = 0.5f;
	}
	else{
		set_alpha = 1.0f;
	}
	alpha = set_alpha;

	if( init == true ){
		rotation_x = 0.0f;
		rotation_y = 0.0f;
	}
}

//! @brief Əčݒ
//! @param rx ݒ肷鉡
//! @param ry ݒ肷c
void effect::SetRxRy(float rx, float ry)
{
	rotation_x = rx;
	rotation_y = ry;
}

//! eNX`Fԍ擾
//! @return eNX`Fԍ
int effect::GetTextureID()
{
	return id_texture;
}

//! GtFNg̈ړʂ擾
//! @param mx Xړʂ󂯎|C^
//! @param my Yړʂ󂯎|C^
//! @param mz Zړʂ󂯎|C^
void effect::GetMove(float *mx, float *my, float *mz)
{
	*mx = move_x;
	*my = move_y;
	*mz = move_z;
}

//! GtFNg̃}bv蔻tO擾
//! @return LFtrue@Ffalse
bool effect::GetCollideMapFlag()
{
	if( type&EFFECT_COLLIDEMAP ){
		return true;
	}
	//else{
		return false;
	//}
}

//! @brief vZsir{[hj
//! @param camera_rx J̉px
//! @param camera_ry J̏cpx
//! @return sF1@`ŏIt[F2@ȂF0
int effect::RunFrame(float camera_rx, float camera_ry)
{
	//ĂȂΏȂ
	if( EnableFlag == false ){ return 0; }

	//JEgIAȂ悤ɐݒ
	if( cnt <= 0 ){
		EnableFlag = false;
		return 2;
	}

	if( (type & EFFECT_NOBILLBOARD) == 0 ){
		//JWKpAr{[h
		rotation_x = camera_rx*-1;
		rotation_y = camera_ry;
	}

	//Wړ
	pos_x += move_x;
	pos_y += move_y;
	pos_z += move_z;

	//ꏈs
	if( type & EFFECT_DISAPPEAR ){	//
		alpha -= set_alpha/setcnt;
	}
	if( type & EFFECT_DISAPPEARHALF ){	//̎Ԃŏ
		if( setcnt/2 > cnt ){
			alpha -= set_alpha/(setcnt/2);
		}
	}
	if( type & EFFECT_MAGNIFY ){	//g
		model_size += model_size/50;
	}
	if( type & EFFECT_ROTATION ){	//]
		if( rotation_texture > 0.0f ){
			rotation_texture += DegreeToRadian(1);
		}
		else{
			rotation_texture -= DegreeToRadian(1);
		}
	}
	if( type & EFFECT_FALL ){		//
		move_y = (move_y - 0.17f) * 0.98f;
	}

	//JEg 1 
	cnt -= 1;
	return 1;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void effect::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( EnableFlag == false ){ return; }

	//`
	d3dg->SetWorldTransformEffect(pos_x, pos_y, pos_z, rotation_x, rotation_y, rotation_texture, model_size);
	d3dg->RenderBoard(id_texture, alpha);
}

//! @brief RXgN^
HumanMotionControl::HumanMotionControl(class ParameterInfo *in_Param)
{
	Param = in_Param;

	id_upmodel = -1;
	for(int i=0; i<TOTAL_ARMMODE; i++){
		id_armmodel[i] = -1;
	}
	id_legmodel = -1;
	for(int i=0; i<TOTAL_WALKMODE; i++){
		id_walkmodel[i] = -1;
	}
	for(int i=0; i<TOTAL_RUNMODE; i++){
		id_runmodel[i] = -1;
	}

	reaction_y = 0.0f;
	armmodel_rotation_y = 0.0f;
	legrotation_x = 0.0f;
	walkcnt = 0;
	runcnt = 0;
	armmodelid = -1;
	legmodelid = -1;
}

//! @brief fBXgN^
HumanMotionControl::~HumanMotionControl()
{}

//! @brief ݒlǗNXo^
//! @attention e֐gpOɎs邱ƁB
void HumanMotionControl::SetParameterInfoClass(class ParameterInfo *in_Param)
{
	Param = in_Param;
}

//! @brief ff[^ݒ
//! @param upmodel 㔼g̃f
//! @param armmodel[] r̃f̔ziz񐔁FTOTAL_ARMMODEj
//! @param legmodel iÎ~ԁj̃f
//! @param walkmodel[] r̃f̔ziz񐔁FTOTAL_WALKMODEj
//! @param runmodel[] r̃f̔ziz񐔁FTOTAL_RUNMODEj
void HumanMotionControl::SetModel(int upmodel, int armmodel[], int legmodel, int walkmodel[], int runmodel[])
{
	id_upmodel = upmodel;
	for(int i=0; i<TOTAL_ARMMODE; i++){
		id_armmodel[i] = armmodel[i];
	}
	id_legmodel = legmodel;
	for(int i=0; i<TOTAL_WALKMODE; i++){
		id_walkmodel[i] = walkmodel[i];
	}
	for(int i=0; i<TOTAL_RUNMODE; i++){
		id_runmodel[i] = runmodel[i];
	}
}

//! @brief n֐
//! @param rx ]px
void HumanMotionControl::Init(float rx)
{
	reaction_y = 0.0f;
	armmodel_rotation_y = 0.0f;
	legrotation_x = rx;
	walkcnt = 0;
	runcnt = 0;
	armmodelid = -1;
	legmodelid = -1;
}

//! @brief E
//! @param weapon_paramid ̎ޔԍ
void HumanMotionControl::PickupWeapon(int weapon_paramid)
{
	//gp΍
	UNREFERENCED_PARAMETER(weapon_paramid);

	//r̊pxijݒ
	reaction_y = DegreeToRadian(-20);
}

//! @brief ؂ւiւj
//! @param weapon_paramid ̎ޔԍ
void HumanMotionControl::ChangeWeapon(int weapon_paramid)
{
	//gp΍
	UNREFERENCED_PARAMETER(weapon_paramid);

	//r̊pxijݒ
	reaction_y = DegreeToRadian(-20);
}

//! @brief C
//! @param weapon_paramid ̎ޔԍ
void HumanMotionControl::ShotWeapon(int weapon_paramid)
{
	//rɔ`
	if( weapon_paramid == ID_WEAPON_GRENADE ){
		reaction_y = DegreeToRadian(20);
	}
	else{
		//̐ݒl擾
		WeaponParameter ParamData;
		if( Param->GetWeapon(weapon_paramid, &ParamData) != 0 ){ return; }

		reaction_y = DegreeToRadian(0.5f) * ParamData.reaction;
	}
}

//! @brief [h
//! @param weapon_paramid ̎ޔԍ
//! @attention ̊֐͊gp̃_~[֐łB
void HumanMotionControl::ReloadWeapon(int weapon_paramid)
{
	//gp΍
	UNREFERENCED_PARAMETER(weapon_paramid);
}

//! @brief ̂Ă
//! @attention ̊֐͊gp̃_~[֐łB
void HumanMotionControl::DumpWeapon()
{
	//
}

//! @brief ̃Vbg[h؂ւ
//! @param weapon_paramid ̎ޔԍ
//! @attention ̊֐͊gp̃_~[֐łB
void HumanMotionControl::ChangeShotMode(int weapon_paramid)
{
	//gp΍
	UNREFERENCED_PARAMETER(weapon_paramid);
}

//! @brief Wv
//! @attention ̊֐͊gp̃_~[֐łB
void HumanMotionControl::Jump()
{
	//
}

//! @brief [VvZs
//! @attention rotation_x ̑Ŝ̉]px
//! @attention armrotation_y r̉]px
//! @attention weapon_paramid ̎ޔԍ
//! @attention ReloadCnt ̃[hJEg
//! @attention MoveFlag ړ\tO
//! @attention hp ̗
//! @attention PlayerFlag vC[ǂ
void HumanMotionControl::RunFrame(float rotation_x, float armrotation_y, int weapon_paramid, int ReloadCnt, int MoveFlag, int hp, bool PlayerFlag)
{
	int ArmModelID;
	float move_rx;

	//CȂǂɂ锽
	if( reaction_y > 0.0f ){
		if( reaction_y > DegreeToRadian(2) ){ reaction_y -= DegreeToRadian(2); }
		else{ reaction_y = 0.0f; }
	}
	if( reaction_y < 0.0f ){
		if( reaction_y < DegreeToRadian(2) ){ reaction_y += DegreeToRadian(2); }
		else{ reaction_y = 0.0f; }
	}

	//[hȂr̊pxĐݒ
	if( ReloadCnt > 0 ){
		reaction_y = ARMRAD_RELOADWEAPON;
	}

	if( weapon_paramid == ID_WEAPON_NONE ){	//Ԃ
		if( PlayerFlag == true ){
			armmodel_rotation_y = ARMRAD_NOWEAPON;
		}
		else{
			armmodel_rotation_y = armrotation_y;
		}
		ArmModelID = 0;
	}
	else{							//Ă
		//̏擾
		WeaponParameter paramdata;
		Param->GetWeapon(weapon_paramid, &paramdata);

		armmodel_rotation_y = 0.0f;
		ArmModelID = 0;

		//ř`Ɗpx
		if( paramdata.WeaponP == 0 ){
			armmodel_rotation_y = armrotation_y + reaction_y;
			ArmModelID = 1;
		}
		if( paramdata.WeaponP == 1 ){
			armmodel_rotation_y = armrotation_y + reaction_y;
			ArmModelID = 2;
		}
		if( paramdata.WeaponP == 2 ){
			armmodel_rotation_y = ARMRAD_NOWEAPON;
			ArmModelID = 0;
		}
	}

	//is
	if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
		move_rx = DegreeToRadian(0);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_FORWARD ){
		move_rx = DegreeToRadian(0);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_BACK ){
		move_rx = DegreeToRadian(180);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_LEFT ){
		move_rx = DegreeToRadian(90);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_RIGHT ){
		move_rx = DegreeToRadian(-90);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_LEFT) ){
		move_rx = DegreeToRadian(45);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_LEFT) ){
		move_rx = DegreeToRadian(135);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_RIGHT) ){
		move_rx = DegreeToRadian(-135);
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_RIGHT) ){
		move_rx = DegreeToRadian(-45);
	}
	else{
		move_rx = 0.0f;
	}

	//̊pxZo
	if( hp <= 0 ){
		legrotation_x = rotation_x;
	}
	else{
		float move_rx2;

		//̌߂
		if( fabs(move_rx) > DegreeToRadian(90)){
			move_rx2 = move_rx + (float)M_PI;
		}
		else{
			move_rx2 = move_rx;
		}
		for(; move_rx2 > (float)M_PI; move_rx2 -= (float)M_PI*2){}
		for(; move_rx2 < (float)M_PI*-1; move_rx2 += (float)M_PI*2){}

		//Xɂ̌
		legrotation_x = legrotation_x*0.85f + (rotation_x + move_rx2*-1)*0.15f;		// 3/4 + 1/4
	}

	//r̃fݒ
	armmodelid = id_armmodel[ArmModelID];

	//̃fݒ
	legmodelid = id_legmodel;	//~܂
	if( hp > 0 ){
		if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
			legmodelid = id_walkmodel[ (walkcnt/3 % TOTAL_WALKMODE) ];	//
			walkcnt += 1;
			runcnt = 0;
		}
		else{
			if( GetFlag(MoveFlag, (MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
				legmodelid = id_runmodel[ (runcnt/3 % TOTAL_RUNMODE) ];		//E
			}
			if( GetFlag(MoveFlag, MOVEFLAG_FORWARD) ){
				legmodelid = id_runmodel[ (runcnt/2 % TOTAL_RUNMODE) ];		//O
			}
			if( GetFlag(MoveFlag, MOVEFLAG_BACK) ){
				legmodelid = id_runmodel[ (runcnt/4 % TOTAL_RUNMODE) ];		//둖
			}
			walkcnt = 0;
			runcnt += 1;
		}
	}
}

//! @brief [V擾
//! @param arm_rotation_y r̊px擾|C^
//! @param leg_rotation_x ̊px擾|C^
//! @param upmodel 㔼g̃fFԍ擾|C^
//! @param armmodel r̃fFԍ擾|C^
//! @param legmodel ̃fFԍ擾|C^
void HumanMotionControl::GetRenderMotion(float *arm_rotation_y, float *leg_rotation_x, int *upmodel, int *armmodel, int *legmodel)
{
	*arm_rotation_y = armmodel_rotation_y;
	*leg_rotation_x = legrotation_x;

	*upmodel = id_upmodel;
	*armmodel = armmodelid;
	*legmodel = legmodelid;
}