//! @file sound-directsound.cpp
//! @brief SoundControlNX̒`iDirectSoundŁj

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2019, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "sound.h"

#ifdef SOUND_DIRECTSOUND

//! @brief RXgN^
SoundControl::SoundControl()
{
	pDSound = NULL;
}

//! @brief fBXgN^
SoundControl::~SoundControl()
{
	DestroySound();
}

//! @brief 
//! @param WindowCtrl WindowControlNX̃|C^
//! @return F0@sF1
int SoundControl::InitSound(WindowControl *WindowCtrl)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_INIT, "TEh", "DirectSound");
#endif

	//DirectSoundIuWFNg𐶐
	if( FAILED( DirectSoundCreate8(NULL, &pDSound, NULL) ) ){
		return 1;
	}

	//x̐ݒ
	if( FAILED( pDSound->SetCooperativeLevel(WindowCtrl->GethWnd(), DSSCL_EXCLUSIVE) ) ){
		return 1;
	}

	//vC} obt@쐬AXi[C^[tFCX擾
	LPDIRECTSOUNDBUFFER pPrimary;
	DSBUFFERDESC dsbd;
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = DSBCAPS_CTRL3D | DSBCAPS_PRIMARYBUFFER;
	if( SUCCEEDED(pDSound->CreateSoundBuffer(&dsbd, &pPrimary, NULL)) ){
		pPrimary->QueryInterface(IID_IDirectSound3DListener8, (LPVOID *)&p3DListener);
		pPrimary->Release();
	}

	//hbv[ʂ𖳌
	p3DListener->SetDopplerFactor(DS3D_MINDOPPLERFACTOR, DS3D_IMMEDIATE);

	//[EItixjݒ
	p3DListener->SetRolloffFactor(0.05f, DS3D_IMMEDIATE);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	return 0;
}

//! @brief 
//! @attention {֐͎IɌĂяo܂AIɌĂяoƂ\łB
void SoundControl::DestroySound()
{
	if( pDSound == NULL ){ return; }

	for(int i=0;i<MAX_LOADSOUND; i++){
		for(int j=0; j<MAX_SOUNDLISTS; j++){
			if( pDSBuffer[i][j] != NULL ){
				pDSBuffer[i][j]->Release();
				pDSBuffer[i][j] = NULL;
			}
		}
	}
	if( pDSound != NULL ){
		pDSound->Release();
		pDSound = NULL;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "TEh", "DirectSound");
#endif
}

//! @brief Đʂݒ
//! @param volume Đʁ@i0.0@1.0100%j
void SoundControl::SetVolume(float volume)
{
	mastervolume = volume;
}

//! @brief J̍WƊpxݒ
//! @param x JXW
//! @param y JYW
//! @param z JZW
//! @param rx JXpx@i\j
//! @warning t[ĂяoāAŐṼJWݒiKpjĂB
void SoundControl::SetCamera(float x, float y, float z, float rx)
{
	p3DListener->SetPosition(x, y, z, DS3D_IMMEDIATE);
	p3DListener->SetOrientation(cos(rx), 0.0f, sin(rx), 0.0f, 1.0f, 0.0f, DS3D_IMMEDIATE);
}

//! @brief TEhǂݍ
//! @param filename t@C
//! @return F0ȏ̔Fԍ@sF-1
//! @attention 2`liXeIjf[^w肳ꂽꍇAẼf[^擾Ãf[^͖܂B
int SoundControl::LoadSound(char* filename)
{
	if( pDSound == NULL ){ return -1; }

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "TEh", filename);
#endif

	//JĂԍT
	int id=0;
	for(id=0; id<MAX_LOADSOUND; id++){
		if( pDSBuffer[id][0] == NULL ){ break; }
	}
	if( id == MAX_LOADSOUND ){ return -1; }

	WAVEFORMATEX* pwfex;
	int WavSize = 0;
	int Wavoffset = 0;
	bool d2channels = false;

	//Wavet@C̏擾
	if( CheckSoundFile(filename, &WavSize, &Wavoffset, &pwfex) == true ){
		return -1;
	}
	pwfex->cbSize = 0;

	//XeIf[^Ȃ
	if( pwfex->nChannels == 2 ){
		d2channels = true;		//tOݒ
		WavSize /= 2;			//TCY𔼕

		//mƂċIɍČvZ
		pwfex->nChannels = 1;
		pwfex->nAvgBytesPerSec /= 2;
		pwfex->nBlockAlign /= 2;
	}

	// DirectSoundZJ_[obt@[쐬
	DSBUFFERDESC dsbd;  
	ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = DSBCAPS_CTRL3D | DSBCAPS_CTRLVOLUME;
	dsbd.dwBufferBytes = WavSize;
	dsbd.guid3DAlgorithm = DS3DALG_NO_VIRTUALIZATION;
	dsbd.lpwfxFormat = pwfex;
	if( FAILED( pDSound->CreateSoundBuffer(&dsbd, &pDSBuffer[id][0], NULL) ) ){
		return -1;	//ZJ_obt@[쐬s
	}

	//bN
	VOID* pBuffer = NULL;
	DWORD dwBufferSize = 0; 
	if( FAILED(pDSBuffer[id][0]->Lock(0, WavSize, &pBuffer, &dwBufferSize, NULL, NULL, 0) ) ){
		return -1;	//obt@̃bNs
	}

	//ꎞ̈m
	BYTE* pWavData;
	int dwSize = dwBufferSize;
	if( dwSize > WavSize ){ dwSize = WavSize; }
	if( d2channels == true ){
		dwSize = dwSize * 2;
	}
	pWavData = new BYTE[dwSize];
	if( pWavData == NULL ){
		//WAVEt@Cǂݍރ[mۂłȂ
		return -1;
	}

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	filename = ChangePathDelimiter(filename);
#endif

	//g`f[^荞
	FILE* fp;
	fp = fopen(filename, "rb");
	fseek(fp, Wavoffset, SEEK_SET);
	fread(pWavData, 1, dwSize, fp);
	fclose(fp);

	//ꎞ̈悩ZJ_obt@[փRs[
	if( d2channels == false ){
		//mf[^Ȃ1oCgÂRs[
		for(int i=0; i<dwSize; i++){
			*((BYTE*)pBuffer+i) = *((BYTE*) pWavData+i);
		}
	}
	else{
		//TvOoCg擾
		int samplingbytes = pwfex->wBitsPerSample/2;
		
		//XeIf[^ȂAẼf[^i[
		int byte = 0;
		for(int i=0; i<dwSize; i++){
			*((BYTE*)pBuffer+byte) = *((BYTE*) pWavData+i);
			byte += 1;
			if( i%samplingbytes == samplingbytes-1 ){ i += samplingbytes; }		//̃f[^̓XLbv
		}
	}

	//bN
	pDSBuffer[id][0]->Unlock(pBuffer, dwBufferSize, NULL, 0);

	//ꎞ̈
	delete pWavData;

	//tH[}bg
	delete pwfex;

	//ZJ_obt@[̃Rs[쐬
	for(int i=1; i<MAX_SOUNDLISTS; i++){
		if( pDSound->DuplicateSoundBuffer(pDSBuffer[id][0], &(pDSBuffer[id][i])) != DS_OK ){
			CleanupSound(id);
			return -1;
		}
	}

	//ʍŏňxĐĂ
	pDSBuffer[id][0]->SetVolume(DSBVOLUME_MIN);
	pDSBuffer[id][0]->Play(NULL, 0, NULL);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", id);
#endif

	return id;
}

//! @brief TEhĐi3DĐj
//! @param id Fԍ
//! @param volume Đ{[
//! @param pan 
//! @return F1@sF0
//! @note prFvC[g鉹EQ[ԑŜŋψɖ炷EBGM
int SoundControl::PlaySound(int id, int volume, int pan)
{
	if( pDSound == NULL ){ return 0; }
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return 0; }
	if( pDSBuffer[id][0] == NULL ){ return 0; }

	DWORD status = 0;

	for(int i=0; i<MAX_SOUNDLISTS; i++){
		//Đ󋵂擾
		pDSBuffer[id][i]->GetStatus(&status);

		//TEh~Ȃ
		if( (status & DSBSTATUS_PLAYING) == 0x00 ){
			LPDIRECTSOUND3DBUFFER pDS3DBuffer;
			if( FAILED(pDSBuffer[id][i]->QueryInterface(IID_IDirectSound3DBuffer8, (VOID**)&pDS3DBuffer)) ){
				//IDirectSound3DBuffer8擾łȂ
				return 0;
			}

			//3DĐ𖳌
			pDS3DBuffer->SetMode(DS3DMODE_DISABLE, DS3D_IMMEDIATE);

			//{[ݒ肵Đ
			pDSBuffer[id][i]->SetVolume( GetDSVolume(volume) );
			pDSBuffer[id][i]->Play(NULL, 0, NULL);
			return 1;
		}
	}

	return 0;
}

//! @brief TEhĐi3DĐj
//! @param id Fԍ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param volume Đ{[
//! @return F1@sF0
//! @note prFΓIȈʒuɂ茸AʓIȌʉB
int SoundControl::Play3DSound(int id, float x, float y, float z, int volume)
{
	if( pDSound == NULL ){ return 0; }
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return 0; }
	if( pDSBuffer[id][0] == NULL ){ return 0; }

	DWORD status = 0;

	for(int i=0; i<MAX_SOUNDLISTS; i++){
		//Đ󋵂擾
		pDSBuffer[id][i]->GetStatus(&status);

		//TEh~Ȃ
		if( (status & DSBSTATUS_PLAYING) == 0x00 ){

			LPDIRECTSOUND3DBUFFER pDS3DBuffer;
			if( FAILED(pDSBuffer[id][i]->QueryInterface(IID_IDirectSound3DBuffer8, (VOID**)&pDS3DBuffer)) ){
				//IDirectSound3DBuffer8擾łȂ
				return 0;
			}

			//ŏƍő勗̐ݒ
			pDS3DBuffer->SetMinDistance(1, DS3D_IMMEDIATE);
			pDS3DBuffer->SetMaxDistance(MAX_SOUNDDIST, DS3D_IMMEDIATE);

			//̍Wݒ
			pDS3DBuffer->SetPosition(x, y, z, DS3D_IMMEDIATE);

			//3DĐL
			pDS3DBuffer->SetMode(DS3DMODE_NORMAL, DS3D_IMMEDIATE);

			//{[ݒ肵Đ
			pDSBuffer[id][i]->SetVolume( GetDSVolume(volume) );
			pDSBuffer[id][i]->Play(NULL, 0, NULL);
			return 1;
		}
	}

	return 0;
}

//! @brief ǂݍݍς݂̃TEh擾
//! @return TEh
int SoundControl::GetTotalSounds()
{
	int cnt = 0;

	//gp̗vf𐔂
	for(int i=0; i<MAX_LOADSOUND; i++){
		if( pDSBuffer[i][0] != NULL ){ cnt += 1; }
	}

	return cnt;
}

//! @brief TEh
//! @param id Fԍ
void SoundControl::CleanupSound(int id)
{
	if( pDSound == NULL ){ return; }
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return; }
	if( pDSBuffer[id][0] == NULL ){ return; }

	DWORD status = 0;

	for(int i=0; i<MAX_SOUNDLISTS; i++){
		//Đ󋵂擾
		pDSBuffer[id][i]->GetStatus(&status);

		//TEhĐȂΒ~
		if( (status & DSBSTATUS_PLAYING) != 0x00 ){
			pDSBuffer[id][i]->Stop();
		}

		//Ώۂ̃ZJ_obt@[
		if( pDSBuffer[id][i] != NULL ){ pDSBuffer[id][i]->Release(); }
		pDSBuffer[id][i] = NULL;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "TEh", id);
#endif
}

//! @brief Wavet@C̏𒲂ׂ
//! @param filename t@C
//! @param filesize t@CTCY󂯎|C^
//! @param fileoffset f[^ItZbg󂯎|C^
//! @param pwfex WAVEFORMATEX^󂯎d|C^
//! @return Ffalse@sFtrue
bool SoundControl::CheckSoundFile(char* filename, int *filesize, int *fileoffset, WAVEFORMATEX** pwfex)
{
	HMMIO hMmio = NULL;
	MMCKINFO ckInfo;
	MMCKINFO riffckInfo;
	PCMWAVEFORMAT pcmWaveFormat; 
	bool errorflag;

	hMmio = mmioOpen(filename, NULL, MMIO_ALLOCBUF | MMIO_READ);
	if( hMmio == NULL ){
		//t@CȂ
		return true;
	}

	//WAVEt@CmF
	errorflag = true;
	if( mmioDescend( hMmio, &riffckInfo, NULL, 0 ) == MMSYSERR_NOERROR ){
		if( (mmioFOURCC('R','I','F','F') == riffckInfo.ckid) && (mmioFOURCC('W','A','V','E') == riffckInfo.fccType) ){
			errorflag = false;
		}
	}
	if( errorflag == true ){
		mmioClose(hMmio, MMIO_FHOPEN);
		return true;	//WAVEt@CłȂ
	}

	//tH[}bg擾
	*pwfex = NULL;
	ckInfo.ckid = mmioFOURCC('f','m','t',' ');
	if( mmioDescend(hMmio, &ckInfo, &riffckInfo, MMIO_FINDCHUNK) == MMSYSERR_NOERROR ){
		if( mmioRead(hMmio, (HPSTR) &pcmWaveFormat, sizeof(pcmWaveFormat)) == sizeof(pcmWaveFormat) ){
			if( pcmWaveFormat.wf.wFormatTag == WAVE_FORMAT_PCM ){
				if( (pcmWaveFormat.wf.nChannels == 1)||(pcmWaveFormat.wf.nChannels == 2) ){
					*pwfex = new WAVEFORMATEX;
					if( *pwfex != NULL ){
						memcpy( *pwfex, &pcmWaveFormat, sizeof(pcmWaveFormat) );
						//pwfex->cbSize = 0;
					}
				}
			}
		}
	}
	if( *pwfex == NULL ){
		mmioClose(hMmio, MMIO_FHOPEN);
		return true;	//t@CtH[}bgΉĂȂ
	}
	if( mmioAscend(hMmio, &ckInfo, 0) != MMSYSERR_NOERROR ){
		delete pwfex;
		mmioClose(hMmio, MMIO_FHOPEN);
		return true;	//`N䎸s
	}

	//f[^̈𒲂ׂ
	ckInfo.ckid = mmioFOURCC('d','a','t','a');
	if( mmioDescend(hMmio, &ckInfo, &riffckInfo, MMIO_FINDCHUNK) != MMSYSERR_NOERROR ){
		mmioClose(hMmio, MMIO_FHOPEN);
		return true;	//t@CtH[}bgΉĂȂ
	}

	mmioClose(hMmio, MMIO_FHOPEN);

	*filesize = ckInfo.cksize;
	*fileoffset = ckInfo.dwDataOffset;
	return false;
}

//! @brief SetVolume()p@1/100 dB (fVx) vZ
//! @param volume ʁi-100`100j
//! @return 1/100 dB (fVx).
int SoundControl::GetDSVolume(int volume)
{
	if( volume <= -100 ){ return DSBVOLUME_MIN; }
	if( volume >=  100 ){ return DSBVOLUME_MAX; }

	//float volume2 = 1.0f/200 * (volume + 100);
	float volume2 = 1.0f/200 * (volume + 100) * mastervolume;
	int retn = (int)((DSBVOLUME_MIN-DSBVOLUME_MAX) * (1.0f - volume2));
	return retn;
}

#endif	//SOUND_DIRECTSOUND