//! @file sound-directsound.cpp
//! @brief SoundControlNX̒`iezds.dllŁj

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "sound.h"

#if SOUND_ENGINE == 0

//! @brief RXgN^
SoundControl::SoundControl()
{
	lib = NULL;

	//gpς݃tO
	for(int i=0; i<MAX_LOADSOUND; i++){
		useflag[i] = false;
	}

	mastervolume = 1.0f;
}

//! @brief fBXgN^
SoundControl::~SoundControl()
{
	DestroySound();
}

//! @brief @n
//! iDLL̃[hA֐̎sj
//! @param WindowCtrl WindowControlNX̃|C^
//! @return F0@sF1
int SoundControl::InitSound(WindowControl *WindowCtrl)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_INIT, "Sound", "ezds.dll");
#endif

	if( lib != NULL ){
		return 1;
	}

	//DLLǂݍ
	lib = LoadLibrary("ezds.dll");
	if( lib == NULL ){
		return 1;
	}

	//֐蓖
	DSver = GetProcAddress(lib, "DSver");
	DSinit = (FARPROCH)GetProcAddress(lib, "DSinit");
	DSend = GetProcAddress(lib, "DSend");
	DSload = (FARPROCCI)GetProcAddress(lib, "DSload");
	DSplay = (FARPROCIII)GetProcAddress(lib, "DSplay");
	DSrelease = (FARPROCI)GetProcAddress(lib, "DSrelease");

	//DLLs
	if( DSinit == NULL ){
		//DLLJ
		FreeLibrary(lib);
		lib = NULL;
		//return 1;
	}
	if( DSinit(WindowCtrl->GethWnd()) == 0 ){
		//DLLJ
		FreeLibrary(lib);
		lib = NULL;
		//return 1;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	return 0;
}

//! @brief 
//! @attention {֐͎IɌĂяo܂AIɌĂяoƂ\łB
void SoundControl::DestroySound()
{
	if( lib == NULL ){ return; }

	//gp̃TEhf[^J
	for(int i=0; i<MAX_LOADSOUND; i++){
		if( useflag[i] == true ){
			if( DSrelease != NULL ){ DSrelease(i); }
			useflag[i] = false;
		}
	}

	//DLLI
	if( DSend != NULL ){ DSend(); }

	//DLLJ
	FreeLibrary(lib);
	lib = NULL;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "Sound", "ezds.dll");
#endif
}

//! @brief Đʂݒ
//! @param volume Đʁ@i0.0@1.0100%j
void SoundControl::SetVolume(float volume)
{
	mastervolume = volume;
}

//! @brief J̍WƊpxݒ
//! @param x JXW
//! @param y JYW
//! @param z JZW
//! @param rx JXpx@i\j
//! @warning t[ĂяoāAŐṼJWݒiKpjĂB
void SoundControl::SetCamera(float x, float y, float z, float rx)
{
	camera_x = x;
	camera_y = y;
	camera_z = z;
	camera_rx = rx;
}

//! @brief TEhǂݍ
//! @param filename t@C
//! @return F0ȏ̔Fԍ@sF-1
int SoundControl::LoadSound(char* filename)
{
	if( lib == NULL ){ return -1; }

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Sound", filename);
#endif

	//gpĂȂf[^ԍT
	for(int i=0; i<MAX_LOADSOUND; i++){
		if( useflag[i] == false ){

#ifdef ENABLE_PATH_DELIMITER_SLASH
			//pX؂蕶ϊ
			filename = ChangePathDelimiter(filename);
#endif

			//ǂݍ݂݂
			if( DSload == NULL ){ return -1; }
			if( DSload(filename, i) == 0 ){ return -1; }

			//ʂňxĐĂ
			if( DSplay == NULL ){ return -1; }
			DSplay(i, -100, 0);

			//gp\tOZbg
			useflag[i] = true;

#ifdef ENABLE_DEBUGLOG
			//Oɏo
			OutputLog.WriteLog(LOG_COMPLETE, "", i);
#endif
			return i;
		}
	}

	return -1;
}

//! @brief TEhĐi3DĐDLLĂяoj
//! @param id Fԍ
//! @param volume Đ{[
//! @param pan piEoXj
//! @return F1`3@sF0
//! @note prFvC[g鉹EQ[ԑŜŋψɖ炷EBGM
int SoundControl::PlaySound(int id, int volume, int pan)
{
	if( lib == NULL ){ return 0; }
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return 0; }
	if( useflag[id] == false ){ return 0; }

	if( volume < -100 ){ volume = -100; }
	if( volume > 100 ){ volume = 100; }
	if( pan < -100 ){ pan = -100; }
	if( pan > 100 ){ pan = 100; }

	//TEhĐ
	if( DSplay == NULL ){ return 0; }
	//return DSplay(id, volume, pan);
	return DSplay(id, (int)(mastervolume * (volume + 100)) - 100, pan);
}

//! @brief TEhĐi3DĐj
//! @param id Fԍ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param volume Đ{[
//! @return F1`3@sF0
//! @note prFΓIȈʒuɂ茸AʓIȌʉB
int SoundControl::Play3DSound(int id, float x, float y, float z, int volume)
{
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return 0; }
	if( useflag[id] == false ){ return 0; }

	if( volume < -100 ){ volume = -100; }
	if( volume > 100 ){ volume = 100; }

	float dist;
	int playvolume;
	int pan = 0;
	
	//ɂĐʌ
	if( CheckSourceDist(x, y, z, false, &dist) == false ){
		return 0;
	}
	playvolume = CalculationVolume(volume, dist, false);

	/*
	//ẼpiĐoXǰ
	float vx = x - camera_x;
	float vz = z - camera_z;
	float rx = (atan2(vz, vx) - camera_rx) * -1;
	for(; rx > (float)M_PI; rx -= (float)M_PI*2){}
	for(; rx < (float)M_PI*-1; rx += (float)M_PI*2){}
	pan = (int)((float)10 / M_PI * rx);
	*/

	//DLLĂяo
	return PlaySound(id, playvolume, pan);
}

//! @brief ǂݍݍς݂̃TEh擾
//! @return TEh
int SoundControl::GetTotalSounds()
{
	int cnt = 0;

	//gp̗vf𐔂
	for(int i=0; i<MAX_LOADSOUND; i++){
		if( useflag[i] == true ){ cnt += 1; }
	}

	return cnt;
}

//! @brief TEh
//! @param id Fԍ
void SoundControl::CleanupSound(int id)
{
	if( lib == NULL ){ return; }
	if( (id < 0)||(MAX_LOADSOUND -1 < id) ){ return; }
	if( useflag[id] == false ){ return; }

	//gp̃TEhf[^J
	if( DSrelease != NULL ){ DSrelease(id); }

	//gptO
	useflag[id] = false;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "Sound", id);
#endif
}

//! @brief Ƃ̋𒲂ׂ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param snear ߋ
//! @param out_dist 
//! @return LijFtrue@iOjFfalse
bool SoundControl::CheckSourceDist(float x, float y, float z, bool snear, float *out_dist)
{
	float dx, dy, dz, dist;
	int max_dist;

	if( snear == false ){
		max_dist = MAX_SOUNDDIST;
	}
	else{
		max_dist = 30;
	}

	dx = camera_x - x;
	dy = camera_y - y;
	dz = camera_z - z;
	dist = dx*dx + dy*dy + dz*dz;
	if( dist > max_dist * max_dist ){
		*out_dist = 0.0f;
		return false;
	}

	*out_dist = sqrt(dist);
	return true;
}

//! @brief ʂvZ
//! @param MaxVolume ̍ő剹
//! @param dist Ƃ̋
//! @param snear ߋ
int SoundControl::CalculationVolume(int MaxVolume, float dist, bool snear)
{
	int max_dist;
	if( snear == false ){
		max_dist = MAX_SOUNDDIST;
	}
	else{
		max_dist = 30;
	}
	return (int)( (float)MaxVolume/max_dist*dist*-1 + MaxVolume );
}

#endif	//SOUND_ENGINE