//! @file soundmanager.cpp
//! @brief SoundManagerNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "soundmanager.h"

//! @brief RXgN^
SoundManager::SoundManager(SoundControl *in_SoundCtrl, ResourceManager *in_Resource, ParameterInfo *in_Param)
{
	SoundCtrl = in_SoundCtrl;
	Resource = in_Resource;
	Param = in_Param;
	soundlistA = new soundlist[MAX_SOUNDMGR_LIST];
	soundlistB = new soundlist[MAX_SOUNDMGR_LIST];
	changeAB = false;
	listAdatas = 0;
	listBdatas = 0;
}

//! @brief fBXgN^
SoundManager::~SoundManager()
{
	if( soundlistA != NULL ){ delete [] soundlistA; }
	if( soundlistB != NULL ){ delete [] soundlistB; }
}

//! @brief gpNXݒ
//! @param in_SoundCtrl TEhRg[NX
//! @param in_Resource \[XǗNX
//! @param in_Param ݒlǗNX
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void SoundManager::SetClass(SoundControl *in_SoundCtrl, ResourceManager *in_Resource, ParameterInfo *in_Param)
{
	SoundCtrl = in_SoundCtrl;
	Resource = in_Resource;
	Param = in_Param;
}

//! @brief Ԃ̉
void SoundManager::InitWorldSound()
{
	changeAB = false;
	listAdatas = 0;
	listBdatas = 0;
}

//! @brief ԂɔCǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param id ̎ޔԍ
//! @param teamID `[ԍ
//! @param player vC[ɂ锭CǂitrueŃvC[j
//! @return Ftrue@sFfalse
bool SoundManager::ShotWeapon(float x, float y, float z, int id, int teamID, bool player)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	if( player == true ){
		plist->paramid = SHOT_WEAPON_PLAYER;
	}
	else{
		plist->paramid = SHOT_WEAPON;
	}
	plist->dataid = id;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief ԂɃ}bveǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::HitMap(float x, float y, float z, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = HIT_MAP;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief Ԃɔeǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param Hit_id eӏiF0@́F1@F2@]rUF3j
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::HitHuman(float x, float y, float z, int Hit_id, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	if( (Hit_id < 0)||(3 < Hit_id) ){ return false; }

	if( Hit_id == 0 ){ plist->paramid = HIT_HUMAN_HEAD; }
	if( Hit_id == 1 ){ plist->paramid = HIT_HUMAN_UP; }
	if( Hit_id == 2 ){ plist->paramid = HIT_HUMAN_LEG; }
	if( Hit_id == 3 ){ plist->paramid = HIT_HUMAN_ZOMBIE; }
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief Ԃɏeǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param id ̎ޔԍ
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::HitSmallObject(float x, float y, float z, int id, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = HIT_SMALLOBJECT;
	plist->dataid = id;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief e̒ʉ߁E؂鉹ǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param move_x Xړ
//! @param move_y Yړ
//! @param move_z Zړ
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
//! @attention move_xEmove_yEmove_z̈ړʂ́A1t[w肵ĂBۂɍWړ킯ł͂܂B
bool SoundManager::PassingBullet(float x, float y, float z, float move_x, float move_y, float move_z, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = BULLET;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->move_x = move_x;
	plist->move_y = move_y;
	plist->move_z = move_z;
	plist->teamid = teamID;

	return true;
}

//! @brief ԂɎ֒eoEhE˕Ԃ艹ǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::GrenadeBound(float x, float y, float z, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = GRE_BOUND;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief ԂɎ֒eǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::GrenadeExplosion(float x, float y, float z, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = GRE_EXPLOSION;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief Ԃɑǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param MoveMode ړ[hiOiF0@ށF1@EF2j
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::SetFootsteps(float x, float y, float z, int MoveMode, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	if( (MoveMode < 0)||(2 < MoveMode) ){ return false; }

	if( MoveMode == 0 ){ plist->paramid = FOOTSTEPS_FORWARD; }
	if( MoveMode == 1 ){ plist->paramid = FOOTSTEPS_BACK; }
	if( MoveMode == 2 ){ plist->paramid = FOOTSTEPS_SIDE; }
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief Ԃɕ탊[hǉ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param teamID `[ԍ
//! @return Ftrue@sFfalse
bool SoundManager::ReloadWeapon(float x, float y, float z, int teamID)
{
	soundlist *plist = NULL;
	if( GetNewList(&plist) == false ){ return false; }

	plist->paramid = WEAPON_RELOAD;
	plist->x = x;
	plist->y = y;
	plist->z = z;
	plist->teamid = teamID;

	return true;
}

//! @brief ԁiTEhXgjŗLȉ擾
//! @return Lȉ
int SoundManager::GetTotalSoundList()
{
	if( changeAB == false ){
		return listBdatas;
	}
	//else{
		return listAdatas;
	//}
}

//! @brief w肵ʒu̎ӂɂ鉹擾
//! @param pos_x XW
//! @param pos_y YW
//! @param pos_z ZW
//! @param teamID `[ԍ
//! @param psoundlist TEhXg󂯎|C^
//! @return ԂiTEhXǵj̐
int SoundManager::GetWorldSound(float pos_x, float pos_y, float pos_z, int teamID, soundlist *psoundlist)
{
	int lists;
	soundlist *getlist = NULL;
	int newlists = 0;
	WeaponParameter WParam;

	//郊Xg
	lists = GetTargetList(&getlist);

	for(int i=0; i<lists; i++){
		float x, y, z;
		float maxdist = 20.0f;	//苗̕Wl

		//̎ނɂ蔻苗ς
		if( (getlist[i].paramid == SHOT_WEAPON)||(getlist[i].paramid == SHOT_WEAPON_PLAYER) ){
			Param->GetWeapon(getlist[i].dataid, &WParam);

			if( getlist[i].teamid == teamID ){ maxdist = 20.0f; }
			else if( WParam.silencer == true ){ maxdist = 30.0f; }
			else{ maxdist = 120.0f; }
		}
		if( getlist[i].paramid == HIT_MAP ){
			maxdist = 30.0f;
		}
		if( getlist[i].paramid == HIT_HUMAN_HEAD ){
			maxdist = 60.0f;
		}
		if( getlist[i].paramid == HIT_HUMAN_UP ){
			maxdist = 50.0f;
		}
		if( getlist[i].paramid == HIT_HUMAN_LEG ){
			maxdist = 40.0f;
		}
		if( getlist[i].paramid == HIT_HUMAN_ZOMBIE ){
			maxdist = 40.0f;
		}
		if( getlist[i].paramid == FOOTSTEPS_FORWARD ){
			if( getlist[i].teamid == teamID ){ continue; }
			else{ maxdist = 40.0f; }
		}
		if( getlist[i].paramid == FOOTSTEPS_BACK ){
			if( getlist[i].teamid == teamID ){ continue; }
			else{ maxdist = 30.0f; }
		}
		if( getlist[i].paramid == FOOTSTEPS_SIDE ){
			if( getlist[i].teamid == teamID ){ continue; }
			else{ maxdist = 35.0f; }
		}
		if( getlist[i].paramid == GRE_BOUND ){
			continue;
		}
		if( getlist[i].paramid == GRE_EXPLOSION ){
			maxdist = 80.0f;
		}
		if( getlist[i].paramid == WEAPON_RELOAD ){
			continue;
		}

#ifdef ENABLE_BUG_TEAMID
		//`[ԍA̃`[ԍ傫ȂA𖳎
		if( (teamID < 0)&&(getlist[i].teamid < 0) ){
			if( teamID < getlist[i].teamid ){
				continue;
			}
		}
#endif

		//eeȂ
		if( getlist[i].paramid == BULLET ){
			float min_x, min_y, min_z;

			//eeł߂ÂWZo
			if( CheckApproach(&(getlist[i]), pos_x, pos_y, pos_z, &min_x, &min_y, &min_z) == false ){ continue; }

			//Ƃ͈͓̋Ȃ΁`
			x = min_x - pos_x;
			y = min_y - pos_y;
			z = min_z - pos_z;
			if( x*x + y*y + z*z < maxdist*maxdist ){
				//o͐̃Xgɒǉ
				psoundlist[newlists].paramid = getlist[i].paramid;
				psoundlist[newlists].dataid = getlist[i].dataid;
				psoundlist[newlists].x = min_x;
				psoundlist[newlists].y = min_y;
				psoundlist[newlists].z = min_z;
				newlists += 1;
			}
		}
		else{
			//Ƃ͈͓̋Ȃ΁`
			x = getlist[i].x - pos_x;
			y = getlist[i].y - pos_y;
			z = getlist[i].z - pos_z;
			if( x*x + y*y + z*z < maxdist*maxdist ){
				//o͐̃Xgɒǉ
				psoundlist[newlists].paramid = getlist[i].paramid;
				psoundlist[newlists].dataid = getlist[i].dataid;
				psoundlist[newlists].x = getlist[i].x;
				psoundlist[newlists].y = getlist[i].y;
				psoundlist[newlists].z = getlist[i].z;
				newlists += 1;
			}
		}
	}

	return newlists;
}

//! @brief ԏ̃TEhĐ
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param camera_rx JXpx@i\j
//! @param teamID `[ԍ
//! @warning t[ĂяoĂB
void SoundManager::PlayWorldSound(float camera_x, float camera_y, float camera_z, float camera_rx, int teamID)
{
	int lists;
	soundlist *getlist = NULL;

	//tO؂ւ
	if( changeAB == false ){
		listBdatas = 0;
		changeAB = true;
	}
	else{
		listAdatas = 0;
		changeAB = false;
	}

	//JWݒ
	SoundCtrl->SetCamera(camera_x, camera_y, camera_z, camera_rx);

	//郊Xg
	lists = GetTargetList(&getlist);

	for(int i=0; i<lists; i++){
		float x = getlist[i].x - camera_x;
		float y = getlist[i].y - camera_y;
		float z = getlist[i].z - camera_z;

		//͈͓̉Ȃ΍Đ݂
		if( x*x + y*y + z*z < MAX_SOUNDDIST*MAX_SOUNDDIST ){
			PlaySound( &(getlist[i]), camera_x, camera_y, camera_z, teamID );
		}
	}
}

//! @brief VTEhXgiPj擾
//! @param plist VTEhXgiPj̓d|C^
//! @return Ftrue@sFfalse
bool SoundManager::GetNewList(soundlist **plist)
{
	if( changeAB == false ){
		if( (listAdatas + 1) >= MAX_SOUNDMGR_LIST ){
			return false;
		}
		*plist = &(soundlistA[listAdatas]);
		listAdatas += 1;
	}
	else{
		if( (listBdatas + 1) >= MAX_SOUNDMGR_LIST ){
			return false;
		}
		*plist = &(soundlistB[listBdatas]);
		listBdatas += 1;
	}

	return true;
}

//! @brief Ώۂ̃TEhXg擾
//! @param plist Ώۂ̃TEhXg̓d|C^
//! @return 擾TEhXgɊ܂܂鉹̐
int SoundManager::GetTargetList(soundlist **plist)
{
	if( changeAB == false ){
		*plist = soundlistB;
		return listBdatas;
	}
	//else{
		*plist = soundlistA;
		return listAdatas;
	//}
}

//! @brief Ji_jɍł߂ÂmF
//! @param plist Ώۂ̃TEhXgiPj̃|C^
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param min_x ŒZXW󂯎|C^
//! @param min_y ŒZYW󂯎|C^
//! @param min_z ŒZZW󂯎|C^
//! @return ʂ߂Ftrue@ʂ߂ĂȂFfalse
bool SoundManager::CheckApproach(soundlist *plist, float camera_x, float camera_y, float camera_z, float *min_x, float *min_y, float *min_z)
{
	float x, y, z;
	float dist1, dist2, dist3;

	//1t[Ő
	x = camera_x - (plist->x - plist->move_x);
	y = camera_y - (plist->y - plist->move_y);
	z = camera_z - (plist->z - plist->move_z);
	dist1 = x*x + y*y + z*z;

	//݈ʒű
	x = camera_x - plist->x;
	y = camera_y - plist->y;
	z = camera_z - plist->z;
	dist2 = x*x + y*y + z*z;

	//1t[̋
	x = camera_x - (plist->x + plist->move_x);
	y = camera_y - (plist->y + plist->move_y);
	z = camera_z - (plist->z + plist->move_z);
	dist3 = x*x + y*y + z*z;

	//݈ʒűł߂΁`
	if( (dist1 > dist2)&&(dist2 < dist3) ){
		float speed;
		float min_dist, dist;

		//ړx߂
		speed = sqrtf(plist->move_x*plist->move_x + plist->move_y*plist->move_y + plist->move_z*plist->move_z);

		//ŒZ̍W߂
		min_dist = DistancePosRay(camera_x, camera_y, camera_z, plist->x, plist->y, plist->z, plist->move_x/speed, plist->move_y/speed, plist->move_z/speed);

		//ŒZ̍W߂
		dist = sqrtf(dist2 - min_dist*min_dist);
		*min_x = plist->x + plist->move_x/speed * dist;
		*min_y = plist->y + plist->move_y/speed * dist;
		*min_z = plist->z + plist->move_z/speed * dist;

		return true;
	}

	return false;
}

//! @brief w肵TEhXgi1jĐ
//! @param plist ĐTEhXgiPj̃|C^
//! @param camera_x JXW
//! @param camera_y JYW
//! @param camera_z JZW
//! @param teamID `[ԍ
void SoundManager::PlaySound(soundlist *plist, float camera_x, float camera_y, float camera_z, int teamID)
{
	WeaponParameter WParam;
	int hitsoundA, hitsoundB;
	int hitsound;
	int ccosound;
	int bangsound;

	int id = -1;
	int volume = 0;

	//Đݒ
	switch(plist->paramid){
		case SHOT_WEAPON:		//C
			Param->GetWeapon(plist->dataid, &WParam);
			if( WParam.soundvolume == 0 ){ return; }

			id = Resource->GetWeaponSound(plist->dataid);
			volume = WParam.soundvolume;
			break;

		case SHOT_WEAPON_PLAYER:	//vC[g̔C
			Param->GetWeapon(plist->dataid, &WParam);
			if( WParam.soundvolume == 0 ){ return; }

			//3DƂɂ̂܂܍ĐďI
			SoundCtrl->PlaySound(Resource->GetWeaponSound(plist->dataid), WParam.soundvolume, 0);
			return;

		case HIT_MAP:			//}bve
			Resource->GetBulletSound(&hitsoundA, &hitsoundB, NULL, NULL, NULL, NULL);
			if( GetRand(2) ){
				id = hitsoundA;
			}
			else{
				id = hitsoundB;
			}
			volume = MAX_SOUNDHITMAP;
			break;

		case HIT_HUMAN_HEAD:			//e
		case HIT_HUMAN_UP:
		case HIT_HUMAN_LEG:
		case HIT_HUMAN_ZOMBIE:
			Resource->GetBulletSound(NULL, NULL, &hitsound, NULL, NULL, NULL);
			id = hitsound;
			volume = MAX_SOUNDHITHUMAN;
			break;

		case HIT_SMALLOBJECT:	//j
			id = Resource->GetSmallObjectSound(plist->dataid);
			volume = MAX_SOUNDHITSMALLOBJ;
			break;

		case BULLET:			//eẻE؂鉹
			float new_x, new_y, new_z;
			int passingsound;

			if( CheckApproach(plist, camera_x, camera_y, camera_z, &new_x, &new_y, &new_z) == false ){ return; }

			//̒eȂ牽I
			if( plist->teamid == teamID ){ return; }

			//̂܂܍ĐďI
			Resource->GetBulletSound(NULL, NULL, NULL, &passingsound, NULL, NULL);
			SoundCtrl->Play3DSound(passingsound, new_x, new_y, new_z, MAX_SOUNDPASSING);
			return;

		case GRE_BOUND:			//֒e oEh
			Resource->GetBulletSound(NULL, NULL, NULL, NULL, NULL, &ccosound);
			id = ccosound;
			volume = MAX_SOUNDCCOGRENADE;
			break;

		case GRE_EXPLOSION:		//֒e 
			Resource->GetBulletSound(NULL, NULL, NULL, NULL, &bangsound, NULL);
			id = bangsound;
			volume = MAX_SOUNDHITGRENADE;
			break;

		case FOOTSTEPS_FORWARD:			//E鉹
		case FOOTSTEPS_BACK:
		case FOOTSTEPS_SIDE:
			//Đ鏈
			//break;

			return;	//ĐɕԂ

		case WEAPON_RELOAD:			//[h
			id = Resource->GetWeaponSound(-1);
			volume = 100;
			break;

		default:
			return;
	}

	//Đ
	SoundCtrl->Play3DSound(id, plist->x, plist->y, plist->z, volume);
}