//! @file main.cpp
//! @brief WinMain()֐̒`уeXgvO 

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

//Doxygenݒt@C
#include "doxygen.h"

#include "main.h"

#ifdef _DEBUG
 #include <shlwapi.h>
 #pragma comment(lib, "Shlwapi.lib")
#endif

#ifdef ENABLE_DEBUGLOG
 //! Oo
 DebugLog OutputLog;
#endif

//! Xe[g}V
StateMachine GameState;

//! Q[ݒf[^
Config GameConfig;

//! CEBhE
WindowControl MainWindow;

//! @brief WinMain()֐
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	//gp΍
	UNREFERENCED_PARAMETER(hInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	char path[MAX_PATH];

#ifdef ENABLE_AUTOLOADMIF
	bool NoBriefingFlag = false;
	int gamemode = 0;
#endif

	//
	InitRand();

	//st@ĈꏊAJgfBNgɂB
	GetFileDirectory(__argv[0], path);
	chdir(path);

#ifdef _DEBUG
	//[Ňo
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	char str[255];
	strcpy(str, "[Information]\nThe compiler is the Debug mode.\nIf release the software, Switch compiler to Release mode.");
	MessageBox(NULL, str, GAMENAME, MB_OK);
#endif

	//
	//FWindowsȂAlpCmdLineƂGetCommandLine()֐ł܂ǂˁEEB
	strcpy(path, "");
	if( __argc > 1 ){
		for(int param=1; param<__argc; param++){
#ifdef ENABLE_DEBUGLOG
			//"Log"^ĂAOo͂L
			if( CheckCommandParameter(__argv[param], "-Log") == true ){
				//Oo͂L
				OutputLog.EnableOutputLog();

				MainWindow.ErrorInfo("Enable Debug Log...");
				continue;
			}
#endif

#ifdef ENABLE_AUTOLOADMIF
			//"Dir"^ĂAJgfBNgړ
			if( CheckCommandParameter(__argv[param], "-Dir") == true ){
				if( (param+1) < __argc ){
					chdir(__argv[param+1]);
					param += 1;
				}
				continue;
			}

			//"NoBriefing"^ĂAi.mifw莞́ju[tBOȗ
			if( CheckCommandParameter(__argv[param], "-NoBriefing") == true ){
				NoBriefingFlag = true;
				continue;
			}

			//ȊÖȂΊgq𔻒肵Ă݂
			if( CheckFileExtension(__argv[param], ".mif") == true ){
				//.mifł΃t@CpXƂċL
				strcpy(path, __argv[param]);
			}
#endif
		}

#ifdef ENABLE_AUTOLOADMIF
		//.mifw肳ĂȂ΁Au[tBOtOf
		if( path[0] != '\0' ){
			if( NoBriefingFlag == false ){ gamemode = 1; }
			else{ gamemode = 2; }
		}
#endif
	}

#ifdef ENABLE_DEBUGLOG
	//t@C쐬
	OutputLog.MakeLog();

	//[U[o
	GetOperatingEnvironment();

	char infostr[64];

	/*
	//Oɏo
	sprintf(infostr, "Total Parameters : %d", __argc);
	OutputLog.WriteLog(LOG_CHECK, "Parameter", infostr);
	for(int i=0; i<__argc; i++){
		sprintf(infostr, "Parameter[%d]", i);
		OutputLog.WriteLog(LOG_CHECK, infostr, __argv[i]);
	}
	*/

	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Start program entry point");
#endif

#ifdef _DEBUG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Visual C++ debug mode");
#endif

#ifdef _DEBUG
	char path2[MAX_PATH];
	getcwd(path2, MAX_PATH);
	sprintf(infostr, "EXE directory path length : %d", strlen(path2));

	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Environment", infostr);
#endif

	//f[^tH_`FbN
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Directory", "data folder");
	if( CheckDirectory("data") == true ){
		OutputLog.WriteLog(LOG_COMPLETE, "", "");
	}
	else{
		OutputLog.WriteLog(LOG_ERROR, "", "");
	}
#endif
#ifdef ENABLE_CHECKDATADIR
	if( CheckDirectory("data") == false ){
		MainWindow.ErrorInfo("Data directory not exist.\n\nPlease download and copy \"X operations 0.96\".");
		return 1;
	}
#endif

	//ݒt@Cǂݍ
	if( GameConfig.LoadFile("config.dat") == 1 ){
#ifndef ENABLE_AUTOCREATECONFIG
		MainWindow.ErrorInfo("config data open failed");
		return 1;
#else
		//ftHgl𔽉fAݒt@Cɕۑ
		GameConfig.SetDefaultConfig();
		if( GameConfig.SaveFile("config.dat") == 1 ){
			MainWindow.ErrorInfo("config data save failed");
			return 1;
		}
#endif
	}

	//ǉݒǂݍ
#ifdef ENABLE_ADDCONFIG
	GameConfig.CreateExtConfig("config-openxops.ini");
	GameConfig.LoadExtFile("config-openxops.ini");
#else
	GameConfig.LoadExtFile(NULL);
#endif

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	sprintf(infostr, "Display resolution : %d x %d", GameConfig.GetScreenWidth(), GameConfig.GetScreenHeight());
	OutputLog.WriteLog(LOG_CHECK, "Environment", infostr);
	if( GameConfig.GetFullscreenFlag() == false ){
		OutputLog.WriteLog(LOG_CHECK, "Environment", "Window mode : Window");
	}
	else{
		OutputLog.WriteLog(LOG_CHECK, "Environment", "Window mode : Fullscreen");
	}
	sprintf(infostr, "Game language mode : %d", GameConfig.GetLanguage());
	OutputLog.WriteLog(LOG_CHECK, "Environment", infostr);
#endif

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Start game initialize");
#endif

	//EBhE
	MainWindow.SetParam(hPrevInstance, nCmdShow);
	MainWindow.InitWindow(GAMENAME, GameConfig.GetScreenWidth(), GameConfig.GetScreenHeight(), GameConfig.GetFullscreenFlag());

	//{Iȏ
#ifdef ENABLE_AUTOLOADMIF
	if( InitGame(&MainWindow, gamemode, path) ){
#else
	if( InitGame(&MainWindow, 0, "") ){
#endif
		return 1;
	}

	opening Opening;
	mainmenu MainMenu;
	briefing Briefing;
	maingame MainGame;
	result Result;
	InitScreen(&MainWindow, &Opening, &MainMenu, &Briefing, &MainGame, &Result);

#ifdef ENABLE_AUTOLOADMIF
	//CQ[̂ݕ\郂[hȂ΁AWŃfobN\LɂB
	if( gamemode == 2 ){ MainGame.SetShowInfoFlag(true); }
#endif


#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Start main loop");
#endif

	unsigned int framecnt = 0;

	for(int flag = 0; flag != -1; flag = MainWindow.CheckMainLoop()){
		if( flag == 1 ){
			//C
			ProcessScreen(&MainWindow, &Opening, &MainMenu, &Briefing, &MainGame, &Result, framecnt);

			//FPS
			ControlFps();

			framecnt++;
		}
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Exit", "Exit main loop");
#endif


	//{Iȉ
	CleanupGame();

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Exit", "Exit program entry point");
#endif
	return 0;
}

//! @brief R}h
//! @param param ̕
//! @param cmd 肷
//! @return YFtrue@YFfalse
//! @warning cmd̍ŏ̈ꕶ͖܂B
//! @attention ̈𔻒肵܂B/[]A-[]A/[ij]A-[ij]
bool CheckCommandParameter(const char *param, const char *cmd)
{
	if( param == NULL ){ return false; }
	if( cmd == NULL ){ return false; }
	if( strlen(param) >= 16 ){ return false; }
	if( strlen(cmd) >= 16 ){ return false; }
	if( strlen(param) != strlen(cmd) ){ return false; }

	char str[16];
	strcpy(str, cmd);

	str[0] = '/';
	if( strcmp(param, str) == 0 ){ return true; }
	str[0] = '-';
	if( strcmp(param, str) == 0 ){ return true; }

	for(int i=0; i<(int)strlen(str); i++){ str[i] = (char)tolower((int)(str[i])); }

	str[0] = '/';
	if( strcmp(param, str) == 0 ){ return true; }
	str[0] = '-';
	if( strcmp(param, str) == 0 ){ return true; }

	return false;
}

//! @brief pxiWAjK
//! @param r px
//! @return K̊px
//! @note -PI`PI ̊ԂɐK܂B
float AngleNormalization(float r)
{
	for(; r > (float)M_PI;    r -= (float)M_PI*2){}
	for(; r < (float)M_PI*-1; r += (float)M_PI*2){}
	return r;
}