//! @file datafile.h
//! @brief f[^ǗNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef DATAFILE_H
#define DATAFILE_H

#define MAX_BLOCKS 160			//!< őubN
#define TOTAL_BLOCKTEXTURE 10	//!< veNX`

//#define MAX_POINTS 200
#define MAX_POINTS 256			//!< ő|Cg

//! @brief ǉ̐
//! @attention ݒl𑝂₷ꍇAMAX_MODELEMAX_TEXTUREEMAX_LOADSOUND̒lK؂Ɍ
//! @note ǉݒt@C̉ɁAĎ̒ǉ̐ݒlLڂ܂BAeǉ̐ݒl̊ԂɃ_~[si"//"j}łB
#define MAX_ADDSMALLOBJECT 1

#define MAX_POINTMESSAGES 16			//!< .msgt@C̍ő僁bZ[W
#define MAX_POINTMESSAGEBYTE (71+2)		//!< .msgt@C 1s̍őoCg

#define LIGHT_RX DegreeToRadian(190)	//!< Cg̉pxiubN̉AevZpj
#define LIGHT_RY DegreeToRadian(120)	//!< Cg̏cpxiubN̉AevZpj

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 1		//!< Select include file.
#endif
#include "main.h"

#include <ctype.h>
#include <sys/stat.h>

//! ubNf[^p\́@iblockdata\̂Ŏgpj
typedef struct
{
	int textureID;				//!< textureID
	float u[4];					//!< textureUV-U
	float v[4];					//!< textureUV-V
	float center_x;				//!< center
	float center_y;				//!< center
	float center_z;				//!< center
	float vx;					//!< normal vector 
	float vy;					//!< normal vector 
	float vz;					//!< normal vector 
	float shadow;				//!< shadow 
} b_material;
//! ubNf[^p\
typedef struct
{
	int id;						//!< DataID
	float x[8];					//!< Position
	float y[8];					//!< Position
	float z[8];					//!< Position
	b_material material[6];		//!< Material data
} blockdata;

//! |Cgf[^p\
typedef struct
{
	int id;						//!< DataID
	float x;					//!< Position
	float y;					//!< Position
	float z;					//!< Position
	float r;					//!< Rotation
	signed short int p1;		//!< Param
	signed short int p2;		//!< Param
	signed short int p3;		//!< Param
	signed short int p4;		//!< Param
} pointdata;

//! ǉp̍\
typedef struct
{
	char modelpath[_MAX_PATH];		//!< ff[^pX
	char texturepath[_MAX_PATH];	//!< eNX`pX
	int decide;						//!< 蔻̑傫
	int hp;							//!< ϋv
	char soundpath[_MAX_PATH];		//!< TEhf[^pX
	int jump;						//!< ы
} addsmallobject;

//! @brief f[^ǗNXiNXj
//! @details Q[̃f[^At@CǂݍݏNXQ̊NXłB
class DataInterface
{
protected:
	int datas;		//!< f[^

public:
	DataInterface();
	~DataInterface();
	virtual int LoadFiledata(const char *fname);
	virtual int GetTotaldatas();
	virtual int Getdata(void *out_data, int id);
};

//! @brief ubNf[^ǗNX
//! @details }bvf[^ƂĎgAubNf[^t@CǗ܂B
//! @details t@C̓ǂݍ݂̂قA}bvւ̉eieʂ̖邳\jvZ܂B
class BlockDataInterface : public DataInterface
{
	blockdata *data;								//!< ubNf[^\\
	char texture[TOTAL_BLOCKTEXTURE][_MAX_PATH];	//!< eNX`

public:
	BlockDataInterface();
	~BlockDataInterface();
	int LoadFiledata(const char *fname);
	void CalculationBlockdata(bool darkflag);
	int GetTexture(char *fname, int id);
	int Getdata(blockdata *out_data, int id);
};

bool blockdataface(int faceID, int* vID, int* uvID);

//! @brief |Cgf[^ǗNX
//! @details ~bVf[^ƂĎgA|Cgf[^t@CǗ܂B
//! @details t@C̓ǂݍ݂̂قA|Cǧ@\܂B
class PointDataInterface : public DataInterface
{
	pointdata *data;							//!< ubNf[^\\
	char *text[MAX_POINTMESSAGES];				//!< CxgbZ[W

	int LoadMSGFiledata(char *fname);

public:
	PointDataInterface();
	~PointDataInterface();
	int LoadFiledata(const char *fname);
	int Getdata(pointdata *out_data, int id);
	int SetParam(int id, signed short int p1, signed short int p2, signed short int p3, signed short int p4);
	int GetMessageText(char *str, int id);
	int SearchPointdata(int* id, unsigned char pmask, signed short int p1, signed short int p2, signed short int p3, signed short int p4, int offset = 0);
	int SearchPointdata(pointdata *out_data, unsigned char pmask, signed short int p1, signed short int p2, signed short int p3, signed short int p4, int offset = 0);
};

//! @brief MIFǗNX
//! @details MIFiMISSION INFORMATION FILEjǗ܂B
//! @details W~bṼu[tBOt@Ci.txtjɂΉĂ܂B
class MIFInterface : public DataInterface
{
	bool mif;								//!< t@C` .mif
	char mission_name[24];					//!< ~bVʖ
	char mission_fullname[64];				//!< ~bV
	char blockfile_path[_MAX_PATH];			//!< ubNf[^t@C
	char pointfile_path[_MAX_PATH];			//!< |Cgf[^t@C
	int skynumber;							//!< wiID@iȂF0j
	char picturefileA_path[_MAX_PATH];		//!< u[tBO摜A
	char picturefileB_path[_MAX_PATH];		//!< u[tBO摜Biǉj
	char addsmallobject_path[_MAX_PATH];	//!< ǉt@Cւ̃pX
	char briefingtext[816];					//!< u[tBÓE{
	bool collision;					//!< 蔻𑽂߂ɍs
	bool screen;					//!< ʂÂ߂ɂ
	addsmallobject *AddSmallObjectData;		//!< ǉ̏

	int LoadDefaultTextFiledata(const char *fname);
	int LoadMissionInfoFiledata(const char *fname);
	int LoadAddSmallObjectFiledata(const char *fname);
	bool ChangeExePathToFullPath(char *dir, char *fname);

public:
	MIFInterface();
	~MIFInterface();
	int LoadFiledata(const char *fname);
	bool GetFiletype();
	char* GetMissionName();
	char* GetMissionFullname();
	void GetDatafilePath(char *blockfile, char *pointfile);
	int GetSkynumber();
	void GetPicturefilePath(char *picturefileA, char *picturefileB);
	char* GetBriefingText();
	bool GetCollisionFlag();
	bool GetScreenFlag();
	char* GetAddSmallobjectFile();
	char* GetAddSmallobjectModelPath(int id);
	char* GetAddSmallobjectTexturePath(int id);
	int GetAddSmallobjectDecide(int id);
	int GetAddSmallobjectHP(int id);
	char* GetAddSmallobjectSoundPath(int id);
	int GetAddSmallobjectJump(int id);
};

//! @brief ADDONXgǗNX
//! @details ̃fBNgɓ.mifADDONXgƂĊǗ܂B
class AddonList : public DataInterface
{
	char filename[MAX_ADDONLIST][_MAX_PATH];	//!< .mift@C
	char mission_name[MAX_ADDONLIST][24];		//!< ~bVʖ

	void GetMIFlist(const char *dir);
	void GetMissionName(const char *dir);
	void Sort();

public:
	AddonList();
	~AddonList();
	int LoadFiledata(const char *dir);
	char *GetMissionName(int id);
	char *GetFileName(int id);
};

//! @brief INIt@CǗNX
//! @details INIt@CǗ܂B
class INIFileInterface
{
	FILE *inifp;	//!< t@C|C^

public:
	INIFileInterface();
	~INIFileInterface();
	bool LoadINIFile(const char *fname);
	int GetINIFileString(const char *sectionname, const char *keyname, const char *defaultvalue, char *valuestr, int strbuflen);
	int GetINIFileInt(const char *sectionname, const char *keyname, int defaultvalue, int *errorcode);
	float GetINIFileFloat(const char *sectionname, const char *keyname, float defaultvalue, int *errorcode);
	bool GetINIFileBool(const char *sectionname, const char *keyname, bool defaultvalue, int *errorcode);
	void ReleaseINIFile();
};

int DeleteLinefeed(char *str);
bool CheckFullPath(const char *path);
void GetFileDirectory(const char *path, char *dir);
bool CheckFileExtension(const char *filepath, const char *checkstr);
bool CheckDirectory(const char *dir);

#endif