package gdsearch;

import javax.servlet.http.*;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import gdsearch.vo.GameData;

/**
 * GameDataのインポートを行うサーブレット
 */
public class GameDataImportServlet extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd");

        // テキストボックスに入力されたデータを取得
        String data = req.getParameter("importdata");
        // 一行ごとに分割する
        data = data.replaceAll("\r\n|\r", "\n");
        String[] lines = data.split("\n");

        GameDataDAO dao = new GameDataDAO();
        for(int i = 0; i < lines.length; i++){
            String regex = "\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\",\"(.*)\"";

            // データオブジェクトにセット
            GameData gd = new GameData();
            gd.setHard    (lines[i].replaceFirst(regex, "$1" ));                   // ハード名
            try {
                gd.setSaleDate(df.parse(lines[i].replaceFirst(regex, "$2")));      // 発売日
            } catch (Exception e) {}
            gd.setTitle2  (lines[i].replaceFirst(regex, "$3" ));                   // タイトル（上段）
            gd.setTitle   (lines[i].replaceFirst(regex, "$4" ));                   // タイトル（下段）
            gd.setMaker2  (lines[i].replaceFirst(regex, "$5" ));                   // 販売, 発売/開発/著作（上段）
            gd.setMaker   (lines[i].replaceFirst(regex, "$6" ));                   // 販売, 発売/開発/著作（下段）
            gd.setGenre   (lines[i].replaceFirst(regex, "$7" ));                   // 内容
            gd.setMedia   (lines[i].replaceFirst(regex, "$8" ));                   // 媒体
            gd.setCode    (lines[i].replaceFirst(regex, "$9" ));                   // 型番
            gd.setPrice   (Integer.parseInt(lines[i].replaceFirst(regex, "$10" )));// 価格
            gd.setRestrict(lines[i].replaceFirst(regex, "$11"));                   // R
            gd.setComment (lines[i].replaceFirst(regex, "$12"));                   // 備考

            // 既に登録されているデータかどうか確認
            if(dao.chkDuplicateGameData(gd)) {
                // データベースに格納
                dao.insertGameData(gd);
            }
        }
        resp.sendRedirect("/index.html");
    }
}
