<%@page contentType="text/html;charset=UTF-8" language="java" %>

<%@page import="java.net.URLEncoder"%>
<%@page import="java.util.ArrayList"%>
<%@page import="java.util.Map"%>
<%@page import="util.MorphemeAnalyzer"%>

<html>

<head>
<title>Yahoo Web API 形態素解析</title>
</head>

<body>
Yahoo Web API 形態素解析
<form name="frmAnalyze" method="GET" action="/analyze.jsp" >
  <textarea name="word" rows="4" cols="40"></textarea><br>
  <input name="btnAnalyze" value="解析" type="submit">
</form>

<%
String sentence = request.getParameter("word");
if(null != sentence) {
sentence = URLEncoder.encode( sentence, "UTF-8");
%>

<%
MorphemeAnalyzer analyzer = new MorphemeAnalyzer();
analyzer.doAnalyze(sentence);
ArrayList< Map<String, String> >   ma_result = analyzer.getMaResult();
ArrayList< Map<String, String> > uniq_result = analyzer.getUniqResult();
%>


ma_result
<table border="1" >
<tr>
  <th>surface</th>
  <th>pos</th>
  <th>baseform</th>
  <th>reading</th>
  <th>feature</th>
</tr>
<%
for (int i = 0; i < ma_result.size(); i++) {
    Map<String, String> map = ma_result.get(i);
%>
<tr>
  <td><%= map.get("surface") %></td>
  <td><%= map.get("pos") %></td>
  <td>　</td>
  <td><%= map.get("reading") %></td>
  <td>　</td>
</tr>
<%
}
%>
</table>
uniq_result
<table border="1" >
<tr>
  <th>surface</th>
  <th>pos</th>
  <th>count</th>
</tr>
<%
for (int i = 0; i < uniq_result.size(); i++) {
    Map<String, String> map = uniq_result.get(i);
%>
<tr>
  <td><%= map.get("surface") %></td>
  <td><%= map.get("pos") %></td>
  <td><%= map.get("count") %></td>
</tr>
<%
}
%>
</table>

<%
}
%>

</body>

</html>