/*This file is prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief This file manages the generic HID IN/OUT task.
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB162, AT90USB82
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//_____  I N C L U D E S ___________________________________________________

#include <util/delay.h>
#include "conf/config.h"
#include "conf/conf_usb.h"
#include "hid_task.h"
#include "lib_mcu/usb/usb_drv.h"
#include "usb_descriptors.h"
#include "modules/usb/device_chap9/usb_standard_request.h"
#include "usb_specific_request.h"
#include "lib_mcu/util/start_boot.h"

#include "ssd1322.h"
#include "tae5767.h"
#include "lm1972.h"

//_____ M A C R O S ________________________________________________________


//_____ D E F I N I T I O N S ______________________________________________


//_____ D E C L A R A T I O N S ____________________________________________

         volatile U8    cpt_sof=0;
extern            U8    jump_bootloader;
                  U8    g_last_joy       =0;
				  U8	led_sw=0;


void hid_report_out  (void);
void hid_report_in   (void);

#define SCAN_TIME	40
U8 scanData;
U8 scanTimer;
U8 fetchData;

U8 psCode		= 0;
U8 psUpCode		= 0;
U8 psDownCode	= 0;
void pushKeyDown()
{
	psDownCode	= psCode;
}

void pushKeyUp()
{
	psUpCode	= psCode;
	psCode		= 0;
}

void fetchKey()
{
	U8 bitmask = (1<<PS_BIT0)|(1<<PS_BIT1)|(1<<PS_BIT2);
	U8 fetchCode = (fetchData&bitmask)>>PS_BIT0;
	
	if( fetchCode == 0 && psCode != 0) {
		pushKeyUp();
		return;
	}
	if( psCode != fetchCode ) {
		if( psCode != 0 ) {
			pushKeyUp();
		}
		psCode	= fetchCode;
		pushKeyDown();
		return;
	}
}

// ROTALY ENCODER
U8 reA = 0;
U8 reB = 0;
U8 reCode = 0;
void fetchRe()
{
	U8 fetchA	= fetchData & (1<<RE_A);
	U8 fetchB	= fetchData & (1<<RE_B);
	if( fetchA != reA ) {
		if( fetchA != 0 ) {
			if( fetchB == 0 )
				reCode = 'R';
			else
				reCode = 'L';
		}
		reA	= fetchA;
		reB	= fetchB;
	}
}

void scanInput()
{
	U8 snsData = ~PS_PIN;
	if( snsData != scanData ) {
		scanData	= snsData;
		scanTimer	= SCAN_TIME;
		return;
	}
	if( scanData == fetchData ) {
		return;
	}
	if( scanTimer > 0 ) {
		scanTimer--;
		return;
	}
	fetchData = scanData;
	fetchKey();
	fetchRe();
}

//! @brief This function initializes the target board ressources.
//!
void hid_task_init(void)
{
	fetchData	= 0;
	scanData	= 0;
	scanTimer	= 5;
	ports_init();

	scanInput();
	ssd_reset();
	ssd_init();
//	ssd_clear();
//	ssd_setSleepMode(SSD_SLEEP_OFF);
//	ssd_setDispMode(SSD_DISPLAY_REVERSE);
//	ssd_powerOn();
	reCode	= 0;
	psCode	= 0;
	
	
//	ssd_init();
//	Leds_init();
//	Joy_init();
//	Leds_set_val(0);
}

//! @brief Entry point of the HID generic communication task
//! This function manages IN/OUT repport management.
//!
void hid_task(void)
{
	scanInput();
	if(!Is_device_enumerated())          // Check USB HID is enumerated
		return;
	
   hid_report_out();
   hid_report_in();
}


//! @brief Get data report from Host
//!
void hid_report_out(void)
{
	Usb_select_endpoint(EP_HID_OUT);
	
	if( Is_usb_receive_out() ) {
		U8 cmd = Usb_read_byte();
		if( cmd == 'S' ) {
			U8 ch = Usb_read_byte() & 0x01;
			if( ch == 1 )
				SR_PORT	|= (1<<SR_SEL);
			else
				SR_PORT	&= ~(1<<SR_SEL);
			Usb_ack_receive_out();
			return;
		}
		
		if( cmd == 'F') {
			U8 f0 = Usb_read_byte();
			U8 f1 = Usb_read_byte();
			tu_tune(f0, f1);
			Usb_ack_receive_out();
			return;
		}
		
		if( cmd == 'V') {
			U8 dx6ch[6];
			dx6ch[0] = Usb_read_byte();
			dx6ch[1] = Usb_read_byte();
			dx6ch[2] = Usb_read_byte();
			dx6ch[3] = Usb_read_byte();
			dx6ch[4] = Usb_read_byte();
			dx6ch[5] = Usb_read_byte();
			ev_setvol(dx6ch);
			Usb_ack_receive_out();
			return;
		}
	   
      //* Read report from HID Generic Demo
      U8 led_state;
      U8 led_number;
      led_state      = cmd&0x0F; // RepportOUT[0] is LEDS value
      led_number     = Usb_read_byte()&0x0F;
      switch (led_number)
      {
         case 1:
            if(led_state) {
			  led_sw=1;
			  SR_PORT	|= (1<<SR_SEL);
			} else {
			  led_sw=0;
			  SR_PORT	&= ~(1<<SR_SEL);
			}				
            break;
         case 2:
            if(led_state) {  led_sw=1; }
            break;
         case 3:
            if(led_state) {  led_sw=1; }
            break;
         case 4:
            if(led_state) { led_sw=1; }
            break;
      }  
      Usb_ack_receive_out();
   }
}


//! @brief Send data report to Host
//!
void hid_report_in(void)
{
 //  U8 joy   =0;

   Usb_select_endpoint(EP_HID_IN);
   if(!Is_usb_write_enabled())
      return;                                // Not ready to send report
  /* 
   // Build the Joytick report
   if(Is_joy_up()|| Is_joy_down() || Is_joy_right() || Is_joy_left() )
   {
     joy=0x01;
   }
   if(joy==g_last_joy)
      return;                                // Same report then no send report
   g_last_joy=joy;
  */
	if( psUpCode ) {
		Usb_write_byte('U');				// keyup
		Usb_write_byte('0'+psUpCode);		// keycode
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_ack_in_ready();                       // Send data over the USB
		psUpCode	= 0;
		return;
	}	  
	if( psDownCode ) {
		Usb_write_byte('D');				// keydown
		Usb_write_byte('0'+psDownCode);		// keycode
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_ack_in_ready();                       // Send data over the USB
		psDownCode	= 0;
		return;
	}
	if( reCode ) {
		Usb_write_byte('R');			// keydown
		Usb_write_byte(reCode);			// keycode
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_ack_in_ready();                       // Send data over the USB
		reCode	= 0;
		return;
	}
	if( led_sw ) {
		// Send report
		Usb_write_byte('J');			               // Joystick
		Usb_write_byte('0'+psCode);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_write_byte(GPIOR1);                   // Dummy (not used)
		Usb_ack_in_ready();                       // Send data over the USB
		led_sw=0;
		return;
	}
	
}

//! @brief  This function increments the cpt_sof counter each times
//! the USB Start Of Frame interrupt subroutine is executed (1ms)
//! Usefull to manage time delays
//!
void sof_action()
{
   cpt_sof++;
}
