/*
 * lm1972.h
 *
 * Created: 2012/07/12 23:34:30
 *  Author: tanaka
 */ 


#ifndef LM1972_H_
#define LM1972_H_

#define EV_PORT		PORTB	// LM1972
#define EV_CLK		5		// OUT CLOCK
#define EV_LS		6		// OUT LOAD/SHIFT
#define EV_DIN		7		// OUT DATA IN
#define DDRB_EV		((1<<EV_LS)|(1<<EV_CLK)|(1<<EV_DIN))
#define INIT_EV		0


#define lm1972_clk0()	(EV_PORT &= ~(1<<EV_CLK))
#define lm1972_clk1()	(EV_PORT |=  (1<<EV_CLK))
#define lm1972_ls0()	(EV_PORT &= ~(1<<EV_LS))
#define lm1972_ls1()	(EV_PORT |=  (1<<EV_LS))
#define lm1972_data(d)	(EV_PORT = (d)?(EV_PORT|(1<<EV_DIN)):(EV_PORT&~(1<<EV_DIN)))
#define lm1972_wc()		_delay_us(10)

void	ev_send(U8 d);
void	ev_setvol(U8 *dx6ch);

#endif /* LM1972_H_ */