#include "conf/config.h"
#include "ssd1322.h"
#include <util/delay.h>

void ssd_send(U8 c)
{
	U8 m = 0x80;
	U8 i;
	for( i = 0; i < 8; i++ ) {
		ssd_clk0();
		ssd_din(c & m);
		ssd_wc();
		ssd_clk1();
		ssd_wc();
		m = m >> 1;
	}
}

//#define ssd_c(C)	(ssd_dc0(),ssd_cs0(),ssd_send(C),ssd_cs1(),ssd_dc1())
//#define ssd_d(C)	(ssd_dc1(),ssd_cs0(),ssd_send(C),ssd_cs1(),ssd_dc1())

void ssd_c(U8 d)
{
	ssd_dc0();
	ssd_cs0();
	ssd_wcs();
	ssd_send(d);
	ssd_cs1();
	ssd_dc1();
	ssd_wcs();
}

void ssd_d(U8 d)
{
	ssd_dc1();
	ssd_cs0();
	ssd_wcs();
	ssd_send(d);
	ssd_cs1();
	ssd_dc1();
	ssd_wcs();
}

void ssd_reset()
{
	ssd_clk1();
	ssd_dc1();
	ssd_cs1();
	_delay_ms(500);
	ssd_res0();
	_delay_ms(10);
	ssd_res1();
}
	
void ssd_powerOn()
{
	_delay_ms(50);
	ssd_pow1();
}

void ssd_powerOff()
{
	ssd_pow0();
	_delay_ms(50);
}

void ssd_init()
{
	// initialize OLED
	//ssd_setCommandLock(false);
	ssd_c(0xfd); ssd_d(0x12);
	//ssd_setSleepMode(SSD_SLEEP_ON);
	ssd_c(0xae);
	//ssd_setFrontClockDiv(0x91);
	ssd_c(0xb3); ssd_d(0x91);
	//ssd_setMuxRatio(0x3f);
	ssd_c(0xca); ssd_d(0x3f);
	//ssd_setDispOffset(0);
	ssd_c(0xa2); ssd_d(0x00);
	//ssd_setDispStartLine(0);
	ssd_c(0xa1); ssd_d(0x00);
	//ssd_setRemapAndDualComLineMode(SSD_DOWNORDER_SCAN|SSD_ENABLE_NIBBLE_REMAP,SSD_ENABLE_DUALCOM_MODE);
	ssd_c(0xa0); ssd_d(0x14); ssd_d(0x11);
	//ssd_setGPIO(SSD_INPUT_DISABLE,SSD_INPUT_DISABLE);
	ssd_c(0x5b); ssd_d(0x00);
	//ssd_selectFunction(SSD_INTERNAL_VSL);
	ssd_c(0xab); ssd_d(0x01);
	//ssd_setDispEnhacementA(SSD_EXTERNAL_VSL,SSD_ENHANCED_LOW_GS);
	ssd_c(0xb4); ssd_d(0xa0); ssd_d(0xfd);
	//ssd_setContrast(0x9f);
	ssd_c(0xc1); ssd_d(0x9f);
	//ssd_setMasterContrast(0x0f);
	ssd_c(0xc7); ssd_d(0x0f);
	//ssd_selectDefaultTable();
	ssd_c(0xb9);
	//ssd_setPhaseLengthV(0xe2);
	ssd_c(0xb1); ssd_d(0xe2);
	//ssd_setDispEnhancementB(0x20);
	ssd_c(0xd1); ssd_d(0x82); ssd_d(0x20);
	//ssd_setPrecVoltage(0x1f);
	ssd_c(0xbb); ssd_d(0x1f);
	//ssd_setScondPrecReriod(0x08);
	ssd_c(0xb6); ssd_d(0x08);
	//ssd_setVCOMH(0x07);
	ssd_c(0xbe); ssd_d(0x07);
	//ssd_enableGlayScaleTable();
	//
	//ssd_setDispMode(SSD_DISPLAY_ON);
	ssd_c(0xa6);
	//ssd_exitPartialDisp();
	//ssd_setSleepMode(SSD_SLEEP_OFF);
	ssd_c(0xaf);
	//ssd_setDispMode(SSD_DISPLAY_REVERSE);
	//
	ssd_powerOn();	// vcc on
}


void ssd_clear()
{
	ssd_setColumnAddr(0x1c,0x5b);
	ssd_setRowAddr(0x00,0x3f);
	ssd_writeRAM();
	for(unsigned int i=0; i<30; i++){
		ssd_d(0xaa);
	}
	ssd_cs1();
	/*
	Set_Column_Address(0x1C,0x5B);
	Set_Row_Address(0x00,0x3F);
	Set_Write_RAM();
	digitalWrite(displaySelect,LOW);
	digitalWrite(displayDC,HIGH);
	for(unsigned int i=0; i<8192; i++){
		SPI.transfer(0x00);
	}
	digitalWrite(displaySelect,HIGH);
	*/
}

void ssd_put(U8 x, U8 y, U8 *d)
{
	
}