#ifndef SSD1322_H_INCLUDE
#define SSD1322_H_INCLUDE

#define ssd_clk0()	(SSD_PORT &= ~(1<<SSD_CLK))
#define ssd_clk1()	(SSD_PORT |= (1<<SSD_CLK))
#define ssd_cs0()	(SSD_PORT &= ~(1<<SSD_CS))
#define ssd_cs1()	(SSD_PORT |= (1<<SSD_CS))
#define ssd_din0()	(SSD_PORT &= ~(1<<SSD_DIN))
#define ssd_din1()	(SSD_PORT |= (1<<SSD_DIN))
#define ssd_din(D)	(SSD_PORT = (D)?(SSD_PORT|(1<<SSD_DIN)):(SSD_PORT & ~(1<<SSD_DIN)))
#define ssd_res0()	(SSD_PORT &= ~(1<<SSD_RES))
#define ssd_res1()	(SSD_PORT |= (1<<SSD_RES))
#define ssd_pow0()	(SSD_PORT &= ~(1<<SSD_POW))
#define ssd_pow1()	(SSD_PORT |= (1<<SSD_POW))
#define ssd_dc0()	(SSD_PORT &= ~(1<<SSD_DC))
#define ssd_dc1()	(SSD_PORT |= (1<<SSD_DC))
#define ssd_wc()	_delay_us(50)
#define ssd_wcs()	_delay_us(10)

//#define ssd_c(C)	(ssd_dc0(),ssd_cs0(),ssd_send(C),ssd_cs1(),ssd_dc1())
//#define ssd_d(C)	(ssd_dc1(),ssd_cs0(),ssd_send(C),ssd_cs1(),ssd_dc1())

void ssd_c(U8 d);
void ssd_d(U8 d);
void ssd_send(U8 c);
void ssd_reset();
void ssd_init();
void ssd_powerOn();
void ssd_powerOff();
void ssd_clear();

#define SSD_HORZADDRINC	0x00
#define SSD_VERTZDDRINC 0x01
#define SSD_DISABLE_COLADDR_REMAP	0x00
#define SSD_ENABLE_COLADDR_REMAP	0x02
#define SSD_DISABLE_NIBBLE_REMAP	0x00
#define SSD_ENABLE_NIBBLE_REMAP		0x04
#define SSD_UPORDER_SCAN			0x00
#define SSD_DOWNORDER_SCAN			0x10
#define SSD_DISABLE_COM_SPLIT		0x00
#define SSD_ENABLE_COM_SPLIT		0x20
#define SSD_DISABLE_DUALCOM_MODE	0x01
#define SSD_ENABLE_DUALCOM_MODE		0x11

#define SSD_DISPLAY_OFF				0xa4
#define SSD_DISPLAY_ON				0xa5
#define SSD_DISPLAY_NORMAL			0xa6
#define SSD_DISPLAY_REVERSE			0xa7

#define SSD_EXTERNAL_VDD			0x00
#define SSD_INTERNAL_VDD			0x01

#define SSD_SLEEP_ON				0xae
#define SSD_SLEEP_OFF				0xaf

#define SSD_EXTERNAL_VSL			0xa0
#define SSD_INTERNAL_VSL			0xa2
#define SSD_ENHANCED_LOW_GS			0xfd
#define SSD_NORMAL_GS				0xb5

#define SSD_INPUT_DISABLE			0x00
#define SSD_INPUT_ENABLE			0x01
#define SSD_OUTPUT_LOW				0x02
#define SSD_OUTPUT_HIGH				0x03

#define	ssd_enableGlayScaleTable()				(ssd_c(0x00))	/* Enable Glay Scale Table */
#define	ssd_setColumnAddr(start, end)			(ssd_c(0x15),ssd_d(start),ssd_d(end))	// Set Column Start End Address (CASET) 2
#define	ssd_writeRAM()							(ssd_c(0x5C))	// Enable MCU to write Data into RAM
#define	ssd_readRAM()							(ssd_c(0x5D))	// Enable MCU to read Data from RAM
#define	ssd_setRowAddr(start,end)				(ssd_c(0x75),ssd_d(start),ssd_d(end))	// Set Row start and end address
#define	ssd_setRemapAndDualComLineMode(p0,p1)	(ssd_c(0xA0),ssd_d(p0),ssd_d(p1))	// Set Re-map and Dual COM Line mode 2
#define	ssd_setDispStartLine(ln)				(ssd_c(0xA1),ssd_d(ln))	// Set Display Start Line 1
#define	ssd_setDispOffset(ln)					(ssd_c(0xA2),ssd_d(ln))	// Set Display Offset 1
#define	ssd_setDispMode(mode)					(ssd_c(mode))	// Set Display Mode (Entire Display OFF, all pixels turns OFF in GS level 0)
#define	ssd_enablePartialDisp(start,end)		(ssd_c(0xA8),ssd_d(start),ssd_d(end))	// Enable Partial Display 2
#define	ssd_exitPartialDisp()					(ssd_c(0xA9))	// Exit Partial Display 0
#define	ssd_selectFunction(vdd)					(ssd_c(0xAB),ssd_d(vdd))	// Function Selection 1
#define	ssd_setSleepMode(mode)					(ssd_c(mode))	// Sleep mode ON (Display OFF)
#define	ssd_setPhaseLength(p1len,p2len)			(ssd_c(0xB1),ssd_d((0x0f&((p1len)-5)/2+2)|((0x0f&p2len)<<4))	// Set Phase Length 1
#define	ssd_setPhaseLengthV(v)					(ssd_c(0xB1),ssd_d(v))	// Set Phase Length 1
#define	ssd_setFrontClockDiv(v)					(ssd_c(0xB3),ssd_d(v))	// Set Front Clock Divider / Oscillator Frequency
#define	ssd_setDispEnhacementA(p0,p1)			(ssd_c(0xB4),ssd_d(p0),ssd_d(p1))	// Display Enhancement A 2
#define	ssd_setGPIO(p0,p1)						(ssd_c(0xB5),ssd_d((p0)|(p1<<2)))	// Set GPIO 1
#define	ssd_setScondPrecReriod(v)				(ssd_c(0xB6),ssd_d(v))		// Set Second Pre-charge Period 1
#define	ssd_setGlayScaleTable(c0,c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14)	\
												(ssd_c(0xB8),\
												ssd_d(c0),ssd_d(c1),ssd_d(c2),ssd_d(c3),ssd_d(c4),\
												ssd_d(c5),ssd_d(c6),ssd_d(c7),ssd_d(c8),ssd_d(c9),\
												ssd_d(c10),ssd_d(c12),ssd_d(c13),ssd_d(c14),ssd_d(c15))	// Set Gray Scale Table 15
#define	ssd_selectDefaultTable()				(ssd_c(0xB9))	// Select Default Linear Gray Scale table 0
#define	ssd_setPrecVoltage(v)					(ssd_c(0xBB),ssd_d(v))	// Set Pre-charge voltage 1
#define	ssd_setVCOMH(v)							(ssd_c(0xBE),ssd_d(v))	// Set VCOMH 1
#define	ssd_setContrast(v)						(ssd_c(0xC1),ssd_d(v))	// Set Contrast Current 1
#define	ssd_setMasterContrast(v)				(ssd_c(0xC7),ssd_d(v))	// Master Contrast Current Control
#define	ssd_setMuxRatio(v)						(ssd_c(0xCA),ssd_d(v))	// Set MUX Ratio
#define	ssd_setDispEnhancementB(v)				(ssd_c(0xD1),ssd_d(v),ssd_d(0x20))	// Display Enhancement B 2
#define	ssd_setCommandLock(lc)					(ssd_c(0xFD),ssd_d((lc)?0x16:0x12))	// Command Lock (COMLCK) 1

#endif // SSD1322_H_INCLUDE
